/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.tsfile.common.cache.Accountable;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TimeseriesMetadata
implements Accountable {
    private long startOffsetOfChunkMetaDataList;
    private int chunkMetaDataListDataSize;
    private String measurementId;
    private TSDataType tsDataType;
    private Statistics<?> statistics;
    private boolean modified;
    protected IChunkMetadataLoader chunkMetadataLoader;
    private long ramSize;

    public TimeseriesMetadata() {
    }

    public TimeseriesMetadata(TimeseriesMetadata timeseriesMetadata) {
        this.startOffsetOfChunkMetaDataList = timeseriesMetadata.startOffsetOfChunkMetaDataList;
        this.chunkMetaDataListDataSize = timeseriesMetadata.chunkMetaDataListDataSize;
        this.measurementId = timeseriesMetadata.measurementId;
        this.tsDataType = timeseriesMetadata.tsDataType;
        this.statistics = timeseriesMetadata.statistics;
        this.modified = timeseriesMetadata.modified;
    }

    public static TimeseriesMetadata deserializeFrom(ByteBuffer buffer) {
        TimeseriesMetadata timeseriesMetaData = new TimeseriesMetadata();
        timeseriesMetaData.setMeasurementId(ReadWriteIOUtils.readString(buffer));
        timeseriesMetaData.setTSDataType(ReadWriteIOUtils.readDataType(buffer));
        timeseriesMetaData.setOffsetOfChunkMetaDataList(ReadWriteIOUtils.readLong(buffer));
        timeseriesMetaData.setDataSizeOfChunkMetaDataList(ReadWriteIOUtils.readInt(buffer));
        timeseriesMetaData.setStatistics(Statistics.deserialize(buffer, timeseriesMetaData.tsDataType));
        return timeseriesMetaData;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.measurementId, outputStream);
        byteLen += ReadWriteIOUtils.write(this.tsDataType, outputStream);
        byteLen += ReadWriteIOUtils.write(this.startOffsetOfChunkMetaDataList, outputStream);
        byteLen += ReadWriteIOUtils.write(this.chunkMetaDataListDataSize, outputStream);
        return byteLen += this.statistics.serialize(outputStream);
    }

    public long getOffsetOfChunkMetaDataList() {
        return this.startOffsetOfChunkMetaDataList;
    }

    public void setOffsetOfChunkMetaDataList(long position) {
        this.startOffsetOfChunkMetaDataList = position;
    }

    public String getMeasurementId() {
        return this.measurementId;
    }

    public void setMeasurementId(String measurementId) {
        this.measurementId = measurementId;
    }

    public int getDataSizeOfChunkMetaDataList() {
        return this.chunkMetaDataListDataSize;
    }

    public void setDataSizeOfChunkMetaDataList(int size) {
        this.chunkMetaDataListDataSize = size;
    }

    public TSDataType getTSDataType() {
        return this.tsDataType;
    }

    public void setTSDataType(TSDataType tsDataType) {
        this.tsDataType = tsDataType;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    public void setChunkMetadataLoader(IChunkMetadataLoader chunkMetadataLoader) {
        this.chunkMetadataLoader = chunkMetadataLoader;
    }

    public List<ChunkMetadata> loadChunkMetadataList() throws IOException {
        return this.chunkMetadataLoader.loadChunkMetadataList();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public void setRamSize(long size) {
        this.ramSize = size;
    }

    @Override
    public long getRamSize() {
        return this.ramSize;
    }
}

