/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.writer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.exception.write.TsFileNotCompleteException;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.write.writer.LocalTsFileOutput;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceAppendTsFileWriter
extends TsFileIOWriter {
    private long truncatePosition;
    private static Logger logger = LoggerFactory.getLogger(ForceAppendTsFileWriter.class);

    public ForceAppendTsFileWriter(File file) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{} writer is opened.", (Object)file.getName());
        }
        this.out = new LocalTsFileOutput(file, true);
        this.file = file;
        if (file.length() == 0L || !file.exists()) {
            throw new TsFileNotCompleteException("File " + file.getPath() + " is not a complete TsFile");
        }
        try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), true);){
            if (!reader.isComplete()) {
                throw new TsFileNotCompleteException("File " + file.getPath() + " is not a complete TsFile");
            }
            TsFileMetadata tsFileMetadata = reader.readFileMetadata();
            this.truncatePosition = tsFileMetadata.getMetaOffset();
            this.canWrite = true;
            this.versionInfo = tsFileMetadata.getVersionInfo();
            this.totalChunkNum = tsFileMetadata.getTotalChunkNum();
            this.invalidChunkNum = tsFileMetadata.getInvalidChunkNum();
            List<String> devices = reader.getAllDevices();
            for (String device : devices) {
                ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
                reader.readChunkMetadataInDevice(device).values().forEach(chunkMetadataList::addAll);
                ChunkGroupMetadata chunkGroupMetadata = new ChunkGroupMetadata(device, chunkMetadataList);
                this.chunkGroupMetadataList.add(chunkGroupMetadata);
            }
        }
    }

    public void doTruncate() throws IOException {
        this.out.truncate(this.truncatePosition);
    }

    public long getTruncatePosition() {
        return this.truncatePosition;
    }
}

