/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.record;

import java.util.List;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class Tablet {
    private static final int DEFAULT_SIZE = 1024;
    public String deviceId;
    private List<MeasurementSchema> schemas;
    public long[] timestamps;
    public Object[] values;
    public int rowSize;
    private int maxRowNumber;

    public Tablet(String deviceId, List<MeasurementSchema> timeseries) {
        this(deviceId, timeseries, 1024);
    }

    public Tablet(String deviceId, List<MeasurementSchema> schemas, int maxRowNumber) {
        this.deviceId = deviceId;
        this.schemas = schemas;
        this.maxRowNumber = maxRowNumber;
        this.createColumns();
        this.reset();
    }

    public List<MeasurementSchema> getSchemas() {
        return this.schemas;
    }

    public int getMaxRowNumber() {
        return this.maxRowNumber;
    }

    public void reset() {
        this.rowSize = 0;
    }

    private void createColumns() {
        this.timestamps = new long[this.maxRowNumber];
        this.values = new Object[this.schemas.size()];
        block8: for (int i = 0; i < this.schemas.size(); ++i) {
            TSDataType dataType = this.schemas.get(i).getType();
            switch (dataType) {
                case INT32: {
                    this.values[i] = new int[this.maxRowNumber];
                    continue block8;
                }
                case INT64: {
                    this.values[i] = new long[this.maxRowNumber];
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = new float[this.maxRowNumber];
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = new double[this.maxRowNumber];
                    continue block8;
                }
                case BOOLEAN: {
                    this.values[i] = new boolean[this.maxRowNumber];
                    continue block8;
                }
                case TEXT: {
                    this.values[i] = new Binary[this.maxRowNumber];
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", new Object[]{dataType}));
                }
            }
        }
    }

    public int getTimeBytesSize() {
        return this.rowSize * 8;
    }

    public int getValueBytesSize() {
        int valueOccupation = 0;
        block8: for (int i = 0; i < this.schemas.size(); ++i) {
            switch (this.schemas.get(i).getType()) {
                case BOOLEAN: {
                    valueOccupation += this.rowSize;
                    continue block8;
                }
                case INT32: {
                    valueOccupation += this.rowSize * 4;
                    continue block8;
                }
                case INT64: {
                    valueOccupation += this.rowSize * 8;
                    continue block8;
                }
                case FLOAT: {
                    valueOccupation += this.rowSize * 4;
                    continue block8;
                }
                case DOUBLE: {
                    valueOccupation += this.rowSize * 8;
                    continue block8;
                }
                case TEXT: {
                    valueOccupation += this.rowSize * 4;
                    for (Binary value : (Binary[])this.values[i]) {
                        valueOccupation += value.getLength();
                    }
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", new Object[]{this.schemas.get(i).getType()}));
                }
            }
        }
        return valueOccupation;
    }
}

