/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.timegenerator.node;

import java.io.IOException;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.Node;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.NodeType;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;

public class LeafNode
implements Node {
    private IBatchReader reader;
    private BatchData cacheData;
    private boolean hasCached;
    private long cachedTime;
    private Object cachedValue;

    public LeafNode(IBatchReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.hasCached) {
            return true;
        }
        if (this.cacheData != null && this.cacheData.hasCurrent()) {
            this.cachedTime = this.cacheData.currentTime();
            this.cachedValue = this.cacheData.currentValue();
            this.hasCached = true;
            return true;
        }
        if (this.reader.hasNextBatch()) {
            this.cacheData = this.reader.nextBatch();
            if (this.cacheData.hasCurrent()) {
                this.cachedTime = this.cacheData.currentTime();
                this.cachedValue = this.cacheData.currentValue();
                this.hasCached = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public long next() throws IOException {
        if (this.hasCached || this.hasNext()) {
            this.hasCached = false;
            this.cacheData.next();
            return this.cachedTime;
        }
        throw new IOException("no more data");
    }

    public boolean currentTimeIs(long time) {
        return this.cachedTime == time;
    }

    public Object currentValue() {
        return this.cachedValue;
    }

    @Override
    public NodeType getType() {
        return NodeType.LEAF;
    }
}

