/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.io.Serializable;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class Path
implements Serializable,
Comparable<Path> {
    private static final long serialVersionUID = 3405277066329298200L;
    private String measurement = null;
    private String alias = null;
    private String device = null;
    private String fullPath;
    private static final String illegalPathArgument = "Path parameter is null";

    public Path(StringContainer pathSc) {
        if (pathSc == null) {
            throw new IllegalArgumentException("input pathSc is null!");
        }
        this.init(pathSc.toString());
    }

    public Path(String pathSc) {
        if (pathSc == null) {
            throw new IllegalArgumentException(illegalPathArgument);
        }
        this.init(pathSc);
    }

    public Path(String[] pathSc) {
        if (pathSc == null) {
            throw new IllegalArgumentException(illegalPathArgument);
        }
        this.init(new StringContainer(pathSc, ".").toString());
    }

    public Path(String device, String measurement) {
        if (device == null || measurement == null) {
            throw new IllegalArgumentException(illegalPathArgument);
        }
        this.device = device;
        this.measurement = measurement;
        this.fullPath = device + "." + (measurement.contains(".") ? "\"" + measurement + "\"" : measurement);
    }

    private void init(String pathSc) {
        int i = 0;
        int j = 0;
        for (char c : pathSc.toCharArray()) {
            if (c == '\"') {
                ++i;
                continue;
            }
            if (c != '\'') continue;
            ++j;
        }
        if (i != 2 && i != 0 || j != 2 && j != 0) {
            throw new IllegalArgumentException("input pathSc single/double quotes error, not in pair or more than one pair!");
        }
        if (i == 2 && pathSc.length() - 1 != pathSc.lastIndexOf("\"") || j == 2 && pathSc.length() - 1 != pathSc.lastIndexOf("'")) {
            throw new IllegalArgumentException("input pathSc contains quoted string in the middle!");
        }
        if (i != 0 || j != 0) {
            String[] subStrs = i == 2 ? pathSc.split("\"") : pathSc.split("'");
            this.device = subStrs[0];
            if (!this.device.equals("")) {
                this.device = this.device.substring(0, subStrs[0].length() - 1);
            }
            this.measurement = subStrs[1];
            this.fullPath = pathSc;
        } else {
            StringContainer sc = new StringContainer(pathSc.split("\\."), ".");
            if (sc.size() <= 1) {
                this.device = "";
                this.fullPath = this.measurement = sc.toString();
            } else {
                this.device = sc.getSubStringContainer(0, -2).toString();
                this.measurement = sc.getSubString(-1);
                this.fullPath = sc.toString();
            }
        }
    }

    public static Path mergePath(Path prefix, Path suffix) {
        if (suffix.fullPath.equals("")) {
            return prefix;
        }
        if (prefix.fullPath.equals("")) {
            return suffix;
        }
        StringContainer sc = new StringContainer(".");
        sc.addTail(prefix);
        sc.addTail(suffix);
        return new Path(sc);
    }

    public static Path addPrefixPath(Path src, String prefix) {
        if (prefix.equals("")) {
            return src;
        }
        StringContainer sc = new StringContainer(".");
        sc.addTail(prefix);
        sc.addTail(src);
        return new Path(sc);
    }

    public static Path addPrefixPath(Path src, Path prefix) {
        return Path.addPrefixPath(src, prefix.fullPath);
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getDevice() {
        return this.device;
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getFullPathWithAlias() {
        return this.device + "." + this.alias;
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Path && this.fullPath.equals(((Path)obj).fullPath);
    }

    public boolean equals(String obj) {
        return this.fullPath.equals(obj);
    }

    @Override
    public int compareTo(Path path) {
        return this.fullPath.compareTo(path.getFullPath());
    }

    public String toString() {
        return this.fullPath;
    }

    public Path clone() {
        return new Path(this.fullPath);
    }

    public boolean startWith(String prefix) {
        return prefix != null && this.fullPath.startsWith(prefix);
    }

    public boolean startWith(Path prefix) {
        return this.startWith(prefix.fullPath);
    }
}

