/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.common.cache.Accountable;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ChunkMetadata
implements Accountable {
    private String measurementUid;
    private long offsetOfChunkHeader;
    private TSDataType tsDataType;
    private long version;
    private long deletedAt = Long.MIN_VALUE;
    private boolean modified;
    private IChunkLoader chunkLoader;
    private Statistics statistics;
    private boolean isFromOldTsFile = false;
    private long ramSize;
    private static final int CHUNK_METADATA_FIXED_RAM_SIZE = 80;

    private ChunkMetadata() {
    }

    public ChunkMetadata(String measurementUid, TSDataType tsDataType, long fileOffset, Statistics statistics) {
        this.measurementUid = measurementUid;
        this.tsDataType = tsDataType;
        this.offsetOfChunkHeader = fileOffset;
        this.statistics = statistics;
    }

    public String toString() {
        return String.format("measurementId: %s, datatype: %s, version: %d, deletedAt: %d, Statistics: %s", new Object[]{this.measurementUid, this.tsDataType, this.version, this.deletedAt, this.statistics});
    }

    public long getNumOfPoints() {
        return this.statistics.getCount();
    }

    public long getOffsetOfChunkHeader() {
        return this.offsetOfChunkHeader;
    }

    public String getMeasurementUid() {
        return this.measurementUid;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public long getStartTime() {
        return this.statistics.getStartTime();
    }

    public long getEndTime() {
        return this.statistics.getEndTime();
    }

    public TSDataType getDataType() {
        return this.tsDataType;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.measurementUid, outputStream);
        byteLen += ReadWriteIOUtils.write(this.offsetOfChunkHeader, outputStream);
        byteLen += ReadWriteIOUtils.write(this.tsDataType, outputStream);
        return byteLen += this.statistics.serialize(outputStream);
    }

    public static ChunkMetadata deserializeFrom(ByteBuffer buffer) {
        ChunkMetadata chunkMetaData = new ChunkMetadata();
        chunkMetaData.measurementUid = ReadWriteIOUtils.readString(buffer);
        chunkMetaData.offsetOfChunkHeader = ReadWriteIOUtils.readLong(buffer);
        chunkMetaData.tsDataType = ReadWriteIOUtils.readDataType(buffer);
        chunkMetaData.statistics = Statistics.deserialize(buffer, chunkMetaData.tsDataType);
        return chunkMetaData;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getDeletedAt() {
        return this.deletedAt;
    }

    public void setDeletedAt(long deletedAt) {
        this.deletedAt = deletedAt;
    }

    public IChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }

    public void setChunkLoader(IChunkLoader chunkLoader) {
        this.chunkLoader = chunkLoader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkMetadata that = (ChunkMetadata)o;
        return this.offsetOfChunkHeader == that.offsetOfChunkHeader && this.version == that.version && this.deletedAt == that.deletedAt && Objects.equals(this.measurementUid, that.measurementUid) && this.tsDataType == that.tsDataType && Objects.equals(this.statistics, that.statistics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.measurementUid, this.deletedAt, this.tsDataType, this.statistics, this.version, this.offsetOfChunkHeader});
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isFromOldTsFile() {
        return this.isFromOldTsFile;
    }

    public void setFromOldTsFile(boolean isFromOldTsFile) {
        this.isFromOldTsFile = isFromOldTsFile;
    }

    public long calculateRamSize() {
        return 80L + RamUsageEstimator.sizeOf(this.measurementUid) + this.statistics.calculateRamSize();
    }

    @Override
    public void setRamSize(long size) {
        this.ramSize = size;
    }

    @Override
    public long getRamSize() {
        return this.ramSize;
    }
}

