/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.encoding.common.EndianType;
import org.apache.iotdb.tsfile.encoding.decoder.DeltaBinaryDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.DoublePrecisionDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.FloatDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.IntRleDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.LongRleDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.PlainDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.RegularDataDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.SinglePrecisionDecoder;
import org.apache.iotdb.tsfile.exception.encoding.TsFileDecodingException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;

public abstract class Decoder {
    private TSEncoding type;

    public Decoder(TSEncoding type) {
        this.type = type;
    }

    public void setType(TSEncoding type) {
        this.type = type;
    }

    public TSEncoding getType() {
        return this.type;
    }

    public static Decoder getDecoderByType(TSEncoding type, TSDataType dataType) {
        if (type == TSEncoding.PLAIN) {
            return new PlainDecoder(EndianType.BIG_ENDIAN);
        }
        if (type == TSEncoding.RLE) {
            switch (dataType) {
                case BOOLEAN: 
                case INT32: {
                    return new IntRleDecoder(EndianType.BIG_ENDIAN);
                }
                case INT64: {
                    return new LongRleDecoder(EndianType.BIG_ENDIAN);
                }
                case FLOAT: 
                case DOUBLE: {
                    return new FloatDecoder(TSEncoding.valueOf(type.toString()), dataType);
                }
            }
            throw new TsFileDecodingException("Decoder not found:" + (Object)((Object)type) + " , DataType is :" + (Object)((Object)dataType));
        }
        if (type == TSEncoding.TS_2DIFF) {
            switch (dataType) {
                case INT32: {
                    return new DeltaBinaryDecoder.IntDeltaDecoder();
                }
                case INT64: {
                    return new DeltaBinaryDecoder.LongDeltaDecoder();
                }
                case FLOAT: 
                case DOUBLE: {
                    return new FloatDecoder(TSEncoding.valueOf(type.toString()), dataType);
                }
            }
            throw new TsFileDecodingException("Decoder not found:" + (Object)((Object)type) + " , DataType is :" + (Object)((Object)dataType));
        }
        if (type == TSEncoding.GORILLA) {
            switch (dataType) {
                case FLOAT: {
                    return new SinglePrecisionDecoder();
                }
                case DOUBLE: {
                    return new DoublePrecisionDecoder();
                }
            }
            throw new TsFileDecodingException("Decoder not found:" + (Object)((Object)type) + " , DataType is :" + (Object)((Object)dataType));
        }
        if (type == TSEncoding.REGULAR) {
            switch (dataType) {
                case INT32: {
                    return new RegularDataDecoder.IntRegularDecoder();
                }
                case INT64: {
                    return new RegularDataDecoder.LongRegularDecoder();
                }
            }
            throw new TsFileDecodingException("Decoder not found:" + (Object)((Object)type) + " , DataType is :" + (Object)((Object)dataType));
        }
        throw new TsFileDecodingException("Decoder not found:" + (Object)((Object)type) + " , DataType is :" + (Object)((Object)dataType));
    }

    public int readInt(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readInt is not supproted by Decoder");
    }

    public boolean readBoolean(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBoolean is not supproted by Decoder");
    }

    public short readShort(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readShort is not supproted by Decoder");
    }

    public long readLong(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readLong is not supproted by Decoder");
    }

    public float readFloat(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readFloat is not supproted by Decoder");
    }

    public double readDouble(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readDouble is not supproted by Decoder");
    }

    public Binary readBinary(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBinary is not supproted by Decoder");
    }

    public BigDecimal readBigDecimal(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBigDecimal is not supproted by Decoder");
    }

    public abstract boolean hasNext(ByteBuffer var1) throws IOException;

    public abstract void reset();
}

