/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.exception.compress.CompressionTypeNotSupportedException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public interface IUnCompressor {
    public static IUnCompressor getUnCompressor(CompressionType name) {
        if (name == null) {
            throw new CompressionTypeNotSupportedException("NULL");
        }
        switch (name) {
            case UNCOMPRESSED: {
                return new NoUnCompressor();
            }
            case SNAPPY: {
                return new SnappyUnCompressor();
            }
        }
        throw new CompressionTypeNotSupportedException(name.toString());
    }

    public int getUncompressedLength(byte[] var1, int var2, int var3) throws IOException;

    public int getUncompressedLength(ByteBuffer var1) throws IOException;

    public byte[] uncompress(byte[] var1);

    public int uncompress(byte[] var1, int var2, int var3, byte[] var4, int var5) throws IOException;

    public int uncompress(ByteBuffer var1, ByteBuffer var2) throws IOException;

    public CompressionType getCodecName();

    public static class SnappyUnCompressor
    implements IUnCompressor {
        private static final Logger logger = LoggerFactory.getLogger(SnappyUnCompressor.class);

        @Override
        public int getUncompressedLength(byte[] array, int offset, int length) throws IOException {
            return Snappy.uncompressedLength((byte[])array, (int)offset, (int)length);
        }

        @Override
        public int getUncompressedLength(ByteBuffer buffer) throws IOException {
            return Snappy.uncompressedLength((ByteBuffer)buffer);
        }

        @Override
        public byte[] uncompress(byte[] bytes) {
            if (bytes == null) {
                return new byte[0];
            }
            try {
                return Snappy.uncompress((byte[])bytes);
            }
            catch (IOException e) {
                logger.error("tsfile-compression SnappyUnCompressor: errors occurs when uncompress input byte", (Throwable)e);
                return new byte[0];
            }
        }

        @Override
        public int uncompress(byte[] byteArray, int offset, int length, byte[] output, int outOffset) throws IOException {
            Snappy.uncompressedLength((byte[])byteArray, (int)offset, (int)length);
            return Snappy.uncompress((byte[])byteArray, (int)offset, (int)length, (byte[])output, (int)outOffset);
        }

        @Override
        public int uncompress(ByteBuffer compressed, ByteBuffer uncompressed) {
            if (compressed == null || !compressed.hasRemaining()) {
                return 0;
            }
            try {
                return Snappy.uncompress((ByteBuffer)compressed, (ByteBuffer)uncompressed);
            }
            catch (IOException e) {
                logger.error("tsfile-compression SnappyUnCompressor: errors occurs when uncompress input byte", (Throwable)e);
                return 0;
            }
        }

        @Override
        public CompressionType getCodecName() {
            return CompressionType.SNAPPY;
        }
    }

    public static class NoUnCompressor
    implements IUnCompressor {
        @Override
        public int getUncompressedLength(byte[] array, int offset, int length) {
            return length;
        }

        @Override
        public int getUncompressedLength(ByteBuffer buffer) {
            return buffer.remaining();
        }

        @Override
        public byte[] uncompress(byte[] byteArray) {
            return byteArray;
        }

        @Override
        public int uncompress(byte[] byteArray, int offset, int length, byte[] output, int outOffset) throws IOException {
            throw new IOException("NoUnCompressor does not support this method.");
        }

        @Override
        public int uncompress(ByteBuffer compressed, ByteBuffer uncompressed) throws IOException {
            throw new IOException("NoUnCompressor does not support this method.");
        }

        @Override
        public CompressionType getCodecName() {
            return CompressionType.UNCOMPRESSED;
        }
    }
}

