/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli;

import java.io.Console;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.cli.AbstractCli;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.jdbc.Config;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.thrift.TException;

public class WinCli
extends AbstractCli {
    private static CommandLine commandLine;

    public static void main(String[] args) throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Options options = WinCli.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(88);
        commandLine = null;
        if (args == null || args.length == 0) {
            WinCli.println("Require more params input, please check the following hint.");
            hf.printHelp("IoTDB", options, true);
            return;
        }
        WinCli.init();
        String[] newArgs = WinCli.removePasswordArgs(args);
        String[] newArgs2 = WinCli.processExecuteArgs(newArgs);
        boolean continues = WinCli.parseCommandLine(options, newArgs2, hf);
        if (!continues) {
            return;
        }
        WinCli.serve();
    }

    private static String readPassword() {
        Console c = System.console();
        if (c == null) {
            WinCli.print("IoTDB> please input password: ");
            Scanner scanner = new Scanner(System.in);
            return scanner.nextLine();
        }
        return new String(c.readPassword("IoTDB> please input password: ", new Object[0]));
    }

    private static boolean parseCommandLine(Options options, String[] newArgs, HelpFormatter hf) {
        try {
            DefaultParser parser = new DefaultParser();
            commandLine = parser.parse(options, newArgs);
            if (commandLine.hasOption("help")) {
                hf.printHelp("IoTDB", options, true);
                return false;
            }
            if (commandLine.hasOption("c")) {
                Config.rpcThriftCompressionEnable = true;
            }
            if (commandLine.hasOption("disableISO8601")) {
                WinCli.setTimeFormat("long");
            }
            if (commandLine.hasOption("maxPRC") && (maxPrintRowCount = Integer.parseInt(commandLine.getOptionValue("maxPRC"))) < 0) {
                maxPrintRowCount = Integer.MAX_VALUE;
            }
        }
        catch (ParseException e) {
            WinCli.println("Require more params input, please check the following hint.");
            hf.printHelp("IoTDB", options, true);
            return false;
        }
        catch (NumberFormatException e) {
            WinCli.println("IoTDB> error format of max print row count, it should be number");
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static void serve() {
        block19: {
            try {
                scanner = new Scanner(System.in);
                try {
                    block18: {
                        WinCli.host = WinCli.checkRequiredArg("h", "host", WinCli.commandLine, false, WinCli.host);
                        WinCli.port = WinCli.checkRequiredArg("p", "port", WinCli.commandLine, false, WinCli.port);
                        WinCli.username = WinCli.checkRequiredArg("u", "username", WinCli.commandLine, true, null);
                        WinCli.password = WinCli.commandLine.getOptionValue("pw");
                        if (WinCli.password == null) {
                            WinCli.password = WinCli.readPassword();
                        }
                        if (!WinCli.hasExecuteSQL) ** GOTO lbl32
                        connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://" + WinCli.host + ":" + WinCli.port + "/", WinCli.username, WinCli.password);
                        try {
                            WinCli.properties = connection.getServerProperties();
                            WinCli.AGGREGRATE_TIME_LIST.addAll(WinCli.properties.getSupportedTimeAggregationOperations());
                            WinCli.processCommand(WinCli.execute, connection);
                            if (connection == null) break block18;
                        }
                        catch (Throwable var2_6) {
                            try {
                                if (connection != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable var3_8) {
                                        var2_6.addSuppressed(var3_8);
                                    }
                                }
                                throw var2_6;
                            }
                            catch (SQLException e) {
                                WinCli.println("IoTDB> can't execute sql because" + e.getMessage());
                            }
lbl32:
                            // 2 sources

                            WinCli.receiveCommands(scanner);
                            break block19;
                        }
                        connection.close();
                    }
                    return;
                }
                finally {
                    scanner.close();
                }
            }
            catch (ArgsErrorException e) {
                WinCli.println("IoTDB> input params error because" + e.getMessage());
            }
            catch (Exception e) {
                WinCli.println("IoTDB> exit cli with error " + e.getMessage());
            }
        }
    }

    private static void receiveCommands(Scanner scanner) throws TException {
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://" + host + ":" + port + "/", username, password);){
            String s;
            boolean continues;
            properties = connection.getServerProperties();
            AGGREGRATE_TIME_LIST.addAll(properties.getSupportedTimeAggregationOperations());
            TIMESTAMP_PRECISION = properties.getTimestampPrecision();
            WinCli.echoStarting();
            WinCli.displayLogo(properties.getVersion());
            WinCli.println("IoTDB> login successfully");
            do {
                WinCli.print("IoTDB> ");
            } while (continues = WinCli.processCommand(s = scanner.nextLine(), connection));
        }
        catch (SQLException e) {
            WinCli.println(String.format("%s> %s Host is %s, port is %s.", "IoTDB", e.getMessage(), host, port));
        }
    }
}

