/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.jdbc.AbstractIoTDBJDBCResultSet;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSQueryNonAlignDataSet;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;

public class IoTDBNonAlignJDBCResultSet
extends AbstractIoTDBJDBCResultSet {
    private static final int TIMESTAMP_STR_LENGTH = 4;
    private static final String EMPTY_STR = "";
    private TSQueryNonAlignDataSet tsQueryNonAlignDataSet;
    private byte[][] times;

    IoTDBNonAlignJDBCResultSet(Statement statement, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, boolean ignoreTimeStamp, TSIService.Iface client, String sql, long queryId, long sessionId, TSQueryNonAlignDataSet dataset) throws SQLException {
        super(statement, columnNameList, columnTypeList, columnNameIndex, ignoreTimeStamp, client, sql, queryId, sessionId);
        int i;
        this.times = new byte[columnNameList.size()][8];
        this.ioTDBRpcDataSet.columnNameList = new ArrayList();
        this.ioTDBRpcDataSet.columnOrdinalMap = new HashMap();
        this.ioTDBRpcDataSet.columnOrdinalMap.put("Time", 1);
        this.ioTDBRpcDataSet.columnTypeDeduplicatedList = new ArrayList();
        this.ioTDBRpcDataSet.columnTypeDeduplicatedList = new ArrayList(columnNameIndex.size());
        for (i = 0; i < columnNameIndex.size(); ++i) {
            this.ioTDBRpcDataSet.columnTypeDeduplicatedList.add(null);
        }
        for (i = 0; i < columnNameList.size(); ++i) {
            String name = columnNameList.get(i);
            this.ioTDBRpcDataSet.columnNameList.add("Time" + name);
            this.ioTDBRpcDataSet.columnNameList.add(name);
            if (this.ioTDBRpcDataSet.columnOrdinalMap.containsKey(name)) continue;
            int index = columnNameIndex.get(name);
            this.ioTDBRpcDataSet.columnOrdinalMap.put(name, index + 2);
            this.ioTDBRpcDataSet.columnTypeDeduplicatedList.set(index, TSDataType.valueOf((String)columnTypeList.get(i)));
        }
        this.tsQueryNonAlignDataSet = dataset;
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        this.checkRecord();
        if (columnName.startsWith("Time")) {
            String column = columnName.substring(4);
            int index = (Integer)this.ioTDBRpcDataSet.columnOrdinalMap.get(column) - 2;
            if (this.times[index] != null) {
                return BytesUtils.bytesToLong((byte[])this.times[index]);
            }
            throw new SQLException(String.format("The value got by %s (column name) is NULL.", columnName));
        }
        int index = (Integer)this.ioTDBRpcDataSet.columnOrdinalMap.get(columnName) - 2;
        if (this.ioTDBRpcDataSet.values[index] != null) {
            return BytesUtils.bytesToLong((byte[])this.ioTDBRpcDataSet.values[index]);
        }
        throw new SQLException(String.format("The value got by %s (column name) is NULL.", columnName));
    }

    @Override
    protected boolean fetchResults() throws SQLException {
        TSFetchResultsReq req = new TSFetchResultsReq(this.ioTDBRpcDataSet.sessionId, this.ioTDBRpcDataSet.sql, this.ioTDBRpcDataSet.fetchSize, this.ioTDBRpcDataSet.queryId, false);
        try {
            TSFetchResultsResp resp = this.ioTDBRpcDataSet.client.fetchResults(req);
            try {
                RpcUtils.verifySuccess((TSStatus)resp.getStatus());
            }
            catch (StatementExecutionException e) {
                throw new IoTDBSQLException(e.getMessage(), resp.getStatus());
            }
            if (!resp.hasResultSet) {
                this.ioTDBRpcDataSet.emptyResultSet = true;
            } else {
                this.tsQueryNonAlignDataSet = resp.getNonAlignQueryDataSet();
                if (this.tsQueryNonAlignDataSet == null) {
                    return false;
                }
            }
            return resp.hasResultSet;
        }
        catch (TException e) {
            throw new SQLException("Cannot fetch result from server, because of network connection: {} ", e);
        }
    }

    @Override
    protected boolean hasCachedResults() {
        return this.tsQueryNonAlignDataSet != null && this.hasTimesRemaining();
    }

    private boolean hasTimesRemaining() {
        for (ByteBuffer time : this.tsQueryNonAlignDataSet.timeList) {
            if (!time.hasRemaining()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void constructOneRow() {
        for (int i = 0; i < this.tsQueryNonAlignDataSet.timeList.size(); ++i) {
            this.times[i] = null;
            this.ioTDBRpcDataSet.values[i] = null;
            if (((ByteBuffer)this.tsQueryNonAlignDataSet.timeList.get(i)).remaining() >= 8) {
                this.times[i] = new byte[8];
                ((ByteBuffer)this.tsQueryNonAlignDataSet.timeList.get(i)).get(this.times[i]);
                ByteBuffer valueBuffer = (ByteBuffer)this.tsQueryNonAlignDataSet.valueList.get(i);
                TSDataType dataType = (TSDataType)this.ioTDBRpcDataSet.columnTypeDeduplicatedList.get(i);
                switch (dataType) {
                    case BOOLEAN: {
                        this.ioTDBRpcDataSet.values[i] = new byte[1];
                        valueBuffer.get(this.ioTDBRpcDataSet.values[i]);
                        break;
                    }
                    case INT32: {
                        this.ioTDBRpcDataSet.values[i] = new byte[4];
                        valueBuffer.get(this.ioTDBRpcDataSet.values[i]);
                        break;
                    }
                    case INT64: {
                        this.ioTDBRpcDataSet.values[i] = new byte[8];
                        valueBuffer.get(this.ioTDBRpcDataSet.values[i]);
                        break;
                    }
                    case FLOAT: {
                        this.ioTDBRpcDataSet.values[i] = new byte[4];
                        valueBuffer.get(this.ioTDBRpcDataSet.values[i]);
                        break;
                    }
                    case DOUBLE: {
                        this.ioTDBRpcDataSet.values[i] = new byte[8];
                        valueBuffer.get(this.ioTDBRpcDataSet.values[i]);
                        break;
                    }
                    case TEXT: {
                        int length = valueBuffer.getInt();
                        this.ioTDBRpcDataSet.values[i] = ReadWriteIOUtils.readBytes((ByteBuffer)valueBuffer, (int)length);
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.ioTDBRpcDataSet.columnTypeDeduplicatedList.get(i)));
                    }
                }
                continue;
            }
            this.ioTDBRpcDataSet.values[i] = EMPTY_STR.getBytes();
        }
    }

    @Override
    protected void checkRecord() throws SQLException {
        if (Objects.isNull(this.tsQueryNonAlignDataSet)) {
            throw new SQLException("No record remains");
        }
    }

    @Override
    protected String getValueByName(String columnName) throws SQLException {
        this.checkRecord();
        if (columnName.startsWith("Time")) {
            String column = columnName.substring(4);
            int index = (Integer)this.ioTDBRpcDataSet.columnOrdinalMap.get(column) - 2;
            if (this.times[index] == null || this.times[index].length == 0) {
                return null;
            }
            return String.valueOf(BytesUtils.bytesToLong((byte[])this.times[index]));
        }
        int index = (Integer)this.ioTDBRpcDataSet.columnOrdinalMap.get(columnName) - 2;
        if (index < 0 || index >= this.ioTDBRpcDataSet.values.length || this.ioTDBRpcDataSet.values[index] == null || this.ioTDBRpcDataSet.values[index].length < 1) {
            return null;
        }
        return this.ioTDBRpcDataSet.getString(index, (TSDataType)this.ioTDBRpcDataSet.columnTypeDeduplicatedList.get(index), this.ioTDBRpcDataSet.values);
    }
}

