/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    private static final Logger logger = LoggerFactory.getLogger(SchemaUtils.class);

    private SchemaUtils() {
    }

    public static void registerTimeseries(MeasurementSchema schema) {
        try {
            logger.debug("Registering timeseries {}", (Object)schema);
            String path = schema.getMeasurementId();
            TSDataType dataType = schema.getType();
            TSEncoding encoding = schema.getEncodingType();
            CompressionType compressionType = schema.getCompressor();
            MManager.getInstance().createTimeseries(path, dataType, encoding, compressionType, Collections.emptyMap());
        }
        catch (PathAlreadyExistException path) {
        }
        catch (MetadataException e) {
            logger.error("Cannot create timeseries {} in snapshot, ignored", (Object)schema.getMeasurementId(), (Object)e);
        }
    }

    public static List<TSDataType> getSeriesTypesByPath(Collection<Path> paths) throws MetadataException {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Path path : paths) {
            dataTypes.add(MManager.getInstance().getSeriesType(path.getFullPath()));
        }
        return dataTypes;
    }

    public static List<TSDataType> getSeriesTypesByString(Collection<String> paths, String aggregation) throws MetadataException {
        TSDataType dataType = SchemaUtils.getAggregationType(aggregation);
        if (dataType != null) {
            return Collections.nCopies(paths.size(), dataType);
        }
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (String path : paths) {
            dataTypes.add(MManager.getInstance().getSeriesType(path));
        }
        return dataTypes;
    }

    public static List<TSDataType> getSeriesTypesByPath(Collection<Path> paths, String aggregation) throws MetadataException {
        TSDataType dataType = SchemaUtils.getAggregationType(aggregation);
        if (dataType != null) {
            return Collections.nCopies(paths.size(), dataType);
        }
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Path path : paths) {
            dataTypes.add(MManager.getInstance().getSeriesType(path.getFullPath()));
        }
        return dataTypes;
    }

    public static List<TSDataType> getSeriesTypesByPath(List<Path> paths, List<String> aggregations) throws MetadataException {
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < paths.size(); ++i) {
            TSDataType dataType = SchemaUtils.getAggregationType(aggregations.get(i));
            if (dataType != null) {
                tsDataTypes.add(dataType);
                continue;
            }
            tsDataTypes.add(MManager.getInstance().getSeriesType(paths.get(i).getFullPath()));
        }
        return tsDataTypes;
    }

    public static TSDataType getAggregationType(String aggregation) throws MetadataException {
        if (aggregation == null) {
            return null;
        }
        switch (aggregation.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "count": {
                return TSDataType.INT64;
            }
            case "last_value": 
            case "first_value": 
            case "min_value": 
            case "max_value": {
                return null;
            }
            case "avg": 
            case "sum": {
                return TSDataType.DOUBLE;
            }
        }
        throw new MetadataException("aggregate does not support " + aggregation + " function.");
    }
}

