/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.List;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;

public class QueryUtils {
    private QueryUtils() {
    }

    public static void modifyChunkMetaData(List<ChunkMetadata> chunkMetaData, List<Modification> modifications) {
        int modIndex = 0;
        for (int metaIndex = 0; metaIndex < chunkMetaData.size(); ++metaIndex) {
            ChunkMetadata metaData2 = chunkMetaData.get(metaIndex);
            for (int j = modIndex; j < modifications.size(); ++j) {
                Modification modification = modifications.get(j);
                if (modification.getVersionNum() > metaData2.getVersion()) {
                    modIndex = QueryUtils.doModifyChunkMetaData(modification, metaData2) ? j : modIndex;
                    continue;
                }
                ++modIndex;
            }
        }
        chunkMetaData.removeIf(metaData -> {
            if (metaData.getDeletedAt() >= metaData.getEndTime()) {
                return true;
            }
            if (metaData.getDeletedAt() >= metaData.getStartTime()) {
                metaData.setModified(true);
            }
            return false;
        });
    }

    private static boolean doModifyChunkMetaData(Modification modification, ChunkMetadata metaData) {
        if (modification instanceof Deletion) {
            Deletion deletion = (Deletion)modification;
            if (metaData.getDeletedAt() < deletion.getTimestamp()) {
                metaData.setDeletedAt(deletion.getTimestamp());
                return true;
            }
        }
        return false;
    }

    public static void filterQueryDataSource(QueryDataSource queryDataSource, TsFileFilter fileFilter) {
        if (fileFilter == null) {
            return;
        }
        List<TsFileResource> seqResources = queryDataSource.getSeqResources();
        List<TsFileResource> unseqResources = queryDataSource.getUnseqResources();
        seqResources.removeIf(fileFilter::fileNotSatisfy);
        unseqResources.removeIf(fileFilter::fileNotSatisfy);
    }
}

