/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.logvisual.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.iotdb.db.tools.logvisual.TimeSeriesStatistics;
import org.apache.iotdb.db.tools.logvisual.gui.ClosableTab;

class ResultStatisticTab
extends ClosableTab {
    private TableModel tableModel;
    private JTable table = new JTable();

    ResultStatisticTab(String planName, Map<String, List<TimeSeriesStatistics>> timeseriesStatistics, ClosableTab.TabCloseCallBack closeCallBack) {
        super(planName, closeCallBack);
        Box box = Box.createVerticalBox();
        box.add(this.table.getTableHeader());
        box.add(this.table);
        JScrollPane scrollPane = new JScrollPane(box);
        scrollPane.setLocation(0, 100);
        scrollPane.setSize(800, 600);
        this.add(scrollPane);
        Object[] header = TimeSeriesStatistics.HEADER;
        ArrayList<TimeSeriesStatistics> allStatistics = new ArrayList<TimeSeriesStatistics>();
        for (List<TimeSeriesStatistics> seriesStatistics : timeseriesStatistics.values()) {
            allStatistics.addAll(seriesStatistics);
        }
        allStatistics.sort(Comparator.comparing(TimeSeriesStatistics::getName));
        Object[][] data = new Object[allStatistics.size()][];
        for (int i = 0; i < allStatistics.size(); ++i) {
            data[i] = ((TimeSeriesStatistics)allStatistics.get(i)).toArray();
        }
        this.tableModel = new DefaultTableModel(data, header);
        this.table.setModel(this.tableModel);
        this.table.setRowSorter(new TableRowSorter<TableModel>(this.tableModel));
    }
}

