/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.logvisual.gui;

import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.iotdb.db.tools.logvisual.LogEntry;
import org.apache.iotdb.db.tools.logvisual.VisualUtils;
import org.apache.iotdb.db.tools.logvisual.VisualizationPlan;

public class PlanDetailPanel
extends JScrollPane {
    private VisualizationPlan plan;
    private JTextField nameField = new JTextField();
    private JTextField patternField = new JTextField();
    private JTextField measurementsField = new JTextField();
    private JTextField legendsField = new JTextField();
    private JTextField tagField = new JTextField();
    private JTextField levelField = new JTextField();
    private JTextField threadNameField = new JTextField();
    private JTextField classNameField = new JTextField();
    private JTextField lineNumField = new JTextField();
    private JTextField datePatternField = new JTextField();
    private JTextField startDateField = new JTextField();
    private JTextField endDateField = new JTextField();

    PlanDetailPanel() {
        super(null, 22, 30);
        this.setBorder(BorderFactory.createTitledBorder("Plan detail"));
        this.nameField.setBorder(BorderFactory.createTitledBorder("Plan name"));
        this.patternField.setBorder(BorderFactory.createTitledBorder("Content Pattern"));
        this.measurementsField.setBorder(BorderFactory.createTitledBorder("Measurement positions"));
        this.legendsField.setBorder(BorderFactory.createTitledBorder("Legends"));
        this.tagField.setBorder(BorderFactory.createTitledBorder("Tag positions"));
        this.levelField.setBorder(BorderFactory.createTitledBorder("Log level"));
        this.threadNameField.setBorder(BorderFactory.createTitledBorder("Allowed thread names"));
        this.classNameField.setBorder(BorderFactory.createTitledBorder("Allowed class names"));
        this.lineNumField.setBorder(BorderFactory.createTitledBorder("Allowed line numbers"));
        this.datePatternField.setBorder(BorderFactory.createTitledBorder("Date pattern"));
        this.startDateField.setBorder(BorderFactory.createTitledBorder("Start date"));
        this.endDateField.setBorder(BorderFactory.createTitledBorder("End date"));
        Box box = Box.createVerticalBox();
        box.add(this.nameField);
        box.add(this.patternField);
        box.add(this.measurementsField);
        box.add(this.legendsField);
        box.add(this.tagField);
        box.add(this.levelField);
        box.add(this.threadNameField);
        box.add(this.classNameField);
        box.add(this.lineNumField);
        box.add(this.datePatternField);
        box.add(this.startDateField);
        box.add(this.endDateField);
        this.setViewportView(box);
    }

    public void setPlan(VisualizationPlan plan) {
        this.plan = plan;
        this.updateFields();
    }

    private void resetFields() {
        this.nameField.setText("");
        this.patternField.setText("");
        this.measurementsField.setText("");
        this.legendsField.setText("");
        this.tagField.setText("");
        this.levelField.setText("");
        this.threadNameField.setText("");
        this.classNameField.setText("");
        this.lineNumField.setText("");
        this.datePatternField.setText("");
        this.startDateField.setText("");
        this.endDateField.setText("");
    }

    private void updateFields() {
        this.resetFields();
        if (this.plan == null) {
            return;
        }
        this.nameField.setText(this.plan.getName());
        this.patternField.setText(this.plan.getContentPattern().pattern());
        if (this.plan.getMeasurementPositions() != null) {
            this.measurementsField.setText(VisualUtils.intArrayToString(this.plan.getMeasurementPositions()));
        }
        if (this.plan.getLegends() != null) {
            this.legendsField.setText(String.join((CharSequence)",", this.plan.getLegends()));
        }
        if (this.plan.getTagPositions() != null) {
            this.tagField.setText(VisualUtils.intArrayToString(this.plan.getTagPositions()));
        }
        this.levelField.setText(this.plan.getLogFilter().getMinLevel().name());
        if (this.plan.getLogFilter().getThreadNameWhiteList() != null) {
            this.threadNameField.setText(String.join((CharSequence)",", this.plan.getLogFilter().getThreadNameWhiteList()));
        }
        if (this.plan.getLogFilter().getClassNameWhiteList() != null) {
            this.classNameField.setText(String.join((CharSequence)",", this.plan.getLogFilter().getClassNameWhiteList()));
        }
        if (this.plan.getLogFilter().getLineNumWhiteList() != null) {
            this.lineNumField.setText(VisualUtils.intArrayToString(this.plan.getLogFilter().getLineNumWhiteList()));
        }
        if (this.plan.getLogFilter().getDatePattern() != null) {
            SimpleDateFormat datePatten = (SimpleDateFormat)this.plan.getLogFilter().getDatePattern();
            this.datePatternField.setText(datePatten.toPattern());
            if (this.plan.getLogFilter().getStartDate() != null) {
                this.startDateField.setText(datePatten.format(this.plan.getLogFilter().getStartDate()));
            }
            if (this.plan.getLogFilter().getEndDate() != null) {
                this.endDateField.setText(datePatten.format(this.plan.getLogFilter().getEndDate()));
            }
        }
    }

    public void updatePlan() {
        if (this.plan == null) {
            return;
        }
        String name = this.nameField.getText();
        String contentPattern = this.patternField.getText();
        String measurementPositions = this.measurementsField.getText();
        String legends = this.legendsField.getText();
        String tagPositions = this.tagField.getText();
        String logLevel = this.levelField.getText();
        String allowedThreads = this.threadNameField.getText();
        String allowedClasses = this.classNameField.getText();
        String allowedLineNums = this.lineNumField.getText();
        String datePattern = this.datePatternField.getText();
        String startDate = this.startDateField.getText();
        String endDate = this.endDateField.getText();
        if (name.matches("\\s*")) {
            JOptionPane.showMessageDialog(this, "Name cannot be empty");
            return;
        }
        if (contentPattern.matches("\\s*")) {
            JOptionPane.showMessageDialog(this, "Content pattern cannot be empty");
            return;
        }
        if (measurementPositions.matches("\\s*")) {
            measurementPositions = null;
        }
        if (legends.matches("\\s*")) {
            legends = null;
        }
        if (tagPositions.matches("\\s*")) {
            tagPositions = null;
        }
        if (logLevel.matches("\\s*")) {
            logLevel = LogEntry.LogLevel.DEBUG.name();
        }
        if (allowedThreads.matches("\\s*")) {
            allowedThreads = null;
        }
        if (allowedClasses.matches("\\s*")) {
            allowedClasses = null;
        }
        if (allowedLineNums.matches("\\s*")) {
            allowedLineNums = null;
        }
        if (datePattern.matches("\\s*")) {
            datePattern = null;
        }
        if (startDate.matches("\\s*")) {
            startDate = null;
        }
        if (endDate.matches("\\s*")) {
            endDate = null;
        }
        if ((startDate != null || endDate != null) && datePattern == null) {
            JOptionPane.showMessageDialog(this, "Date pattern cannot be empty if either start date or end date is not empty");
            return;
        }
        try {
            this.plan.setName(name);
            this.plan.setContentPattern(Pattern.compile(contentPattern));
            this.plan.setMeasurementPositions(VisualUtils.parseIntArray(measurementPositions));
            this.plan.setLegends(legends != null ? legends.split(",") : null);
            this.plan.setTagPositions(VisualUtils.parseIntArray(tagPositions));
            this.plan.getLogFilter().setClassNameWhiteList(allowedClasses != null ? allowedClasses.split(",") : null);
            this.plan.getLogFilter().setThreadNameWhiteList(allowedThreads != null ? allowedThreads.split(",") : null);
            this.plan.getLogFilter().setLineNumWhiteList(VisualUtils.parseIntArray(allowedLineNums));
            this.plan.getLogFilter().setMinLevel(LogEntry.LogLevel.valueOf(logLevel));
            SimpleDateFormat simpleDateFormat = datePattern != null ? new SimpleDateFormat(datePattern) : null;
            this.plan.getLogFilter().setDatePattern(simpleDateFormat);
            this.plan.getLogFilter().setStartDate(startDate != null && simpleDateFormat != null ? simpleDateFormat.parse(startDate) : null);
            this.plan.getLogFilter().setEndDate(endDate != null && simpleDateFormat != null ? simpleDateFormat.parse(endDate) : null);
            this.plan.saveAsFile();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }
}

