/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.logvisual;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;

public class TimeSeriesStatistics {
    public static final String[] HEADER = new String[]{"name", "count", "meanInterval", "maxInterval", "minInterval", "meanVal", "maxVal", "minVal", "valSum"};
    private String name;
    private int size = 0;
    private double meanInterval = 0.0;
    private long maxInterval = Long.MIN_VALUE;
    private long minInterval = Long.MAX_VALUE;
    private double meanVal = 0.0;
    private double maxVal = Double.MIN_VALUE;
    private double minVal = Double.MAX_VALUE;
    private double valSum = 0.0;
    private Object[] statisticArray;

    TimeSeriesStatistics(TimeSeries timeSeries) {
        Date lastDate = null;
        this.name = (String)((Object)timeSeries.getKey());
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            TimeSeriesDataItem dataItem = timeSeries.getDataItem(i);
            Date currDate = dataItem.getPeriod().getStart();
            double value = dataItem.getValue().doubleValue();
            if (lastDate == null) {
                lastDate = currDate;
            } else {
                long interval = currDate.getTime() - lastDate.getTime();
                lastDate = currDate;
                this.meanInterval = (this.meanInterval * (double)this.size + (double)interval) / (double)(this.size + 1);
                this.maxInterval = this.maxInterval < interval ? interval : this.maxInterval;
                this.minInterval = this.minInterval < interval ? this.minInterval : interval;
            }
            this.meanVal = (this.meanVal * (double)this.size + value) / (double)(this.size + 1);
            this.maxVal = this.maxVal < value ? value : this.maxVal;
            this.minVal = this.minVal < value ? this.minVal : value;
            this.valSum += value;
            ++this.size;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public Object[] toArray() {
        if (this.statisticArray != null) {
            return this.statisticArray;
        }
        this.statisticArray = new Object[HEADER.length];
        int i = 0;
        this.statisticArray[i++] = this.name;
        this.statisticArray[i++] = this.size;
        this.statisticArray[i++] = this.meanInterval;
        this.statisticArray[i++] = this.maxInterval;
        this.statisticArray[i++] = this.minInterval;
        this.statisticArray[i++] = this.meanVal;
        this.statisticArray[i++] = this.maxVal;
        this.statisticArray[i++] = this.minVal;
        this.statisticArray[i] = this.valSum;
        return this.statisticArray;
    }

    public static void serializeHeader(Writer writer) throws IOException {
        writer.write(String.join((CharSequence)",", HEADER) + "\n");
    }

    public void serialize(Writer writer) throws IOException {
        Object[] statArray = this.toArray();
        StringBuilder builder = new StringBuilder(statArray[0].toString());
        for (int i = 1; i < statArray.length; ++i) {
            builder.append(",").append(statArray[i]);
        }
        builder.append("\n");
        writer.write(builder.toString());
    }
}

