/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.logvisual;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.iotdb.db.tools.logvisual.LogEntry;
import org.apache.iotdb.db.tools.logvisual.VisualUtils;

public class LogFilter {
    private LogEntry.LogLevel minLevel;
    private String[] threadNameWhiteList;
    private String[] classNameWhiteList;
    private int[] lineNumWhiteList;
    private DateFormat datePattern;
    private Date startDate = new Date(Long.MIN_VALUE);
    private Date endDate = new Date(Long.MAX_VALUE);

    LogFilter() {
        this.minLevel = LogEntry.LogLevel.DEBUG;
    }

    LogFilter(Properties properties) throws IOException {
        this();
        String classNameWhiteListStr;
        this.minLevel = LogEntry.LogLevel.valueOf(properties.getProperty(FilterProperties.MIN_LEVEL.getPropertyName(), this.minLevel.name()));
        String threadNameWhiteListStr = properties.getProperty(FilterProperties.THREAD_NAME_WHITE_LIST.getPropertyName());
        if (threadNameWhiteListStr != null) {
            this.threadNameWhiteList = threadNameWhiteListStr.trim().split(",");
        }
        if ((classNameWhiteListStr = properties.getProperty(FilterProperties.CLASS_NAME_WHITE_LIST.getPropertyName())) != null) {
            this.classNameWhiteList = classNameWhiteListStr.trim().split(",");
        }
        this.lineNumWhiteList = VisualUtils.parseIntArray(properties.getProperty(FilterProperties.LINE_NUM_WHITE_LIST.getPropertyName()));
        String datePatternStr = properties.getProperty(FilterProperties.DATE_PATTERN.getPropertyName());
        if (datePatternStr != null) {
            String endDatePattern;
            this.datePattern = new SimpleDateFormat(datePatternStr.trim());
            String startDateStr = properties.getProperty(FilterProperties.START_DATE.getPropertyName());
            if (startDateStr != null) {
                try {
                    this.startDate = this.datePattern.parse(startDateStr.trim());
                }
                catch (ParseException e) {
                    throw new IOException(e);
                }
            }
            if ((endDatePattern = properties.getProperty(FilterProperties.END_DATE.getPropertyName())) != null) {
                try {
                    this.endDate = this.datePattern.parse(endDatePattern.trim());
                }
                catch (ParseException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    public FilterFeedBack filter(LogEntry entry) {
        if (entry.getLogLevel().ordinal() < this.minLevel.ordinal() || this.threadNameWhiteList != null && !VisualUtils.strsContains(this.threadNameWhiteList, entry.getThreadName()) || this.classNameWhiteList != null && !VisualUtils.strsContains(this.classNameWhiteList, entry.getCodeLocation().getClassName()) || this.lineNumWhiteList != null && !VisualUtils.intsContains(this.lineNumWhiteList, entry.getCodeLocation().getLineNum()) || this.startDate != null && entry.getDate().before(this.startDate)) {
            return FilterFeedBack.REJECT;
        }
        if (this.endDate != null && entry.getDate().after(this.endDate)) {
            return FilterFeedBack.BEYOND_END_TIME;
        }
        return FilterFeedBack.OK;
    }

    public LogEntry.LogLevel getMinLevel() {
        return this.minLevel;
    }

    public String[] getThreadNameWhiteList() {
        return this.threadNameWhiteList;
    }

    public String[] getClassNameWhiteList() {
        return this.classNameWhiteList;
    }

    public int[] getLineNumWhiteList() {
        return this.lineNumWhiteList;
    }

    public DateFormat getDatePattern() {
        return this.datePattern;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setMinLevel(LogEntry.LogLevel minLevel) {
        this.minLevel = minLevel;
    }

    public void setThreadNameWhiteList(String[] threadNameWhiteList) {
        this.threadNameWhiteList = threadNameWhiteList;
    }

    public void setClassNameWhiteList(String[] classNameWhiteList) {
        this.classNameWhiteList = classNameWhiteList;
    }

    public void setLineNumWhiteList(int[] lineNumWhiteList) {
        this.lineNumWhiteList = lineNumWhiteList;
    }

    public void setDatePattern(DateFormat datePattern) {
        this.datePattern = datePattern;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void saveIntoProperties(Properties properties) {
        properties.put(FilterProperties.MIN_LEVEL.propertyName, this.minLevel.toString());
        if (this.threadNameWhiteList != null) {
            properties.put(FilterProperties.THREAD_NAME_WHITE_LIST.propertyName, String.join((CharSequence)",", this.threadNameWhiteList));
        }
        if (this.classNameWhiteList != null) {
            properties.put(FilterProperties.CLASS_NAME_WHITE_LIST.propertyName, String.join((CharSequence)",", this.classNameWhiteList));
        }
        if (this.lineNumWhiteList != null) {
            properties.put(FilterProperties.LINE_NUM_WHITE_LIST.propertyName, VisualUtils.intArrayToString(this.lineNumWhiteList));
        }
        if (this.datePattern != null) {
            properties.put(FilterProperties.DATE_PATTERN.propertyName, ((SimpleDateFormat)this.datePattern).toPattern());
            if (this.startDate != null) {
                properties.put(FilterProperties.START_DATE.propertyName, this.datePattern.format(this.startDate));
            }
            if (this.endDate != null) {
                properties.put(FilterProperties.END_DATE.propertyName, this.datePattern.format(this.endDate));
            }
        }
    }

    static enum FilterFeedBack {
        OK,
        REJECT,
        BEYOND_END_TIME;

    }

    public static enum FilterProperties {
        MIN_LEVEL("min_level"),
        THREAD_NAME_WHITE_LIST("thread_name_white_list"),
        CLASS_NAME_WHITE_LIST("class_name_white_list"),
        LINE_NUM_WHITE_LIST("line_num_white_list"),
        START_DATE("start_date"),
        END_DATE("end_date"),
        DATE_PATTERN("date_pattern");

        private String propertyName;

        private FilterProperties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

