/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import org.apache.iotdb.db.concurrent.IoTDBDefaultThreadExceptionHandler;
import org.apache.iotdb.db.conf.IoTDBConfigCheck;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.IoTDBConfigDynamicAdapter;
import org.apache.iotdb.db.conf.adapter.ManageDynamicParameters;
import org.apache.iotdb.db.cost.statistic.Measurement;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.cache.CacheHitRatioMonitor;
import org.apache.iotdb.db.engine.flush.FlushManager;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.monitor.StatMonitor;
import org.apache.iotdb.db.rescon.TVListAllocator;
import org.apache.iotdb.db.service.IoTDBMBean;
import org.apache.iotdb.db.service.IoTDBShutdownHook;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.MQTTService;
import org.apache.iotdb.db.service.MetricsService;
import org.apache.iotdb.db.service.Monitor;
import org.apache.iotdb.db.service.RPCService;
import org.apache.iotdb.db.service.RegisterManager;
import org.apache.iotdb.db.service.StartupChecks;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.db.sync.receiver.SyncServerManager;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDB
implements IoTDBMBean {
    private static final Logger logger = LoggerFactory.getLogger(IoTDB.class);
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", "IoTDB");
    private RegisterManager registerManager = new RegisterManager();

    public static IoTDB getInstance() {
        return IoTDBHolder.INSTANCE;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            IoTDBDescriptor.getInstance().replaceProps(args);
        }
        try {
            IoTDBConfigCheck.getInstance().checkConfig();
        }
        catch (IOException e) {
            logger.error("meet error when doing start checking", (Throwable)e);
        }
        IoTDB daemon = IoTDB.getInstance();
        daemon.active();
    }

    public void active() {
        StartupChecks checks = new StartupChecks().withDefaultTest();
        try {
            checks.verify();
        }
        catch (StartupException e) {
            logger.error("{}: failed to start because some checks failed. ", (Object)"IoTDB", (Object)e);
            return;
        }
        try {
            this.setUp();
        }
        catch (StartupException e) {
            logger.error("meet error while starting up.", (Throwable)e);
            this.deactivate();
            logger.error("{} exit", (Object)"IoTDB");
            return;
        }
        logger.info("{} has started.", (Object)"IoTDB");
    }

    private void setUp() throws StartupException {
        logger.info("Setting up IoTDB...");
        Runtime.getRuntime().addShutdownHook(new IoTDBShutdownHook());
        this.setUncaughtExceptionHandler();
        this.initMManager();
        this.registerManager.register(JMXService.getInstance());
        this.registerManager.register(FlushManager.getInstance());
        this.registerManager.register(MultiFileLogNodeManager.getInstance());
        this.registerManager.register(Monitor.getInstance());
        this.registerManager.register(StatMonitor.getInstance());
        this.registerManager.register(Measurement.INSTANCE);
        this.registerManager.register(ManageDynamicParameters.getInstance());
        this.registerManager.register(SyncServerManager.getInstance());
        this.registerManager.register(TVListAllocator.getInstance());
        this.registerManager.register(CacheHitRatioMonitor.getInstance());
        JMXService.registerMBean(IoTDB.getInstance(), this.mbeanName);
        this.registerManager.register(UpgradeSevice.getINSTANCE());
        this.registerManager.register(MergeManager.getINSTANCE());
        this.registerManager.register(StorageEngine.getInstance());
        if (IoTDBDescriptor.getInstance().getConfig().isEnableStatMonitor()) {
            StatMonitor.getInstance().recovery();
        }
        this.registerManager.register(RPCService.getInstance());
        if (IoTDBDescriptor.getInstance().getConfig().isEnableMetricService()) {
            this.registerManager.register(MetricsService.getInstance());
        }
        if (IoTDBDescriptor.getInstance().getConfig().isEnableMQTTService()) {
            this.registerManager.register(MQTTService.getInstance());
        }
        logger.info("IoTDB is set up.");
    }

    private void deactivate() {
        logger.info("Deactivating IoTDB...");
        this.registerManager.deregisterAll();
        JMXService.deregisterMBean(this.mbeanName);
        logger.info("IoTDB is deactivated.");
    }

    private void initMManager() {
        MManager.getInstance().init();
        IoTDBConfigDynamicAdapter.getInstance().setInitialized(true);
        logger.info("After initializing, max memTable num is {}, tsFile threshold is {}, memtableSize is {}", new Object[]{IoTDBDescriptor.getInstance().getConfig().getMaxMemtableNumber(), IoTDBDescriptor.getInstance().getConfig().getTsFileSizeThreshold(), IoTDBDescriptor.getInstance().getConfig().getMemtableSizeThreshold()});
    }

    @Override
    public void stop() {
        this.deactivate();
    }

    private void setUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new IoTDBDefaultThreadExceptionHandler());
    }

    private static class IoTDBHolder {
        private static final IoTDB INSTANCE = new IoTDB();

        private IoTDBHolder() {
        }
    }
}

