/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.timegenerator;

import java.io.IOException;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;

public class ServerTimeGenerator
extends TimeGenerator {
    protected QueryContext context;
    protected RawDataQueryPlan queryPlan;

    public ServerTimeGenerator(QueryContext context) {
        this.context = context;
    }

    public ServerTimeGenerator(IExpression expression, QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException {
        this.context = context;
        this.queryPlan = queryPlan;
        try {
            super.constructNode(expression);
        }
        catch (IOException e) {
            throw new StorageEngineException(e);
        }
    }

    protected IBatchReader generateNewBatchReader(SingleSeriesExpression expression) throws IOException {
        QueryDataSource queryDataSource;
        TSDataType dataType;
        Filter filter = expression.getFilter();
        Path path = expression.getSeriesPath();
        try {
            dataType = MManager.getInstance().getSeriesType(path.getFullPath());
            queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, this.context, filter);
            filter = queryDataSource.updateFilterUsingTTL(filter);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return new SeriesRawDataBatchReader(path, this.queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, this.context, queryDataSource, null, filter, null);
    }
}

