/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.UnaryFilter;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

class SeriesReader {
    private final Path seriesPath;
    private final Set<String> allSensors;
    private final TSDataType dataType;
    private final QueryContext context;
    private final Filter timeFilter;
    private final Filter valueFilter;
    private final List<TsFileResource> seqFileResource;
    private final List<TsFileResource> unseqFileResource;
    private TimeseriesMetadata firstTimeSeriesMetadata;
    private final List<TimeseriesMetadata> seqTimeSeriesMetadata = new LinkedList<TimeseriesMetadata>();
    private final PriorityQueue<TimeseriesMetadata> unSeqTimeSeriesMetadata = new PriorityQueue<TimeseriesMetadata>(Comparator.comparingLong(timeSeriesMetadata -> timeSeriesMetadata.getStatistics().getStartTime()));
    private ChunkMetadata firstChunkMetadata;
    private final PriorityQueue<ChunkMetadata> cachedChunkMetadata = new PriorityQueue<ChunkMetadata>(Comparator.comparingLong(ChunkMetadata::getStartTime));
    private VersionPageReader firstPageReader;
    private PriorityQueue<VersionPageReader> cachedPageReaders = new PriorityQueue<VersionPageReader>(Comparator.comparingLong(VersionPageReader::getStartTime));
    private PriorityMergeReader mergeReader = new PriorityMergeReader();
    private boolean hasCachedNextOverlappedPage;
    private BatchData cachedBatchData;

    SeriesReader(Path seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, Filter timeFilter, Filter valueFilter, TsFileFilter fileFilter) {
        this.seriesPath = seriesPath;
        this.allSensors = allSensors;
        this.dataType = dataType;
        this.context = context;
        QueryUtils.filterQueryDataSource(dataSource, fileFilter);
        this.seqFileResource = new LinkedList<TsFileResource>(dataSource.getSeqResources());
        this.unseqFileResource = this.sortUnSeqFileResources(dataSource.getUnseqResources());
        this.timeFilter = timeFilter;
        this.valueFilter = valueFilter;
    }

    SeriesReader(Path seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, Filter timeFilter, Filter valueFilter) {
        this.seriesPath = seriesPath;
        this.allSensors = allSensors;
        this.dataType = dataType;
        this.context = context;
        this.seqFileResource = new LinkedList<TsFileResource>(seqFileResource);
        this.unseqFileResource = this.sortUnSeqFileResources(unseqFileResource);
        this.timeFilter = timeFilter;
        this.valueFilter = valueFilter;
    }

    boolean hasNextFile() throws IOException {
        if (!this.cachedPageReaders.isEmpty() || this.firstPageReader != null || this.mergeReader.hasNextTimeValuePair()) {
            throw new IOException("all cached pages should be consumed first cachedPageReaders.isEmpty() is " + this.cachedPageReaders.isEmpty() + " firstPageReader != null is " + (this.firstPageReader != null) + " mergeReader.hasNextTimeValuePair() = " + this.mergeReader.hasNextTimeValuePair());
        }
        if (this.firstChunkMetadata != null || !this.cachedChunkMetadata.isEmpty()) {
            throw new IOException("all cached chunks should be consumed first");
        }
        if (this.firstTimeSeriesMetadata != null) {
            return true;
        }
        this.tryToUnpackAllOverlappedFilesToTimeSeriesMetadata();
        return this.firstTimeSeriesMetadata != null;
    }

    boolean isFileOverlapped() throws IOException {
        if (this.firstTimeSeriesMetadata == null) {
            throw new IOException("no first file");
        }
        Statistics fileStatistics = this.firstTimeSeriesMetadata.getStatistics();
        return !this.seqTimeSeriesMetadata.isEmpty() && fileStatistics.getEndTime() >= this.seqTimeSeriesMetadata.get(0).getStatistics().getStartTime() || !this.unSeqTimeSeriesMetadata.isEmpty() && fileStatistics.getEndTime() >= this.unSeqTimeSeriesMetadata.peek().getStatistics().getStartTime();
    }

    Statistics currentFileStatistics() {
        return this.firstTimeSeriesMetadata.getStatistics();
    }

    boolean currentFileModified() throws IOException {
        if (this.firstTimeSeriesMetadata == null) {
            throw new IOException("no first file");
        }
        return this.firstTimeSeriesMetadata.isModified();
    }

    void skipCurrentFile() {
        this.firstTimeSeriesMetadata = null;
    }

    boolean hasNextChunk() throws IOException {
        if (!this.cachedPageReaders.isEmpty() || this.firstPageReader != null || this.mergeReader.hasNextTimeValuePair()) {
            throw new IOException("all cached pages should be consumed first cachedPageReaders.isEmpty() is " + this.cachedPageReaders.isEmpty() + " firstPageReader != null is " + (this.firstPageReader != null) + " mergeReader.hasNextTimeValuePair() = " + this.mergeReader.hasNextTimeValuePair());
        }
        if (this.firstChunkMetadata != null) {
            return true;
        }
        if (this.firstTimeSeriesMetadata != null) {
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(this.firstTimeSeriesMetadata.getStatistics().getEndTime());
            this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(this.firstTimeSeriesMetadata.getStatistics().getEndTime(), true);
        } else if (!this.cachedChunkMetadata.isEmpty()) {
            this.firstChunkMetadata = this.cachedChunkMetadata.poll();
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(this.firstChunkMetadata.getEndTime());
            this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(this.firstChunkMetadata.getEndTime(), false);
        }
        return this.firstChunkMetadata != null;
    }

    private void unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(long endTime, boolean init) throws IOException {
        while (!this.seqTimeSeriesMetadata.isEmpty() && endTime >= this.seqTimeSeriesMetadata.get(0).getStatistics().getStartTime()) {
            this.unpackOneTimeSeriesMetadata(this.seqTimeSeriesMetadata.remove(0));
        }
        while (!this.unSeqTimeSeriesMetadata.isEmpty() && endTime >= this.unSeqTimeSeriesMetadata.peek().getStatistics().getStartTime()) {
            this.unpackOneTimeSeriesMetadata(this.unSeqTimeSeriesMetadata.poll());
        }
        if (this.firstTimeSeriesMetadata != null && endTime >= this.firstTimeSeriesMetadata.getStatistics().getStartTime()) {
            this.unpackOneTimeSeriesMetadata(this.firstTimeSeriesMetadata);
            this.firstTimeSeriesMetadata = null;
        }
        if (init && this.firstChunkMetadata == null && !this.cachedChunkMetadata.isEmpty()) {
            this.firstChunkMetadata = this.cachedChunkMetadata.poll();
        }
    }

    private void unpackOneTimeSeriesMetadata(TimeseriesMetadata timeSeriesMetadata) throws IOException {
        this.cachedChunkMetadata.addAll(FileLoaderUtils.loadChunkMetadataList(timeSeriesMetadata));
    }

    boolean isChunkOverlapped() throws IOException {
        if (this.firstChunkMetadata == null) {
            throw new IOException("no first chunk");
        }
        Statistics chunkStatistics = this.firstChunkMetadata.getStatistics();
        return !this.cachedChunkMetadata.isEmpty() && chunkStatistics.getEndTime() >= this.cachedChunkMetadata.peek().getStartTime();
    }

    Statistics currentChunkStatistics() {
        return this.firstChunkMetadata.getStatistics();
    }

    boolean currentChunkModified() throws IOException {
        if (this.firstChunkMetadata == null) {
            throw new IOException("no first chunk");
        }
        return this.firstChunkMetadata.isModified();
    }

    void skipCurrentChunk() {
        this.firstChunkMetadata = null;
    }

    boolean hasNextPage() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        if (this.mergeReader.hasNextTimeValuePair() && this.hasNextOverlappedPage()) {
            this.cachedBatchData = this.nextOverlappedPage();
            if (this.cachedBatchData != null && this.cachedBatchData.hasCurrent()) {
                this.hasCachedNextOverlappedPage = true;
                return true;
            }
        }
        if (this.firstPageReader != null) {
            return true;
        }
        if (this.firstChunkMetadata != null) {
            this.unpackAllOverlappedChunkMetadataToCachedPageReaders(this.firstChunkMetadata.getEndTime(), true);
        } else if (!this.cachedPageReaders.isEmpty()) {
            this.firstPageReader = this.cachedPageReaders.poll();
        }
        if (this.firstPageReader != null && !this.cachedPageReaders.isEmpty() && this.firstPageReader.getEndTime() >= this.cachedPageReaders.peek().getStartTime() && this.hasNextOverlappedPage()) {
            this.cachedBatchData = this.nextOverlappedPage();
            if (this.cachedBatchData != null && this.cachedBatchData.hasCurrent()) {
                this.hasCachedNextOverlappedPage = true;
                return true;
            }
        }
        while (this.firstPageReader == null && !this.cachedPageReaders.isEmpty()) {
            this.firstPageReader = this.cachedPageReaders.poll();
            if (this.cachedPageReaders.isEmpty() || this.firstPageReader.getEndTime() < this.cachedPageReaders.peek().getStartTime() || !this.hasNextOverlappedPage()) continue;
            this.cachedBatchData = this.nextOverlappedPage();
            if (this.cachedBatchData == null || !this.cachedBatchData.hasCurrent()) continue;
            this.hasCachedNextOverlappedPage = true;
            return true;
        }
        return this.firstPageReader != null;
    }

    private void unpackAllOverlappedChunkMetadataToCachedPageReaders(long endTime, boolean init) throws IOException {
        while (!this.cachedChunkMetadata.isEmpty() && endTime >= this.cachedChunkMetadata.peek().getStartTime()) {
            this.unpackOneChunkMetaData(this.cachedChunkMetadata.poll());
        }
        if (this.firstChunkMetadata != null && endTime >= this.firstChunkMetadata.getStartTime()) {
            this.unpackOneChunkMetaData(this.firstChunkMetadata);
            this.firstChunkMetadata = null;
        }
        if (init && this.firstPageReader == null && !this.cachedPageReaders.isEmpty()) {
            this.firstPageReader = this.cachedPageReaders.poll();
        }
    }

    private void unpackOneChunkMetaData(ChunkMetadata chunkMetaData) throws IOException {
        FileLoaderUtils.loadPageReaderList(chunkMetaData, this.timeFilter).forEach(pageReader -> this.cachedPageReaders.add(new VersionPageReader(chunkMetaData.getVersion(), (IPageReader)pageReader)));
    }

    boolean isPageOverlapped() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        if (this.mergeReader.hasNextTimeValuePair()) {
            throw new IOException("overlapped data should be consumed first");
        }
        Statistics firstPageStatistics = this.firstPageReader.getStatistics();
        return !this.cachedPageReaders.isEmpty() && firstPageStatistics.getEndTime() >= this.cachedPageReaders.peek().getStartTime();
    }

    Statistics currentPageStatistics() {
        if (this.firstPageReader == null) {
            return null;
        }
        return this.firstPageReader.getStatistics();
    }

    boolean currentPageModified() throws IOException {
        if (this.firstPageReader == null) {
            throw new IOException("no first page");
        }
        return this.firstPageReader.isModified();
    }

    void skipCurrentPage() {
        this.firstPageReader = null;
    }

    BatchData nextPage() throws IOException {
        if (!this.hasNextPage()) {
            throw new IOException("no next page, neither non-overlapped nor overlapped");
        }
        if (this.hasCachedNextOverlappedPage) {
            this.hasCachedNextOverlappedPage = false;
            return this.cachedBatchData;
        }
        if (this.valueFilter != null) {
            this.firstPageReader.setFilter(this.valueFilter);
        }
        BatchData batchData = this.firstPageReader.getAllSatisfiedPageData();
        this.firstPageReader = null;
        return batchData;
    }

    private boolean hasNextOverlappedPage() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        this.tryToPutAllDirectlyOverlappedPageReadersIntoMergeReader();
        while (this.mergeReader.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair;
            this.cachedBatchData = new BatchData(this.dataType);
            long currentPageEndTime = this.mergeReader.getCurrentLargestEndTime();
            while (this.mergeReader.hasNextTimeValuePair() && (timeValuePair = this.mergeReader.currentTimeValuePair()).getTimestamp() <= currentPageEndTime) {
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(timeValuePair.getTimestamp());
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(timeValuePair.getTimestamp(), false);
                this.unpackAllOverlappedChunkMetadataToCachedPageReaders(timeValuePair.getTimestamp(), false);
                this.unpackAllOverlappedCachedPageReadersToMergeReader(timeValuePair.getTimestamp());
                timeValuePair = this.mergeReader.nextTimeValuePair();
                if (this.valueFilter != null && !this.valueFilter.satisfy(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue())) continue;
                this.cachedBatchData.putAnObject(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue());
            }
            this.hasCachedNextOverlappedPage = this.cachedBatchData.hasCurrent();
            if (!this.hasCachedNextOverlappedPage) continue;
            return true;
        }
        return false;
    }

    private void tryToPutAllDirectlyOverlappedPageReadersIntoMergeReader() throws IOException {
        if (this.firstPageReader == null && this.cachedPageReaders.isEmpty()) {
            return;
        }
        if (this.firstPageReader == null) {
            this.firstPageReader = this.cachedPageReaders.poll();
        }
        long currentPageEndTime = this.mergeReader.hasNextTimeValuePair() ? this.mergeReader.getCurrentLargestEndTime() : this.firstPageReader.getEndTime();
        this.unpackAllOverlappedCachedPageReadersToMergeReader(currentPageEndTime);
    }

    private void unpackAllOverlappedCachedPageReadersToMergeReader(long endTime) throws IOException {
        while (!this.cachedPageReaders.isEmpty() && endTime >= this.cachedPageReaders.peek().data.getStatistics().getStartTime()) {
            this.putPageReaderToMergeReader(this.cachedPageReaders.poll());
        }
        if (this.firstPageReader != null && endTime >= this.firstPageReader.getStartTime()) {
            this.putPageReaderToMergeReader(this.firstPageReader);
            this.firstPageReader = null;
        }
    }

    private void putPageReaderToMergeReader(VersionPageReader pageReader) throws IOException {
        this.mergeReader.addReader((IPointReader)pageReader.getAllSatisfiedPageData().getBatchDataIterator(), pageReader.version, pageReader.getEndTime());
    }

    private BatchData nextOverlappedPage() throws IOException {
        if (this.hasCachedNextOverlappedPage || this.hasNextOverlappedPage()) {
            this.hasCachedNextOverlappedPage = false;
            return this.cachedBatchData;
        }
        throw new IOException("No more batch data");
    }

    private LinkedList<TsFileResource> sortUnSeqFileResources(List<TsFileResource> tsFileResources) {
        return tsFileResources.stream().sorted(Comparator.comparingLong(tsFileResource -> tsFileResource.getStartTime(this.seriesPath.getDevice()))).collect(Collectors.toCollection(LinkedList::new));
    }

    private void tryToUnpackAllOverlappedFilesToTimeSeriesMetadata() throws IOException {
        TimeseriesMetadata timeseriesMetadata;
        while (this.seqTimeSeriesMetadata.isEmpty() && !this.seqFileResource.isEmpty()) {
            timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(this.seqFileResource.remove(0), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
            if (timeseriesMetadata == null) continue;
            this.seqTimeSeriesMetadata.add(timeseriesMetadata);
        }
        while (this.unSeqTimeSeriesMetadata.isEmpty() && !this.unseqFileResource.isEmpty()) {
            timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(this.unseqFileResource.remove(0), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
            if (timeseriesMetadata == null) continue;
            timeseriesMetadata.setModified(true);
            this.unSeqTimeSeriesMetadata.add(timeseriesMetadata);
        }
        long endTime = -1L;
        if (!this.seqTimeSeriesMetadata.isEmpty() && this.unSeqTimeSeriesMetadata.isEmpty()) {
            endTime = this.seqTimeSeriesMetadata.get(0).getStatistics().getEndTime();
        } else if (this.seqTimeSeriesMetadata.isEmpty() && !this.unSeqTimeSeriesMetadata.isEmpty()) {
            endTime = this.unSeqTimeSeriesMetadata.peek().getStatistics().getEndTime();
        } else if (!this.seqTimeSeriesMetadata.isEmpty()) {
            endTime = this.seqTimeSeriesMetadata.get(0).getStatistics().getStartTime() <= this.unSeqTimeSeriesMetadata.peek().getStatistics().getStartTime() ? this.seqTimeSeriesMetadata.get(0).getStatistics().getEndTime() : this.unSeqTimeSeriesMetadata.peek().getStatistics().getEndTime();
        }
        if (endTime != -1L) {
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(endTime);
        }
        if (!this.seqTimeSeriesMetadata.isEmpty() && this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.seqTimeSeriesMetadata.remove(0);
        } else if (this.seqTimeSeriesMetadata.isEmpty() && !this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.unSeqTimeSeriesMetadata.poll();
        } else if (!this.seqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.seqTimeSeriesMetadata.get(0).getStatistics().getStartTime() <= this.unSeqTimeSeriesMetadata.peek().getStatistics().getStartTime() ? this.seqTimeSeriesMetadata.remove(0) : this.unSeqTimeSeriesMetadata.poll();
        }
    }

    private void unpackAllOverlappedTsFilesToTimeSeriesMetadata(long endTime) throws IOException {
        TimeseriesMetadata timeseriesMetadata;
        while (!this.unseqFileResource.isEmpty() && endTime >= this.unseqFileResource.get(0).getStartTime(this.seriesPath.getDevice())) {
            timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(this.unseqFileResource.remove(0), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
            if (timeseriesMetadata == null) continue;
            timeseriesMetadata.setModified(true);
            this.unSeqTimeSeriesMetadata.add(timeseriesMetadata);
        }
        while (!this.seqFileResource.isEmpty() && endTime >= this.seqFileResource.get(0).getStartTime(this.seriesPath.getDevice())) {
            timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(this.seqFileResource.remove(0), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
            if (timeseriesMetadata == null) continue;
            this.seqTimeSeriesMetadata.add(timeseriesMetadata);
        }
    }

    private Filter getAnyFilter() {
        return this.timeFilter != null ? this.timeFilter : this.valueFilter;
    }

    void setTimeFilter(long timestamp) {
        ((UnaryFilter)this.timeFilter).setValue((Comparable)Long.valueOf(timestamp));
    }

    Filter getTimeFilter() {
        return this.timeFilter;
    }

    private class VersionPageReader {
        protected long version;
        protected IPageReader data;

        VersionPageReader(long version, IPageReader data) {
            this.version = version;
            this.data = data;
        }

        Statistics getStatistics() {
            return this.data.getStatistics();
        }

        long getStartTime() {
            return this.data.getStatistics().getStartTime();
        }

        long getEndTime() {
            return this.data.getStatistics().getEndTime();
        }

        BatchData getAllSatisfiedPageData() throws IOException {
            return this.data.getAllSatisfiedPageData();
        }

        void setFilter(Filter filter) {
            this.data.setFilter(filter);
        }

        boolean isModified() {
            return this.data.isModified();
        }
    }
}

