/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk.metadata;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.chunk.metadata.DiskChunkMetadataLoader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class MemChunkMetadataLoader
implements IChunkMetadataLoader {
    private TsFileResource resource;
    private Path seriesPath;
    private QueryContext context;
    private Filter timeFilter;

    public MemChunkMetadataLoader(TsFileResource resource, Path seriesPath, QueryContext context, Filter timeFilter) {
        this.resource = resource;
        this.seriesPath = seriesPath;
        this.context = context;
        this.timeFilter = timeFilter;
    }

    public List<ChunkMetadata> loadChunkMetadataList() {
        List<ChunkMetadata> chunkMetadataList = this.resource.getChunkMetadataList();
        DiskChunkMetadataLoader.setDiskChunkLoader(chunkMetadataList, this.resource, this.seriesPath, this.context);
        List<ReadOnlyMemChunk> memChunks = this.resource.getReadOnlyMemChunk();
        if (memChunks != null) {
            for (ReadOnlyMemChunk readOnlyMemChunk : memChunks) {
                if (memChunks.isEmpty()) continue;
                chunkMetadataList.add(readOnlyMemChunk.getChunkMetaData());
            }
        }
        chunkMetadataList.removeIf(chunkMetaData -> this.timeFilter != null && !this.timeFilter.satisfyStartEndTime(chunkMetaData.getStartTime(), chunkMetaData.getEndTime()) || chunkMetaData.getStartTime() > chunkMetaData.getEndTime());
        return chunkMetadataList;
    }

    public void setDiskChunkLoader(List<ChunkMetadata> chunkMetadataList) throws IOException {
    }
}

