/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.query.reader.chunk.MemPageReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class MemChunkReader
implements IChunkReader,
IPointReader {
    private ReadOnlyMemChunk readOnlyMemChunk;
    private IPointReader timeValuePairIterator;
    private Filter filter;
    private boolean hasCachedTimeValuePair;
    private TimeValuePair cachedTimeValuePair;
    private TSDataType dataType;

    public MemChunkReader(ReadOnlyMemChunk readableChunk, Filter filter) {
        this.readOnlyMemChunk = readableChunk;
        this.timeValuePairIterator = readableChunk.getPointReader();
        this.filter = filter;
        this.dataType = readableChunk.getDataType();
    }

    public boolean hasNextTimeValuePair() throws IOException {
        if (this.hasCachedTimeValuePair) {
            return true;
        }
        while (this.timeValuePairIterator.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = this.timeValuePairIterator.nextTimeValuePair();
            if (this.filter != null && !this.filter.satisfy(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue())) continue;
            this.hasCachedTimeValuePair = true;
            this.cachedTimeValuePair = timeValuePair;
            break;
        }
        return this.hasCachedTimeValuePair;
    }

    public TimeValuePair nextTimeValuePair() throws IOException {
        if (this.hasCachedTimeValuePair) {
            this.hasCachedTimeValuePair = false;
            return this.cachedTimeValuePair;
        }
        return this.timeValuePairIterator.nextTimeValuePair();
    }

    public TimeValuePair currentTimeValuePair() throws IOException {
        if (!this.hasCachedTimeValuePair) {
            this.cachedTimeValuePair = this.timeValuePairIterator.nextTimeValuePair();
            this.hasCachedTimeValuePair = true;
        }
        return this.cachedTimeValuePair;
    }

    public boolean hasNextSatisfiedPage() throws IOException {
        return this.hasNextTimeValuePair();
    }

    public BatchData nextPageData() throws IOException {
        BatchData batchData = new BatchData(this.dataType);
        if (this.hasCachedTimeValuePair) {
            this.hasCachedTimeValuePair = false;
            batchData.putAnObject(this.cachedTimeValuePair.getTimestamp(), this.cachedTimeValuePair.getValue().getValue());
        }
        while (this.timeValuePairIterator.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = this.timeValuePairIterator.nextTimeValuePair();
            if (this.filter != null && !this.filter.satisfy(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue())) continue;
            batchData.putAnObject(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue());
        }
        return batchData;
    }

    public void close() {
    }

    public List<IPageReader> loadPageReaderList() throws IOException {
        return Collections.singletonList(new MemPageReader(this.nextPageData(), this.readOnlyMemChunk.getChunkMetaData().getStatistics()));
    }
}

