/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByFillDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithValueFilterDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithoutValueFilterDataSet;
import org.apache.iotdb.db.query.executor.AggregationExecutor;
import org.apache.iotdb.db.query.executor.FillQueryExecutor;
import org.apache.iotdb.db.query.executor.IQueryRouter;
import org.apache.iotdb.db.query.executor.LastQueryExecutor;
import org.apache.iotdb.db.query.executor.RawDataQueryExecutor;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.expression.util.ExpressionOptimizer;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class QueryRouter
implements IQueryRouter {
    @Override
    public QueryDataSet rawDataQuery(RawDataQueryPlan queryPlan, QueryContext context) throws StorageEngineException, QueryProcessException {
        IExpression optimizedExpression;
        IExpression expression = queryPlan.getExpression();
        List<Path> deduplicatedPaths = queryPlan.getDeduplicatedPaths();
        try {
            optimizedExpression = expression == null ? null : ExpressionOptimizer.getInstance().optimize(expression, deduplicatedPaths);
        }
        catch (QueryFilterOptimizationException e) {
            throw new StorageEngineException(e.getMessage());
        }
        queryPlan.setExpression(optimizedExpression);
        RawDataQueryExecutor rawDataQueryExecutor = this.getRawDataQueryExecutor(queryPlan);
        if (!queryPlan.isAlignByTime()) {
            return rawDataQueryExecutor.executeNonAlign(context, queryPlan);
        }
        if (optimizedExpression != null && optimizedExpression.getType() != ExpressionType.GLOBAL_TIME) {
            return rawDataQueryExecutor.executeWithValueFilter(context, queryPlan);
        }
        return rawDataQueryExecutor.executeWithoutValueFilter(context, queryPlan);
    }

    protected RawDataQueryExecutor getRawDataQueryExecutor(RawDataQueryPlan queryPlan) {
        return new RawDataQueryExecutor(queryPlan);
    }

    @Override
    public QueryDataSet aggregate(AggregationPlan aggregationPlan, QueryContext context) throws QueryFilterOptimizationException, StorageEngineException, QueryProcessException, IOException {
        IExpression expression = aggregationPlan.getExpression();
        List<Path> deduplicatedPaths = aggregationPlan.getDeduplicatedPaths();
        IExpression optimizedExpression = expression == null ? null : ExpressionOptimizer.getInstance().optimize(expression, deduplicatedPaths);
        aggregationPlan.setExpression(optimizedExpression);
        AggregationExecutor engineExecutor = this.getAggregationExecutor(aggregationPlan);
        if (optimizedExpression != null && optimizedExpression.getType() != ExpressionType.GLOBAL_TIME) {
            return engineExecutor.executeWithValueFilter(context, aggregationPlan);
        }
        return engineExecutor.executeWithoutValueFilter(context, aggregationPlan);
    }

    protected AggregationExecutor getAggregationExecutor(AggregationPlan aggregationPlan) {
        return new AggregationExecutor(aggregationPlan);
    }

    @Override
    public QueryDataSet groupBy(GroupByPlan groupByPlan, QueryContext context) throws QueryFilterOptimizationException, StorageEngineException, QueryProcessException {
        long unit = groupByPlan.getInterval();
        long slidingStep = groupByPlan.getSlidingStep();
        long startTime = groupByPlan.getStartTime();
        long endTime = groupByPlan.getEndTime();
        Object expression = groupByPlan.getExpression();
        List<Path> selectedSeries = groupByPlan.getDeduplicatedPaths();
        GlobalTimeExpression timeExpression = new GlobalTimeExpression((Filter)new GroupByFilter(unit, slidingStep, startTime, endTime));
        expression = expression == null ? timeExpression : BinaryExpression.and((IExpression)expression, (IExpression)timeExpression);
        IExpression optimizedExpression = ExpressionOptimizer.getInstance().optimize(expression, selectedSeries);
        groupByPlan.setExpression(optimizedExpression);
        if (optimizedExpression.getType() == ExpressionType.GLOBAL_TIME) {
            return this.getGroupByWithoutValueFilterDataSet(context, groupByPlan);
        }
        return this.getGroupByWithValueFilterDataSet(context, groupByPlan);
    }

    protected GroupByWithoutValueFilterDataSet getGroupByWithoutValueFilterDataSet(QueryContext context, GroupByPlan plan) throws StorageEngineException, QueryProcessException {
        return new GroupByWithoutValueFilterDataSet(context, plan);
    }

    protected GroupByWithValueFilterDataSet getGroupByWithValueFilterDataSet(QueryContext context, GroupByPlan plan) throws StorageEngineException, QueryProcessException {
        return new GroupByWithValueFilterDataSet(context, plan);
    }

    @Override
    public QueryDataSet fill(FillQueryPlan fillQueryPlan, QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
        List<Path> fillPaths = fillQueryPlan.getDeduplicatedPaths();
        List<TSDataType> dataTypes = fillQueryPlan.getDeduplicatedDataTypes();
        long queryTime = fillQueryPlan.getQueryTime();
        Map<TSDataType, IFill> fillType = fillQueryPlan.getFillType();
        FillQueryExecutor fillQueryExecutor = this.getFillExecutor(fillPaths, dataTypes, queryTime, fillType);
        return fillQueryExecutor.execute(context, fillQueryPlan);
    }

    protected FillQueryExecutor getFillExecutor(List<Path> fillPaths, List<TSDataType> dataTypes, long queryTime, Map<TSDataType, IFill> fillType) {
        return new FillQueryExecutor(fillPaths, dataTypes, queryTime, fillType);
    }

    @Override
    public QueryDataSet groupByFill(GroupByFillPlan groupByFillPlan, QueryContext context) throws QueryFilterOptimizationException, StorageEngineException, QueryProcessException, IOException {
        GroupByEngineDataSet groupByEngineDataSet = (GroupByEngineDataSet)this.groupBy(groupByFillPlan, context);
        return new GroupByFillDataSet(groupByFillPlan.getDeduplicatedPaths(), groupByFillPlan.getDeduplicatedDataTypes(), groupByEngineDataSet, groupByFillPlan.getFillType(), context, groupByFillPlan);
    }

    @Override
    public QueryDataSet lastQuery(LastQueryPlan lastQueryPlan, QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
        LastQueryExecutor lastQueryExecutor = new LastQueryExecutor(lastQueryPlan);
        return lastQueryExecutor.execute(context, lastQueryPlan);
    }
}

