/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.groupby.GroupByExecutor;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IAggregateReader;
import org.apache.iotdb.db.query.reader.series.SeriesAggregateReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class LocalGroupByExecutor
implements GroupByExecutor {
    private IAggregateReader reader;
    private BatchData preCachedData;
    private List<AggregateResult> results = new ArrayList<AggregateResult>();
    private TimeRange timeRange;

    public LocalGroupByExecutor(Path path, Set<String> allSensors, TSDataType dataType, QueryContext context, Filter timeFilter, TsFileFilter fileFilter) throws StorageEngineException, QueryProcessException {
        QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, context, timeFilter);
        timeFilter = queryDataSource.updateFilterUsingTTL(timeFilter);
        this.reader = new SeriesAggregateReader(path, allSensors, dataType, context, queryDataSource, timeFilter, null, fileFilter);
        this.preCachedData = null;
        this.timeRange = new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void addAggregateResult(AggregateResult aggrResult) {
        this.results.add(aggrResult);
    }

    private boolean isEndCalc() {
        for (AggregateResult result : this.results) {
            if (result.isCalculatedAggregationResult()) continue;
            return false;
        }
        return true;
    }

    private boolean calcFromCacheData(long curStartTime, long curEndTime) throws IOException {
        this.calcFromBatch(this.preCachedData, curStartTime, curEndTime);
        return this.preCachedData != null && this.preCachedData.getMaxTimestamp() >= curEndTime || this.isEndCalc();
    }

    private void calcFromBatch(BatchData batchData, long curStartTime, long curEndTime) throws IOException {
        if (batchData == null || !batchData.hasCurrent() || batchData.getMaxTimestamp() < curStartTime || batchData.currentTime() >= curEndTime) {
            return;
        }
        for (AggregateResult result : this.results) {
            if (result.isCalculatedAggregationResult()) continue;
            batchData.resetBatchData();
            while (batchData.hasCurrent() && batchData.currentTime() < curStartTime) {
                batchData.next();
            }
            if (!batchData.hasCurrent()) continue;
            result.updateResultFromPageData(batchData, curEndTime);
        }
        if (batchData.getMaxTimestamp() >= curEndTime) {
            this.preCachedData = batchData;
        }
    }

    private void calcFromStatistics(Statistics pageStatistics) throws QueryProcessException {
        for (AggregateResult result : this.results) {
            if (result.isCalculatedAggregationResult()) continue;
            result.updateResultFromStatistics(pageStatistics);
        }
    }

    @Override
    public List<AggregateResult> calcResult(long curStartTime, long curEndTime) throws IOException, QueryProcessException {
        for (AggregateResult result : this.results) {
            result.reset();
        }
        this.timeRange.set(curStartTime, curEndTime - 1L);
        if (this.calcFromCacheData(curStartTime, curEndTime)) {
            return this.results;
        }
        if (this.readAndCalcFromPage(curStartTime, curEndTime)) {
            return this.results;
        }
        if (this.readAndCalcFromChunk(curStartTime, curEndTime)) {
            return this.results;
        }
        while (this.reader.hasNextFile()) {
            Statistics fileStatistics = this.reader.currentFileStatistics();
            if (fileStatistics.getStartTime() >= curEndTime) {
                return this.results;
            }
            if (this.reader.canUseCurrentFileStatistics() && this.timeRange.contains(fileStatistics.getStartTime(), fileStatistics.getEndTime())) {
                this.calcFromStatistics(fileStatistics);
                this.reader.skipCurrentFile();
                continue;
            }
            if (!this.readAndCalcFromChunk(curStartTime, curEndTime)) continue;
            return this.results;
        }
        return this.results;
    }

    private boolean readAndCalcFromChunk(long curStartTime, long curEndTime) throws IOException, QueryProcessException {
        while (this.reader.hasNextChunk()) {
            Statistics chunkStatistics = this.reader.currentChunkStatistics();
            if (chunkStatistics.getStartTime() >= curEndTime) {
                return true;
            }
            if (this.reader.canUseCurrentChunkStatistics() && this.timeRange.contains(chunkStatistics.getStartTime(), chunkStatistics.getEndTime())) {
                this.calcFromStatistics(chunkStatistics);
                this.reader.skipCurrentChunk();
                continue;
            }
            if (!this.readAndCalcFromPage(curStartTime, curEndTime)) continue;
            return true;
        }
        return false;
    }

    private boolean readAndCalcFromPage(long curStartTime, long curEndTime) throws IOException, QueryProcessException {
        while (this.reader.hasNextPage()) {
            BatchData batchData;
            Statistics pageStatistics = this.reader.currentPageStatistics();
            if (pageStatistics != null) {
                if (pageStatistics.getStartTime() >= curEndTime) {
                    return true;
                }
                if (this.reader.canUseCurrentPageStatistics() && this.timeRange.contains(pageStatistics.getStartTime(), pageStatistics.getEndTime())) {
                    this.calcFromStatistics(pageStatistics);
                    this.reader.skipCurrentPage();
                    if (!this.isEndCalc()) continue;
                    return true;
                }
            }
            if ((batchData = this.reader.nextPage()) == null || !batchData.hasCurrent()) continue;
            if (batchData.currentTime() >= curEndTime) {
                this.preCachedData = batchData;
                return true;
            }
            this.calcFromBatch(batchData, curStartTime, curEndTime);
            if (!this.isEndCalc() && (!batchData.hasCurrent() || batchData.currentTime() < curEndTime)) continue;
            return true;
        }
        return false;
    }
}

