/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.GroupByPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByExecutor;
import org.apache.iotdb.db.query.dataset.groupby.LocalGroupByExecutor;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByWithoutValueFilterDataSet
extends GroupByEngineDataSet {
    private static final Logger logger = LoggerFactory.getLogger(GroupByWithoutValueFilterDataSet.class);
    private Map<Path, GroupByExecutor> pathExecutors = new HashMap<Path, GroupByExecutor>();
    private Map<Path, List<Integer>> resultIndexes = new HashMap<Path, List<Integer>>();

    public GroupByWithoutValueFilterDataSet() {
    }

    public GroupByWithoutValueFilterDataSet(QueryContext context, GroupByPlan groupByPlan) throws StorageEngineException, QueryProcessException {
        super(context, groupByPlan);
        this.initGroupBy(context, groupByPlan);
    }

    protected void initGroupBy(QueryContext context, GroupByPlan groupByPlan) throws StorageEngineException, QueryProcessException {
        IExpression expression = groupByPlan.getExpression();
        Filter timeFilter = null;
        if (expression != null) {
            timeFilter = ((GlobalTimeExpression)expression).getFilter();
        }
        for (int i = 0; i < this.paths.size(); ++i) {
            Path path = (Path)this.paths.get(i);
            if (!this.pathExecutors.containsKey(path)) {
                this.pathExecutors.put(path, this.getGroupByExecutor(path, groupByPlan.getAllMeasurementsInDevice(path.getDevice()), (TSDataType)this.dataTypes.get(i), context, timeFilter, null));
                this.resultIndexes.put(path, new ArrayList());
            }
            this.resultIndexes.get(path).add(i);
            AggregateResult aggrResult = AggregateResultFactory.getAggrResultByName(groupByPlan.getDeduplicatedAggregations().get(i), (TSDataType)this.dataTypes.get(i));
            this.pathExecutors.get(path).addAggregateResult(aggrResult);
        }
    }

    @Override
    protected RowRecord nextWithoutConstraint() throws IOException {
        if (!this.hasCachedTimeInterval) {
            throw new IOException("need to call hasNext() before calling next() in GroupByWithoutValueFilterDataSet.");
        }
        this.hasCachedTimeInterval = false;
        RowRecord record = this.leftCRightO ? new RowRecord(this.curStartTime) : new RowRecord(this.curEndTime - 1L);
        AggregateResult[] fields = new AggregateResult[this.paths.size()];
        try {
            for (Map.Entry<Path, GroupByExecutor> pathToExecutorEntry : this.pathExecutors.entrySet()) {
                GroupByExecutor executor = pathToExecutorEntry.getValue();
                List<AggregateResult> aggregations = executor.calcResult(this.curStartTime, this.curEndTime);
                for (int i = 0; i < aggregations.size(); ++i) {
                    int resultIndex = this.resultIndexes.get(pathToExecutorEntry.getKey()).get(i);
                    fields[resultIndex] = aggregations.get(i);
                }
            }
        }
        catch (QueryProcessException e) {
            logger.error("GroupByWithoutValueFilterDataSet execute has error", (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
        for (AggregateResult res : fields) {
            if (res == null) {
                record.addField(null);
                continue;
            }
            record.addField(res.getResult(), res.getResultDataType());
        }
        return record;
    }

    protected GroupByExecutor getGroupByExecutor(Path path, Set<String> allSensors, TSDataType dataType, QueryContext context, Filter timeFilter, TsFileFilter fileFilter) throws StorageEngineException, QueryProcessException {
        return new LocalGroupByExecutor(path, allSensors, dataType, context, timeFilter, fileFilter);
    }
}

