/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import org.apache.iotdb.db.qp.physical.crud.GroupByPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Pair;

public abstract class GroupByEngineDataSet
extends QueryDataSet {
    protected long queryId;
    protected long interval;
    protected long slidingStep;
    protected long startTime;
    protected long endTime;
    protected long curStartTime;
    protected long curEndTime;
    protected boolean hasCachedTimeInterval;
    protected boolean leftCRightO;

    public GroupByEngineDataSet() {
    }

    public GroupByEngineDataSet(QueryContext context, GroupByPlan groupByPlan) {
        super(groupByPlan.getDeduplicatedPaths(), groupByPlan.getDeduplicatedDataTypes());
        this.queryId = context.getQueryId();
        this.interval = groupByPlan.getInterval();
        this.slidingStep = groupByPlan.getSlidingStep();
        this.startTime = groupByPlan.getStartTime();
        this.endTime = groupByPlan.getEndTime();
        this.leftCRightO = groupByPlan.isLeftCRightO();
        this.hasCachedTimeInterval = false;
        this.curStartTime = this.startTime - this.slidingStep;
        this.curEndTime = -1L;
    }

    protected boolean hasNextWithoutConstraint() {
        if (this.hasCachedTimeInterval) {
            return true;
        }
        this.curStartTime += this.slidingStep;
        if (this.curStartTime < this.endTime) {
            this.hasCachedTimeInterval = true;
            this.curEndTime = Math.min(this.curStartTime + this.interval, this.endTime);
            return true;
        }
        return false;
    }

    protected abstract RowRecord nextWithoutConstraint() throws IOException;

    public long getStartTime() {
        return this.startTime;
    }

    public Pair<Long, Long> nextTimePartition() {
        this.hasCachedTimeInterval = false;
        return new Pair((Object)this.curStartTime, (Object)this.curEndTime);
    }
}

