/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryFileManager;
import org.apache.iotdb.db.query.externalsort.serialize.IExternalSortFileDeserializer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class QueryResourceManager {
    private AtomicLong queryIdAtom = new AtomicLong();
    private QueryFileManager filePathsManager = new QueryFileManager();
    private Map<Long, List<IExternalSortFileDeserializer>> externalSortFileMap = new ConcurrentHashMap<Long, List<IExternalSortFileDeserializer>>();

    private QueryResourceManager() {
    }

    public static QueryResourceManager getInstance() {
        return QueryTokenManagerHelper.INSTANCE;
    }

    public long assignQueryId(boolean isDataQuery) {
        long queryId = this.queryIdAtom.incrementAndGet();
        if (isDataQuery) {
            this.filePathsManager.addQueryId(queryId);
        }
        return queryId;
    }

    public void registerTempExternalSortFile(long queryId, IExternalSortFileDeserializer deserializer) {
        this.externalSortFileMap.computeIfAbsent(queryId, x -> new ArrayList()).add(deserializer);
    }

    public QueryDataSource getQueryDataSource(Path selectedPath, QueryContext context, Filter filter) throws StorageEngineException, QueryProcessException {
        SingleSeriesExpression singleSeriesExpression = new SingleSeriesExpression(selectedPath, filter);
        return StorageEngine.getInstance().query(singleSeriesExpression, context, this.filePathsManager);
    }

    public void endQuery(long queryId) throws StorageEngineException {
        if (this.externalSortFileMap.get(queryId) != null) {
            for (IExternalSortFileDeserializer deserializer : this.externalSortFileMap.get(queryId)) {
                try {
                    deserializer.close();
                }
                catch (IOException e) {
                    throw new StorageEngineException(e);
                }
            }
            this.externalSortFileMap.remove(queryId);
        }
        this.filePathsManager.removeUsedFilesForQuery(queryId);
    }

    private static class QueryTokenManagerHelper {
        private static final QueryResourceManager INSTANCE = new QueryResourceManager();

        private QueryTokenManagerHelper() {
        }
    }
}

