/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class MinValueAggrResult
extends AggregateResult {
    public MinValueAggrResult(TSDataType dataType) {
        super(dataType, AggregationType.MIN_VALUE);
        this.reset();
    }

    @Override
    public Object getResult() {
        return this.hasResult() ? this.getValue() : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        Comparable minVal = (Comparable)statistics.getMinValue();
        this.updateResult(minVal);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage) {
        this.updateResultFromPageData(dataInThisPage, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long bound) {
        while (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < bound) {
            this.updateResult((Comparable)dataInThisPage.currentValue());
            dataInThisPage.next();
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Comparable minVal = null;
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null || minVal != null && minVal.compareTo(value) <= 0) continue;
            minVal = (Comparable)value;
        }
        this.updateResult(minVal);
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        if (another.getResult() != null) {
            Object value = another.getResult();
            this.updateResult((Comparable)value);
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) throws IOException {
    }

    private void updateResult(Comparable<Object> minVal) {
        if (minVal == null) {
            return;
        }
        if (!this.hasResult() || minVal.compareTo(this.getValue()) < 0) {
            this.setValue(minVal);
        }
    }
}

