/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class CountAggrResult
extends AggregateResult {
    public CountAggrResult() {
        super(TSDataType.INT64, AggregationType.COUNT);
        this.reset();
        this.setLongValue(0L);
    }

    @Override
    public Long getResult() {
        return this.getLongValue();
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        long preValue = this.getLongValue();
        this.setLongValue(preValue += statistics.getCount());
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage) {
        int cnt = dataInThisPage.length();
        long preValue = this.getLongValue();
        this.setLongValue(preValue += (long)cnt);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long bound) {
        while (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < bound) {
            long preValue = this.getLongValue();
            this.setLongValue(++preValue);
            dataInThisPage.next();
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        int cnt = 0;
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            ++cnt;
        }
        long preValue = this.getLongValue();
        this.setLongValue(preValue += (long)cnt);
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        CountAggrResult anotherCount = (CountAggrResult)another;
        this.setLongValue(anotherCount.getResult() + this.getResult());
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) throws IOException {
    }
}

