/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.DeleteDataOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.InsertOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.sys.AlterTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.logical.sys.CountOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.DataAuthOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.FlushOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadDataOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadFilesOperator;
import org.apache.iotdb.db.qp.logical.sys.MoveFileOperator;
import org.apache.iotdb.db.qp.logical.sys.RemoveFileOperator;
import org.apache.iotdb.db.qp.logical.sys.SetStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.SetTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowChildPathsOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowDevicesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTimeSeriesOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.AlterTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.ClearCachePlan;
import org.apache.iotdb.db.qp.physical.sys.CountPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadDataPlan;
import org.apache.iotdb.db.qp.physical.sys.MergePlan;
import org.apache.iotdb.db.qp.physical.sys.OperateFilePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowChildPathsPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.utils.Pair;

public class PhysicalGenerator {
    public PhysicalPlan transformToPhysicalPlan(Operator operator) throws QueryProcessException {
        switch (operator.getType()) {
            case AUTHOR: {
                AuthorOperator author = (AuthorOperator)operator;
                try {
                    return new AuthorPlan(author.getAuthorType(), author.getUserName(), author.getRoleName(), author.getPassWord(), author.getNewPassword(), author.getPrivilegeList(), author.getNodeName());
                }
                catch (AuthException e) {
                    throw new QueryProcessException(e.getMessage());
                }
            }
            case GRANT_WATERMARK_EMBEDDING: 
            case REVOKE_WATERMARK_EMBEDDING: {
                DataAuthOperator dataAuthOperator = (DataAuthOperator)operator;
                return new DataAuthPlan(dataAuthOperator.getType(), dataAuthOperator.getUsers());
            }
            case LOADDATA: {
                LoadDataOperator loadData = (LoadDataOperator)operator;
                return new LoadDataPlan(loadData.getInputFilePath(), loadData.getMeasureType());
            }
            case METADATA: 
            case SET_STORAGE_GROUP: {
                SetStorageGroupOperator setStorageGroup = (SetStorageGroupOperator)operator;
                return new SetStorageGroupPlan(setStorageGroup.getPath());
            }
            case DELETE_STORAGE_GROUP: {
                DeleteStorageGroupOperator deleteStorageGroup = (DeleteStorageGroupOperator)operator;
                return new DeleteStorageGroupPlan(deleteStorageGroup.getDeletePathList());
            }
            case CREATE_TIMESERIES: {
                CreateTimeSeriesOperator createOperator = (CreateTimeSeriesOperator)operator;
                if (createOperator.getTags() != null && !createOperator.getTags().isEmpty() && createOperator.getAttributes() != null && !createOperator.getAttributes().isEmpty()) {
                    for (String tagKey : createOperator.getTags().keySet()) {
                        if (!createOperator.getAttributes().containsKey(tagKey)) continue;
                        throw new QueryProcessException(String.format("Tag and attribute shouldn't have the same property key [%s]", tagKey));
                    }
                }
                return new CreateTimeSeriesPlan(createOperator.getPath(), createOperator.getDataType(), createOperator.getEncoding(), createOperator.getCompressor(), createOperator.getProps(), createOperator.getTags(), createOperator.getAttributes(), createOperator.getAlias());
            }
            case DELETE_TIMESERIES: {
                DeleteTimeSeriesOperator deletePath = (DeleteTimeSeriesOperator)operator;
                return new DeleteTimeSeriesPlan(deletePath.getDeletePathList());
            }
            case ALTER_TIMESERIES: {
                AlterTimeSeriesOperator alterTimeSeriesOperator = (AlterTimeSeriesOperator)operator;
                return new AlterTimeSeriesPlan(alterTimeSeriesOperator.getPath(), alterTimeSeriesOperator.getAlterType(), alterTimeSeriesOperator.getAlterMap(), alterTimeSeriesOperator.getAlias(), alterTimeSeriesOperator.getTagsMap(), alterTimeSeriesOperator.getAttributesMap());
            }
            case DELETE: {
                DeleteDataOperator delete = (DeleteDataOperator)operator;
                List<Path> paths = delete.getSelectedPaths();
                return new DeletePlan(delete.getTime(), paths);
            }
            case INSERT: {
                InsertOperator insert = (InsertOperator)operator;
                List<Path> paths = insert.getSelectedPaths();
                if (paths.size() != 1) {
                    throw new LogicalOperatorException("For Insert command, cannot specified more than one seriesPath: " + paths);
                }
                return new InsertPlan(paths.get(0).getFullPath(), insert.getTime(), insert.getMeasurementList(), insert.getValueList());
            }
            case MERGE: {
                if (operator.getTokenIntType() == 83) {
                    return new MergePlan(Operator.OperatorType.FULL_MERGE);
                }
                return new MergePlan();
            }
            case FLUSH: {
                FlushOperator flushOperator = (FlushOperator)operator;
                return new FlushPlan(flushOperator.isSeq(), flushOperator.getStorageGroupList());
            }
            case QUERY: {
                QueryOperator query = (QueryOperator)operator;
                return this.transformQuery(query);
            }
            case TTL: {
                switch (operator.getTokenIntType()) {
                    case 63: {
                        SetTTLOperator setTTLOperator = (SetTTLOperator)operator;
                        return new SetTTLPlan(setTTLOperator.getStorageGroup(), setTTLOperator.getDataTTL());
                    }
                    case 64: {
                        SetTTLOperator unsetTTLOperator = (SetTTLOperator)operator;
                        return new SetTTLPlan(unsetTTLOperator.getStorageGroup());
                    }
                    case 65: {
                        ShowTTLOperator showTTLOperator = (ShowTTLOperator)operator;
                        return new ShowTTLPlan(showTTLOperator.getStorageGroups());
                    }
                }
                throw new LogicalOperatorException(String.format("not supported operator type %s in ttl operation.", new Object[]{operator.getType()}));
            }
            case LOAD_CONFIGURATION: {
                return new LoadConfigurationPlan();
            }
            case SHOW: {
                switch (operator.getTokenIntType()) {
                    case 68: {
                        return new ShowPlan(ShowPlan.ShowContentType.DYNAMIC_PARAMETER);
                    }
                    case 67: {
                        return new ShowPlan(ShowPlan.ShowContentType.FLUSH_TASK_INFO);
                    }
                    case 72: {
                        return new ShowPlan(ShowPlan.ShowContentType.VERSION);
                    }
                    case 73: {
                        ShowTimeSeriesOperator showTimeSeriesOperator = (ShowTimeSeriesOperator)operator;
                        return new ShowTimeSeriesPlan(showTimeSeriesOperator.getPath(), showTimeSeriesOperator.isContains(), showTimeSeriesOperator.getKey(), showTimeSeriesOperator.getValue(), showTimeSeriesOperator.getLimit(), showTimeSeriesOperator.getOffset());
                    }
                    case 74: {
                        return new ShowPlan(ShowPlan.ShowContentType.STORAGE_GROUP);
                    }
                    case 76: {
                        return new ShowDevicesPlan(ShowPlan.ShowContentType.DEVICES, ((ShowDevicesOperator)operator).getPath());
                    }
                    case 78: {
                        return new CountPlan(ShowPlan.ShowContentType.COUNT_NODE_TIMESERIES, ((CountOperator)operator).getPath(), ((CountOperator)operator).getLevel());
                    }
                    case 79: {
                        return new CountPlan(ShowPlan.ShowContentType.COUNT_NODES, ((CountOperator)operator).getPath(), ((CountOperator)operator).getLevel());
                    }
                    case 77: {
                        return new CountPlan(ShowPlan.ShowContentType.COUNT_TIMESERIES, ((CountOperator)operator).getPath());
                    }
                    case 75: {
                        return new ShowChildPathsPlan(ShowPlan.ShowContentType.CHILD_PATH, ((ShowChildPathsOperator)operator).getPath());
                    }
                }
                throw new LogicalOperatorException(String.format("not supported operator type %s in show operation.", new Object[]{operator.getType()}));
            }
            case LOAD_FILES: {
                return new OperateFilePlan(((LoadFilesOperator)operator).getFile(), Operator.OperatorType.LOAD_FILES, ((LoadFilesOperator)operator).isAutoCreateSchema(), ((LoadFilesOperator)operator).getSgLevel());
            }
            case REMOVE_FILE: {
                return new OperateFilePlan(((RemoveFileOperator)operator).getFile(), Operator.OperatorType.REMOVE_FILE);
            }
            case MOVE_FILE: {
                return new OperateFilePlan(((MoveFileOperator)operator).getFile(), ((MoveFileOperator)operator).getTargetDir(), Operator.OperatorType.MOVE_FILE);
            }
            case CLEAR_CACHE: {
                return new ClearCachePlan();
            }
        }
        throw new LogicalOperatorException(operator.getType().toString(), "");
    }

    protected Pair<List<TSDataType>, List<TSDataType>> getSeriesTypes(List<String> paths, String aggregation) throws MetadataException {
        List<TSDataType> measurementDataTypes = SchemaUtils.getSeriesTypesByString(paths, null);
        if (aggregation == null) {
            return new Pair(measurementDataTypes, measurementDataTypes);
        }
        List<TSDataType> columnDataTypes = SchemaUtils.getSeriesTypesByString(paths, aggregation);
        return new Pair(columnDataTypes, measurementDataTypes);
    }

    protected List<TSDataType> getSeriesTypes(List<Path> paths) throws MetadataException {
        return SchemaUtils.getSeriesTypesByPath(paths);
    }

    private PhysicalPlan transformQuery(QueryOperator queryOperator) throws QueryProcessException {
        List<Path> paths;
        QueryPlan queryPlan;
        if (queryOperator.isGroupBy() && queryOperator.isFill()) {
            queryPlan = new GroupByFillPlan();
            queryPlan.setInterval(queryOperator.getUnit());
            queryPlan.setSlidingStep(queryOperator.getSlidingStep());
            queryPlan.setLeftCRightO(queryOperator.isLeftCRightO());
            if (!queryOperator.isLeftCRightO()) {
                ((GroupByPlan)queryPlan).setStartTime(queryOperator.getStartTime() + 1L);
                ((GroupByPlan)queryPlan).setEndTime(queryOperator.getEndTime() + 1L);
            } else {
                ((GroupByPlan)queryPlan).setStartTime(queryOperator.getStartTime());
                ((GroupByPlan)queryPlan).setEndTime(queryOperator.getEndTime());
            }
            ((GroupByFillPlan)queryPlan).setAggregations(queryOperator.getSelectOperator().getAggregations());
            for (String aggregation : ((PhysicalPlan)queryPlan).getAggregations()) {
                if ("last_value".equals(aggregation)) continue;
                throw new QueryProcessException("Group By Fill only support last_value function");
            }
            ((GroupByFillPlan)queryPlan).setFillType(queryOperator.getFillTypes());
        } else if (queryOperator.isGroupBy()) {
            queryPlan = new GroupByPlan();
            ((GroupByPlan)queryPlan).setInterval(queryOperator.getUnit());
            ((GroupByPlan)queryPlan).setSlidingStep(queryOperator.getSlidingStep());
            ((GroupByPlan)queryPlan).setLeftCRightO(queryOperator.isLeftCRightO());
            if (!queryOperator.isLeftCRightO()) {
                ((GroupByPlan)queryPlan).setStartTime(queryOperator.getStartTime() + 1L);
                ((GroupByPlan)queryPlan).setEndTime(queryOperator.getEndTime() + 1L);
            } else {
                ((GroupByPlan)queryPlan).setStartTime(queryOperator.getStartTime());
                ((GroupByPlan)queryPlan).setEndTime(queryOperator.getEndTime());
            }
            ((GroupByPlan)queryPlan).setAggregations(queryOperator.getSelectOperator().getAggregations());
        } else if (queryOperator.isFill()) {
            queryPlan = new FillQueryPlan();
            FilterOperator timeFilter = queryOperator.getFilterOperator();
            if (!timeFilter.isSingle()) {
                throw new QueryProcessException("Slice query must select a single time point");
            }
            long time = Long.parseLong(((BasicFunctionOperator)timeFilter).getValue());
            ((FillQueryPlan)queryPlan).setQueryTime(time);
            ((FillQueryPlan)queryPlan).setFillType(queryOperator.getFillTypes());
        } else if (queryOperator.hasAggregation()) {
            queryPlan = new AggregationPlan();
            ((AggregationPlan)queryPlan).setAggregations(queryOperator.getSelectOperator().getAggregations());
        } else {
            queryPlan = queryOperator.isLastQuery() ? new LastQueryPlan() : new RawDataQueryPlan();
        }
        if (queryPlan instanceof LastQueryPlan) {
            if (!queryOperator.isAlignByTime()) {
                throw new QueryProcessException("Disable align cannot be applied to LAST query.");
            }
            paths = queryOperator.getSelectedPaths();
            queryPlan.setPaths(paths);
        } else if (queryOperator.isAlignByDevice()) {
            AlignByDevicePlan alignByDevicePlan = new AlignByDevicePlan();
            if (queryPlan instanceof GroupByPlan) {
                alignByDevicePlan.setGroupByPlan((GroupByPlan)queryPlan);
            } else if (queryPlan instanceof FillQueryPlan) {
                alignByDevicePlan.setFillQueryPlan((FillQueryPlan)queryPlan);
            } else if (queryPlan instanceof AggregationPlan) {
                alignByDevicePlan.setAggregationPlan((AggregationPlan)queryPlan);
            }
            List<Path> prefixPaths = queryOperator.getFromOperator().getPrefixPaths();
            List<String> devices = this.removeStarsInDeviceWithUnique(prefixPaths);
            List<Path> suffixPaths = queryOperator.getSelectOperator().getSuffixPaths();
            List<String> originAggregations = queryOperator.getSelectOperator().getAggregations();
            List<String> measurements = new ArrayList<String>();
            HashMap<String, TSDataType> columnDataTypeMap = new HashMap<String, TSDataType>();
            HashMap<String, AlignByDevicePlan.MeasurementType> measurementTypeMap = new HashMap<String, AlignByDevicePlan.MeasurementType>();
            HashMap<String, TSDataType> measurementDataTypeMap = new HashMap<String, TSDataType>();
            ArrayList<Path> paths2 = new ArrayList<Path>();
            for (int i = 0; i < suffixPaths.size(); ++i) {
                Path suffixPath = suffixPaths.get(i);
                LinkedHashSet<String> measurementSetOfGivenSuffix = new LinkedHashSet<String>();
                if (suffixPath.startWith("'") || suffixPath.startWith("\"")) {
                    measurements.add(suffixPath.getMeasurement());
                    measurementTypeMap.put(suffixPath.getMeasurement(), AlignByDevicePlan.MeasurementType.Constant);
                    continue;
                }
                for (String device : devices) {
                    Path fullPath = Path.addPrefixPath((Path)suffixPath, (String)device);
                    try {
                        String nonExistMeasurement;
                        List<String> actualPaths = this.getMatchedTimeseries(fullPath.getFullPath());
                        if (actualPaths.isEmpty() && originAggregations.isEmpty() && measurementSetOfGivenSuffix.add(nonExistMeasurement = fullPath.getMeasurement()) && measurementTypeMap.get(nonExistMeasurement) != AlignByDevicePlan.MeasurementType.Exist) {
                            measurementTypeMap.put(fullPath.getMeasurement(), AlignByDevicePlan.MeasurementType.NonExist);
                        }
                        String aggregation = originAggregations != null && !originAggregations.isEmpty() ? originAggregations.get(i) : null;
                        Pair<List<TSDataType>, List<TSDataType>> pair = this.getSeriesTypes(actualPaths, aggregation);
                        List columnDataTypes = (List)pair.left;
                        List measurementDataTypes = (List)pair.right;
                        for (int pathIdx = 0; pathIdx < actualPaths.size(); ++pathIdx) {
                            Path path = new Path(actualPaths.get(pathIdx));
                            String measurementChecked = originAggregations != null && !originAggregations.isEmpty() ? originAggregations.get(i) + "(" + path.getMeasurement() + ")" : path.getMeasurement();
                            TSDataType columnDataType = (TSDataType)columnDataTypes.get(pathIdx);
                            if (columnDataTypeMap.containsKey(measurementChecked)) {
                                if (!columnDataType.equals(columnDataTypeMap.get(measurementChecked))) {
                                    throw new QueryProcessException("The data types of the same measurement column should be the same across devices in ALIGN_BY_DEVICE sql. For more details please refer to the SQL document.");
                                }
                            } else {
                                columnDataTypeMap.put(measurementChecked, columnDataType);
                                measurementDataTypeMap.put(measurementChecked, (TSDataType)measurementDataTypes.get(pathIdx));
                            }
                            if (measurementSetOfGivenSuffix.add(measurementChecked) || measurementTypeMap.get(measurementChecked) != AlignByDevicePlan.MeasurementType.Exist) {
                                measurementTypeMap.put(measurementChecked, AlignByDevicePlan.MeasurementType.Exist);
                            }
                            paths2.add(path);
                        }
                    }
                    catch (MetadataException e) {
                        throw new LogicalOptimizeException(String.format("Error when getting all paths of a full path: %s", fullPath.getFullPath()) + e.getMessage());
                    }
                }
                measurements.addAll(measurementSetOfGivenSuffix);
            }
            if (queryOperator.hasSlimit()) {
                int seriesSlimit = queryOperator.getSeriesLimit();
                int seriesOffset = queryOperator.getSeriesOffset();
                measurements = this.slimitTrimColumn(measurements, seriesSlimit, seriesOffset);
            }
            alignByDevicePlan.setMeasurements(measurements);
            alignByDevicePlan.setDevices(devices);
            alignByDevicePlan.setColumnDataTypeMap(columnDataTypeMap);
            alignByDevicePlan.setMeasurementTypeMap(measurementTypeMap);
            alignByDevicePlan.setMeasurementDataTypeMap(measurementDataTypeMap);
            alignByDevicePlan.setPaths(paths2);
            FilterOperator filterOperator = queryOperator.getFilterOperator();
            if (filterOperator != null) {
                alignByDevicePlan.setDeviceToFilterMap(this.concatFilterByDevice(devices, filterOperator));
            }
            queryPlan = alignByDevicePlan;
        } else {
            queryPlan.setAlignByTime(queryOperator.isAlignByTime());
            paths = queryOperator.getSelectedPaths();
            queryPlan.setPaths(paths);
            FilterOperator filterOperator = queryOperator.getFilterOperator();
            if (filterOperator != null) {
                ArrayList<Path> filterPaths = new ArrayList<Path>(filterOperator.getPathSet());
                try {
                    List<TSDataType> seriesTypes = this.getSeriesTypes(filterPaths);
                    HashMap<Path, TSDataType> pathTSDataTypeHashMap = new HashMap<Path, TSDataType>();
                    for (int i = 0; i < filterPaths.size(); ++i) {
                        queryPlan.addFilterPathInDeviceToMeasurements((Path)filterPaths.get(i));
                        pathTSDataTypeHashMap.put((Path)filterPaths.get(i), seriesTypes.get(i));
                    }
                    IExpression expression = filterOperator.transformToExpression(pathTSDataTypeHashMap);
                    queryPlan.setExpression(expression);
                }
                catch (MetadataException e) {
                    throw new LogicalOptimizeException(e);
                }
            }
        }
        try {
            this.deduplicate(queryPlan);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        queryPlan.setRowLimit(queryOperator.getRowLimit());
        queryPlan.setRowOffset(queryOperator.getRowOffset());
        return queryPlan;
    }

    private Map<String, IExpression> concatFilterByDevice(List<String> devices, FilterOperator operator) throws QueryProcessException {
        HashMap<String, IExpression> deviceToFilterMap = new HashMap<String, IExpression>();
        HashSet<Path> filterPaths = new HashSet<Path>();
        for (String device : devices) {
            FilterOperator newOperator = operator.copy();
            this.concatFilterPath(device, newOperator, filterPaths);
            ArrayList<Path> filterPathList = new ArrayList<Path>(filterPaths);
            try {
                List<TSDataType> seriesTypes = this.getSeriesTypes(filterPathList);
                HashMap<Path, TSDataType> pathTSDataTypeHashMap = new HashMap<Path, TSDataType>();
                for (int i = 0; i < filterPathList.size(); ++i) {
                    pathTSDataTypeHashMap.put((Path)filterPathList.get(i), seriesTypes.get(i));
                }
                deviceToFilterMap.put(device, newOperator.transformToExpression(pathTSDataTypeHashMap));
                filterPaths.clear();
            }
            catch (MetadataException e) {
                throw new QueryProcessException(e);
            }
        }
        return deviceToFilterMap;
    }

    private List<String> removeStarsInDeviceWithUnique(List<Path> paths) throws LogicalOptimizeException {
        ArrayList<String> retDevices;
        LinkedHashSet<String> deviceSet = new LinkedHashSet<String>();
        try {
            for (Path path : paths) {
                Set<String> tempDS = this.getMatchedDevices(path.getFullPath());
                deviceSet.addAll(tempDS);
            }
            retDevices = new ArrayList<String>(deviceSet);
        }
        catch (MetadataException e) {
            throw new LogicalOptimizeException("error when remove star: " + e.getMessage());
        }
        return retDevices;
    }

    private void concatFilterPath(String prefix, FilterOperator operator, Set<Path> filterPaths) {
        if (!operator.isLeaf()) {
            for (FilterOperator child : operator.getChildren()) {
                this.concatFilterPath(prefix, child, filterPaths);
            }
            return;
        }
        BasicFunctionOperator basicOperator = (BasicFunctionOperator)operator;
        Path filterPath = basicOperator.getSinglePath();
        if (SQLConstant.isReservedPath(filterPath) || filterPath.startWith("root")) {
            filterPaths.add(filterPath);
            return;
        }
        Path concatPath = Path.addPrefixPath((Path)filterPath, (String)prefix);
        filterPaths.add(concatPath);
        basicOperator.setSinglePath(concatPath);
    }

    private void deduplicate(QueryPlan queryPlan) throws MetadataException {
        List<Path> paths = queryPlan.getPaths();
        List<TSDataType> dataTypes = this.getSeriesTypes(paths);
        queryPlan.setDataTypes(dataTypes);
        if (queryPlan instanceof AlignByDevicePlan) {
            return;
        }
        RawDataQueryPlan rawDataQueryPlan = (RawDataQueryPlan)queryPlan;
        HashSet<String> columnSet = new HashSet<String>();
        if (queryPlan instanceof LastQueryPlan) {
            for (int i = 0; i < paths.size(); ++i) {
                Path path = paths.get(i);
                String column = path.getAlias() != null ? path.getFullPathWithAlias() : path.toString();
                if (columnSet.contains(column)) continue;
                TSDataType seriesType = dataTypes.get(i);
                rawDataQueryPlan.addDeduplicatedPaths(path);
                rawDataQueryPlan.addDeduplicatedDataTypes(seriesType);
                columnSet.add(column);
            }
            return;
        }
        ArrayList<Pair> indexedPaths = new ArrayList<Pair>();
        for (int i = 0; i < paths.size(); ++i) {
            indexedPaths.add(new Pair((Object)paths.get(i), (Object)i));
        }
        indexedPaths.sort(Comparator.comparing(pair -> (Path)pair.left));
        int index = 0;
        for (Pair indexedPath : indexedPaths) {
            String column = ((Path)indexedPath.left).getAlias() != null ? ((Path)indexedPath.left).getFullPathWithAlias() : ((Path)indexedPath.left).toString();
            if (queryPlan instanceof AggregationPlan) {
                column = queryPlan.getAggregations().get((Integer)indexedPath.right) + "(" + column + ")";
            }
            if (columnSet.contains(column)) continue;
            TSDataType seriesType = dataTypes.get((Integer)indexedPath.right);
            rawDataQueryPlan.addDeduplicatedPaths((Path)indexedPath.left);
            rawDataQueryPlan.addDeduplicatedDataTypes(seriesType);
            columnSet.add(column);
            rawDataQueryPlan.addPathToIndex(column, index++);
            if (!(queryPlan instanceof AggregationPlan)) continue;
            ((AggregationPlan)queryPlan).addDeduplicatedAggregations(queryPlan.getAggregations().get((Integer)indexedPath.right));
        }
    }

    private List<String> slimitTrimColumn(List<String> columnList, int seriesLimit, int seriesOffset) throws QueryProcessException {
        int size = columnList.size();
        if (seriesOffset >= size) {
            throw new QueryProcessException("SOFFSET <SOFFSETValue>: SOFFSETValue exceeds the range.");
        }
        int endPosition = seriesOffset + seriesLimit;
        if (endPosition > size) {
            endPosition = size;
        }
        return new ArrayList<String>(columnList.subList(seriesOffset, endPosition));
    }

    protected List<String> getMatchedTimeseries(String path) throws MetadataException {
        return MManager.getInstance().getAllTimeseriesName(path);
    }

    protected Set<String> getMatchedDevices(String path) throws MetadataException {
        return MManager.getInstance().getDevices(path);
    }
}

