/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.read.common.Path;

public class SetStorageGroupPlan
extends PhysicalPlan {
    private Path path;

    public SetStorageGroupPlan() {
        super(false, Operator.OperatorType.SET_STORAGE_GROUP);
    }

    public SetStorageGroupPlan(Path path) {
        super(false, Operator.OperatorType.SET_STORAGE_GROUP);
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    @Override
    public List<Path> getPaths() {
        ArrayList<Path> ret = new ArrayList<Path>();
        if (this.path != null) {
            ret.add(this.path);
        }
        return ret;
    }

    @Override
    public void serializeTo(DataOutputStream stream) throws IOException {
        stream.write((byte)PhysicalPlan.PhysicalPlanType.SET_STORAGE_GROUP.ordinal());
        byte[] fullPathBytes = this.path.getFullPath().getBytes();
        stream.writeInt(fullPathBytes.length);
        stream.write(fullPathBytes);
    }

    @Override
    public void deserializeFrom(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] fullPathBytes = new byte[length];
        buffer.get(fullPathBytes);
        this.path = new Path(new String(fullPathBytes));
    }

    public String toString() {
        return "SetStorageGroup{" + this.path + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetStorageGroupPlan that = (SetStorageGroupPlan)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }
}

