/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class InsertTabletPlan
extends PhysicalPlan {
    private static final String DATATYPE_UNSUPPORTED = "Data type %s is not supported.";
    private String deviceId;
    private String[] measurements;
    private TSDataType[] dataTypes;
    private MeasurementSchema[] schemas;
    private long[] times;
    private ByteBuffer timeBuffer;
    private Object[] columns;
    private ByteBuffer valueBuffer;
    private Set<Integer> index;
    private int rowCount = 0;
    private Long maxTime = null;
    private Long minTime = null;
    private List<Path> paths;
    private int start;
    private int end;

    public InsertTabletPlan() {
        super(false, Operator.OperatorType.BATCHINSERT);
    }

    public InsertTabletPlan(String deviceId, List<String> measurements) {
        super(false, Operator.OperatorType.BATCHINSERT);
        this.deviceId = deviceId;
        this.setMeasurements(measurements);
    }

    public InsertTabletPlan(String deviceId, String[] measurements) {
        super(false, Operator.OperatorType.BATCHINSERT);
        this.deviceId = deviceId;
        this.setMeasurements(measurements);
    }

    public InsertTabletPlan(String deviceId, String[] measurements, List<Integer> dataTypes) {
        super(false, Operator.OperatorType.BATCHINSERT);
        this.deviceId = deviceId;
        this.measurements = measurements;
        this.setDataTypes(dataTypes);
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public Set<Integer> getIndex() {
        return this.index;
    }

    public void setIndex(Set<Integer> index) {
        this.index = index;
    }

    @Override
    public List<Path> getPaths() {
        if (this.paths != null) {
            return this.paths;
        }
        ArrayList<Path> ret = new ArrayList<Path>();
        for (String m : this.measurements) {
            ret.add(new Path(this.deviceId, m));
        }
        this.paths = ret;
        return ret;
    }

    @Override
    public void serializeTo(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.BATCHINSERT.ordinal();
        stream.writeByte((byte)type);
        this.putString(stream, this.deviceId);
        stream.writeInt(this.measurements.length);
        for (String string : this.measurements) {
            this.putString(stream, string);
        }
        for (String string : this.dataTypes) {
            stream.writeShort(string.serialize());
        }
        stream.writeInt(this.index.size());
        if (this.timeBuffer == null) {
            Iterator<Integer> iterator = this.index.iterator();
            while (iterator.hasNext()) {
                int loc = (Integer)iterator.next();
                stream.writeLong(this.times[loc]);
            }
        } else {
            stream.write(this.timeBuffer.array());
            this.timeBuffer = null;
        }
        if (this.valueBuffer == null) {
            this.serializeValues(stream);
        } else {
            stream.write(this.valueBuffer.array());
            this.valueBuffer = null;
        }
    }

    private void serializeValues(DataOutputStream stream) throws IOException {
        for (int i = 0; i < this.measurements.length; ++i) {
            this.serializeColumn(this.dataTypes[i], this.columns[i], stream, this.index);
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, DataOutputStream stream, Set<Integer> index) throws IOException {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])column;
                for (int loc : index) {
                    stream.writeInt(intValues[loc]);
                }
                break;
            }
            case INT64: {
                long[] longValues = (long[])column;
                for (int loc : index) {
                    stream.writeLong(longValues[loc]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int loc : index) {
                    stream.writeFloat(floatValues[loc]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int loc : index) {
                    stream.writeDouble(doubleValues[loc]);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int loc : index) {
                    stream.write(BytesUtils.boolToByte((boolean)boolValues[loc]));
                }
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])column;
                for (int loc : index) {
                    stream.writeInt(binaryValues[loc].getLength());
                    stream.write(binaryValues[loc].getValues());
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    @Override
    public void serializeTo(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.BATCHINSERT.ordinal();
        buffer.put((byte)type);
        this.putString(buffer, this.deviceId);
        buffer.putInt(this.measurements.length);
        for (String string : this.measurements) {
            this.putString(buffer, string);
        }
        for (String string : this.dataTypes) {
            string.serializeTo(buffer);
        }
        buffer.putInt(this.end - this.start);
        if (this.timeBuffer == null) {
            for (int i = this.start; i < this.end; ++i) {
                buffer.putLong(this.times[i]);
            }
        } else {
            buffer.put(this.timeBuffer.array());
            this.timeBuffer = null;
        }
        if (this.valueBuffer == null) {
            this.serializeValues(buffer);
        } else {
            buffer.put(this.valueBuffer.array());
            this.valueBuffer = null;
        }
    }

    private void serializeValues(ByteBuffer buffer) {
        for (int i = 0; i < this.measurements.length; ++i) {
            this.serializeColumn(this.dataTypes[i], this.columns[i], buffer, this.start, this.end);
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, ByteBuffer buffer, int start, int end) {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putInt(intValues[j]);
                }
                break;
            }
            case INT64: {
                long[] longValues = (long[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putLong(longValues[j]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putFloat(floatValues[j]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putDouble(doubleValues[j]);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putInt(BytesUtils.boolToByte((boolean)boolValues[j]));
                }
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putInt(binaryValues[j].getLength());
                    buffer.put(binaryValues[j].getValues());
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    public void setTimeBuffer(ByteBuffer timeBuffer) {
        this.timeBuffer = timeBuffer;
        this.timeBuffer.position(0);
    }

    public void setValueBuffer(ByteBuffer valueBuffer) {
        this.valueBuffer = valueBuffer;
        this.timeBuffer.position(0);
    }

    @Override
    public void deserializeFrom(ByteBuffer buffer) {
        int rows;
        int i;
        this.deviceId = this.readString(buffer);
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        for (i = 0; i < measurementSize; ++i) {
            this.measurements[i] = this.readString(buffer);
        }
        this.dataTypes = new TSDataType[measurementSize];
        for (i = 0; i < measurementSize; ++i) {
            this.dataTypes[i] = TSDataType.deserialize((short)buffer.getShort());
        }
        this.rowCount = rows = buffer.getInt();
        this.times = new long[rows];
        this.times = QueryDataSetUtils.readTimesFromBuffer(buffer, rows);
        this.columns = QueryDataSetUtils.readValuesFromBuffer(buffer, this.dataTypes, measurementSize, rows);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String[] getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(List<String> measurements) {
        this.measurements = new String[measurements.size()];
        measurements.toArray(this.measurements);
    }

    public void setMeasurements(String[] measurements) {
        this.measurements = measurements;
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public MeasurementSchema[] getSchemas() {
        return this.schemas;
    }

    public void setSchemas(MeasurementSchema[] schemas) {
        this.schemas = schemas;
    }

    public void setDataTypes(List<Integer> dataTypes) {
        this.dataTypes = new TSDataType[dataTypes.size()];
        for (int i = 0; i < dataTypes.size(); ++i) {
            this.dataTypes[i] = TSDataType.values()[dataTypes.get(i)];
        }
    }

    public void setDataTypes(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    public Object[] getColumns() {
        return this.columns;
    }

    public void setColumns(Object[] columns) {
        this.columns = columns;
    }

    public void setColumn(int index, Object column) {
        this.columns[index] = column;
    }

    public long getMinTime() {
        if (this.minTime != null) {
            return this.minTime;
        }
        this.minTime = Long.MAX_VALUE;
        long[] lArray = this.times;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long time = lArray[i];
            if (time >= this.minTime) continue;
            this.minTime = time;
        }
        return this.minTime;
    }

    public long getMaxTime() {
        if (this.maxTime != null) {
            return this.maxTime;
        }
        long tmpMaxTime = Long.MIN_VALUE;
        long[] lArray = this.times;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long time = lArray[i];
            if (time <= tmpMaxTime) continue;
            tmpMaxTime = time;
        }
        return tmpMaxTime;
    }

    public TimeValuePair composeLastTimeValuePair(int measurementIndex) {
        TsPrimitiveType.TsInt value;
        if (measurementIndex >= this.columns.length) {
            return null;
        }
        switch (this.dataTypes[measurementIndex]) {
            case INT32: {
                int[] intValues = (int[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsInt(intValues[this.rowCount - 1]);
                break;
            }
            case INT64: {
                long[] longValues = (long[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsLong(longValues[this.rowCount - 1]);
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsFloat(floatValues[this.rowCount - 1]);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsDouble(doubleValues[this.rowCount - 1]);
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsBoolean(boolValues[this.rowCount - 1]);
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsBinary(binaryValues[this.rowCount - 1]);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, this.dataTypes[measurementIndex]));
            }
        }
        return new TimeValuePair(this.times[this.rowCount - 1], (TsPrimitiveType)value);
    }

    public long[] getTimes() {
        return this.times;
    }

    public void setTimes(long[] times) {
        this.times = times;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int size) {
        this.rowCount = size;
    }
}

