/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertPlan
extends PhysicalPlan {
    private static final Logger logger = LoggerFactory.getLogger(InsertPlan.class);
    private long time;
    private String deviceId;
    private String[] measurements;
    private Object[] values;
    private TSDataType[] types;
    private MeasurementSchema[] schemas;
    private boolean inferType = false;
    private List<String> failedMeasurements;

    public InsertPlan() {
        super(false, Operator.OperatorType.INSERT);
        this.canbeSplit = false;
    }

    public InsertPlan(String deviceId, long insertTime, String[] measurements, TSDataType[] types, String[] insertValues) {
        super(false, Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.deviceId = deviceId;
        this.measurements = measurements;
        this.types = types;
        this.values = new Object[measurements.length];
        for (int i = 0; i < measurements.length; ++i) {
            try {
                this.values[i] = CommonUtils.parseValueForTest(types[i], insertValues[i]);
                continue;
            }
            catch (QueryProcessException e) {
                e.printStackTrace();
            }
        }
        this.canbeSplit = false;
    }

    public InsertPlan(String deviceId, long insertTime, String measurement, TSDataType type, String insertValue) {
        super(false, Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.deviceId = deviceId;
        this.measurements = new String[]{measurement};
        this.types = new TSDataType[]{type};
        this.values = new Object[1];
        try {
            this.values[0] = CommonUtils.parseValueForTest(this.types[0], insertValue);
        }
        catch (QueryProcessException e) {
            e.printStackTrace();
        }
        this.canbeSplit = false;
    }

    public InsertPlan(TSRecord tsRecord) {
        super(false, Operator.OperatorType.INSERT);
        this.deviceId = tsRecord.deviceId;
        this.time = tsRecord.time;
        this.measurements = new String[tsRecord.dataPointList.size()];
        this.schemas = new MeasurementSchema[tsRecord.dataPointList.size()];
        this.types = new TSDataType[tsRecord.dataPointList.size()];
        this.values = new Object[tsRecord.dataPointList.size()];
        for (int i = 0; i < tsRecord.dataPointList.size(); ++i) {
            this.measurements[i] = ((DataPoint)tsRecord.dataPointList.get(i)).getMeasurementId();
            this.schemas[i] = new MeasurementSchema(this.measurements[i], ((DataPoint)tsRecord.dataPointList.get(i)).getType(), TSEncoding.PLAIN);
            this.types[i] = ((DataPoint)tsRecord.dataPointList.get(i)).getType();
            this.values[i] = ((DataPoint)tsRecord.dataPointList.get(i)).getValue();
        }
        this.canbeSplit = false;
    }

    public InsertPlan(String deviceId, long insertTime, String[] measurementList, TSDataType[] types, Object[] insertValues) {
        super(false, Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.deviceId = deviceId;
        this.measurements = measurementList;
        this.types = types;
        this.values = insertValues;
        this.canbeSplit = false;
    }

    public InsertPlan(String deviceId, long insertTime, String[] measurementList, String[] insertValues) {
        super(false, Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.deviceId = deviceId;
        this.measurements = measurementList;
        this.types = new TSDataType[this.measurements.length];
        this.values = new Object[this.measurements.length];
        System.arraycopy(insertValues, 0, this.values, 0, this.measurements.length);
        this.inferType = true;
        this.canbeSplit = false;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isInferType() {
        return this.inferType;
    }

    public void setInferType(boolean inferType) {
        this.inferType = inferType;
    }

    public MeasurementSchema[] getSchemas() {
        return this.schemas;
    }

    public void setSchemasAndTransferType(MeasurementSchema[] schemas) throws QueryProcessException {
        this.schemas = schemas;
        if (this.inferType) {
            for (int i = 0; i < schemas.length; ++i) {
                if (schemas[i] == null) continue;
                this.types[i] = schemas[i].getType();
                try {
                    this.values[i] = CommonUtils.parseValue(this.types[i], this.values[i].toString());
                    continue;
                }
                catch (Exception e) {
                    logger.warn("{}.{} data type is not consistent, input {}, registered {}", new Object[]{this.deviceId, this.measurements[i], this.values[i], this.types[i]});
                    if (IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                        this.markMeasurementInsertionFailed(i);
                        schemas[i] = null;
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    public void markMeasurementInsertionFailed(int index) {
        if (this.failedMeasurements == null) {
            this.failedMeasurements = new ArrayList<String>();
        }
        this.failedMeasurements.add(this.measurements[index]);
        this.measurements[index] = null;
        this.types[index] = null;
        this.values[index] = null;
    }

    @Override
    public List<Path> getPaths() {
        ArrayList<Path> ret = new ArrayList<Path>();
        for (String m : this.measurements) {
            ret.add(new Path(this.deviceId, m));
        }
        return ret;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String[] getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(String[] measurements) {
        this.measurements = measurements;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertPlan that = (InsertPlan)o;
        return this.time == that.time && Objects.equals(this.deviceId, that.deviceId) && Arrays.equals(this.measurements, that.measurements) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.time);
    }

    @Override
    public void serializeTo(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.INSERT.ordinal();
        stream.writeByte((byte)type);
        stream.writeLong(this.time);
        this.putString(stream, this.deviceId);
        stream.writeInt(this.measurements.length - (this.failedMeasurements == null ? 0 : this.failedMeasurements.size()));
        for (String string : this.measurements) {
            if (string == null) continue;
            this.putString(stream, string);
        }
        for (String string : this.schemas) {
            if (string == null) continue;
            string.serializeTo((OutputStream)stream);
        }
        try {
            this.putValues(stream);
        }
        catch (QueryProcessException e) {
            throw new IOException(e);
        }
    }

    private void putValues(DataOutputStream outputStream) throws QueryProcessException, IOException {
        block8: for (int i = 0; i < this.values.length; ++i) {
            if (this.types[i] == null) continue;
            ReadWriteIOUtils.write((TSDataType)this.types[i], (OutputStream)outputStream);
            switch (this.types[i]) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)this.values[i]).floatValue(), (OutputStream)outputStream);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                case TEXT: {
                    ReadWriteIOUtils.write((Binary)((Binary)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.types[i]);
                }
            }
        }
    }

    private void putValues(ByteBuffer buffer) throws QueryProcessException {
        block8: for (int i = 0; i < this.values.length; ++i) {
            if (this.types[i] == null) continue;
            ReadWriteIOUtils.write((TSDataType)this.types[i], (ByteBuffer)buffer);
            switch (this.types[i]) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)this.values[i]).floatValue(), (ByteBuffer)buffer);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    ReadWriteIOUtils.write((Binary)((Binary)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.types[i]);
                }
            }
        }
    }

    public List<String> getFailedMeasurements() {
        return this.failedMeasurements;
    }

    public int getFailedMeasurementNumber() {
        return this.failedMeasurements == null ? 0 : this.failedMeasurements.size();
    }

    public TSDataType[] getTypes() {
        return this.types;
    }

    public void setTypes(TSDataType[] types) {
        this.types = types;
    }

    public void setValues(ByteBuffer buffer) throws QueryProcessException {
        block8: for (int i = 0; i < this.measurements.length; ++i) {
            this.types[i] = ReadWriteIOUtils.readDataType((ByteBuffer)buffer);
            switch (this.types[i]) {
                case BOOLEAN: {
                    this.values[i] = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    this.values[i] = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    this.values[i] = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = Float.valueOf(ReadWriteIOUtils.readFloat((ByteBuffer)buffer));
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = ReadWriteIOUtils.readDouble((ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    this.values[i] = ReadWriteIOUtils.readBinary((ByteBuffer)buffer);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.types[i]);
                }
            }
        }
    }

    @Override
    public void serializeTo(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.INSERT.ordinal();
        buffer.put((byte)type);
        buffer.putLong(this.time);
        this.putString(buffer, this.deviceId);
        buffer.putInt(this.measurements.length - (this.failedMeasurements == null ? 0 : this.failedMeasurements.size()));
        for (String measurement : this.measurements) {
            if (measurement == null) continue;
            this.putString(buffer, measurement);
        }
        try {
            this.putValues(buffer);
        }
        catch (QueryProcessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deserializeFrom(ByteBuffer buffer) {
        this.time = buffer.getLong();
        this.deviceId = this.readString(buffer);
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            this.measurements[i] = this.readString(buffer);
        }
        this.types = new TSDataType[measurementSize];
        this.values = new Object[measurementSize];
        try {
            this.setValues(buffer);
        }
        catch (QueryProcessException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "deviceId: " + this.deviceId + ", time: " + this.time;
    }

    public TimeValuePair composeTimeValuePair(int measurementIndex) {
        if (measurementIndex >= this.values.length) {
            return null;
        }
        Object value = this.values[measurementIndex];
        return new TimeValuePair(this.time, TsPrimitiveType.getByType((TSDataType)this.schemas[measurementIndex].getType(), (Object)value));
    }
}

