/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.read.common.Path;

public class DeletePlan
extends PhysicalPlan {
    private long deleteTime;
    private List<Path> paths = new ArrayList<Path>();

    public DeletePlan() {
        super(false, Operator.OperatorType.DELETE);
    }

    public DeletePlan(long deleteTime, Path path) {
        super(false, Operator.OperatorType.DELETE);
        this.deleteTime = deleteTime;
        this.paths.add(path);
    }

    public DeletePlan(long deleteTime, List<Path> paths) {
        super(false, Operator.OperatorType.DELETE);
        this.deleteTime = deleteTime;
        this.paths = paths;
    }

    public long getDeleteTime() {
        return this.deleteTime;
    }

    public void setDeleteTime(long delTime) {
        this.deleteTime = delTime;
    }

    public void addPath(Path path) {
        this.paths.add(path);
    }

    public void addPaths(List<Path> paths) {
        this.paths.addAll(paths);
    }

    @Override
    public List<Path> getPaths() {
        return this.paths;
    }

    public void setPaths(List<Path> paths) {
        this.paths = paths;
    }

    public int hashCode() {
        return Objects.hash(this.deleteTime, this.paths);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletePlan that = (DeletePlan)o;
        return this.deleteTime == that.deleteTime && Objects.equals(this.paths, that.paths);
    }

    @Override
    public void serializeTo(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.DELETE.ordinal();
        stream.writeByte((byte)type);
        stream.writeLong(this.deleteTime);
        this.putString(stream, this.paths.get(0).getFullPath());
    }

    @Override
    public void serializeTo(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.DELETE.ordinal();
        buffer.put((byte)type);
        buffer.putLong(this.deleteTime);
        this.putString(buffer, this.paths.get(0).getFullPath());
    }

    @Override
    public void deserializeFrom(ByteBuffer buffer) {
        this.deleteTime = buffer.getLong();
        this.paths = new ArrayList<Path>();
        this.paths.add(new Path(this.readString(buffer)));
    }
}

