/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.executor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.auth.entity.PathPrivilege;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.entity.User;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.CompressionRatio;
import org.apache.iotdb.db.conf.adapter.IoTDBConfigDynamicAdapter;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.ChunkMetadataCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.flush.pool.FlushTaskPoolManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.DeleteFailedException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.LeafMNode;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UpdatePlan;
import org.apache.iotdb.db.qp.physical.sys.AlterTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.ClearCachePlan;
import org.apache.iotdb.db.qp.physical.sys.CountPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.MergePlan;
import org.apache.iotdb.db.qp.physical.sys.OperateFilePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowChildPathsPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.AlignByDeviceDataSet;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.query.executor.IQueryRouter;
import org.apache.iotdb.db.query.executor.QueryRouter;
import org.apache.iotdb.db.utils.AuthUtils;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.EmptyDataSet;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanExecutor
implements IPlanExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PlanExecutor.class);
    protected IQueryRouter queryRouter;
    private MManager mManager;
    private IAuthorizer authorizer;
    private boolean enablePartialInsert = IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert();

    public PlanExecutor() throws QueryProcessException {
        this.queryRouter = new QueryRouter();
        this.mManager = MManager.getInstance();
        try {
            this.authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    @Override
    public QueryDataSet processQuery(PhysicalPlan queryPlan, QueryContext context) throws IOException, StorageEngineException, QueryFilterOptimizationException, QueryProcessException, MetadataException {
        if (queryPlan instanceof QueryPlan) {
            return this.processDataQuery((QueryPlan)queryPlan, context);
        }
        if (queryPlan instanceof AuthorPlan) {
            return this.processAuthorQuery((AuthorPlan)queryPlan);
        }
        if (queryPlan instanceof ShowPlan) {
            return this.processShowQuery((ShowPlan)queryPlan);
        }
        throw new QueryProcessException(String.format("Unrecognized query plan %s", queryPlan));
    }

    @Override
    public boolean processNonQuery(PhysicalPlan plan) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        switch (plan.getOperatorType()) {
            case DELETE: {
                this.delete((DeletePlan)plan);
                return true;
            }
            case UPDATE: {
                UpdatePlan update = (UpdatePlan)plan;
                for (Pair<Long, Long> timePair : update.getIntervals()) {
                    this.update(update.getPath(), (Long)timePair.left, (Long)timePair.right, update.getValue());
                }
                return true;
            }
            case INSERT: {
                this.insert((InsertPlan)plan);
                return true;
            }
            case CREATE_ROLE: 
            case DELETE_ROLE: 
            case CREATE_USER: 
            case REVOKE_USER_ROLE: 
            case REVOKE_ROLE_PRIVILEGE: 
            case REVOKE_USER_PRIVILEGE: 
            case GRANT_ROLE_PRIVILEGE: 
            case GRANT_USER_PRIVILEGE: 
            case GRANT_USER_ROLE: 
            case MODIFY_PASSWORD: 
            case DELETE_USER: {
                AuthorPlan author = (AuthorPlan)plan;
                return this.operateAuthor(author);
            }
            case GRANT_WATERMARK_EMBEDDING: {
                return this.operateWatermarkEmbedding(((DataAuthPlan)plan).getUsers(), true);
            }
            case REVOKE_WATERMARK_EMBEDDING: {
                return this.operateWatermarkEmbedding(((DataAuthPlan)plan).getUsers(), false);
            }
            case DELETE_TIMESERIES: {
                return this.deleteTimeSeries((DeleteTimeSeriesPlan)plan);
            }
            case CREATE_TIMESERIES: {
                return this.createTimeSeries((CreateTimeSeriesPlan)plan);
            }
            case ALTER_TIMESERIES: {
                return this.alterTimeSeries((AlterTimeSeriesPlan)plan);
            }
            case SET_STORAGE_GROUP: {
                return this.setStorageGroup((SetStorageGroupPlan)plan);
            }
            case DELETE_STORAGE_GROUP: {
                return this.deleteStorageGroups((DeleteStorageGroupPlan)plan);
            }
            case TTL: {
                this.operateTTL((SetTTLPlan)plan);
                return true;
            }
            case LOAD_CONFIGURATION: {
                IoTDBDescriptor.getInstance().loadHotModifiedProps();
                return true;
            }
            case LOAD_FILES: {
                this.operateLoadFiles((OperateFilePlan)plan);
                return true;
            }
            case REMOVE_FILE: {
                this.operateRemoveFile((OperateFilePlan)plan);
                return true;
            }
            case MOVE_FILE: {
                this.operateMoveFile((OperateFilePlan)plan);
                return true;
            }
            case FLUSH: {
                this.operateFlush((FlushPlan)plan);
                return true;
            }
            case MERGE: 
            case FULL_MERGE: {
                this.operateMerge((MergePlan)plan);
                return true;
            }
            case CLEAR_CACHE: {
                this.operateClearCache((ClearCachePlan)plan);
                return true;
            }
        }
        throw new UnsupportedOperationException(String.format("operation %s is not supported", new Object[]{plan.getOperatorType()}));
    }

    private void operateMerge(MergePlan plan) throws StorageEngineException {
        if (plan.getOperatorType() == Operator.OperatorType.FULL_MERGE) {
            StorageEngine.getInstance().mergeAll(true);
        } else {
            StorageEngine.getInstance().mergeAll(IoTDBDescriptor.getInstance().getConfig().isForceFullMerge());
        }
    }

    private void operateClearCache(ClearCachePlan plan) {
        ChunkCache.getInstance().clear();
        ChunkMetadataCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        System.gc();
    }

    private void operateFlush(FlushPlan plan) throws StorageGroupNotSetException {
        if (plan.getPaths() == null) {
            StorageEngine.getInstance().syncCloseAllProcessor();
        } else if (plan.isSeq() == null) {
            for (Path storageGroup : plan.getPaths()) {
                StorageEngine.getInstance().asyncCloseProcessor(storageGroup.toString(), true);
                StorageEngine.getInstance().asyncCloseProcessor(storageGroup.toString(), false);
            }
        } else {
            for (Path storageGroup : plan.getPaths()) {
                StorageEngine.getInstance().asyncCloseProcessor(storageGroup.toString(), plan.isSeq());
            }
        }
    }

    protected QueryDataSet processDataQuery(QueryPlan queryPlan, QueryContext context) throws StorageEngineException, QueryFilterOptimizationException, QueryProcessException, IOException, MetadataException {
        AlignByDeviceDataSet queryDataSet;
        if (queryPlan instanceof AlignByDevicePlan) {
            queryDataSet = new AlignByDeviceDataSet((AlignByDevicePlan)queryPlan, context, this.queryRouter);
        } else {
            if (queryPlan.getPaths() == null || queryPlan.getPaths().isEmpty()) {
                return new EmptyDataSet();
            }
            if (queryPlan instanceof GroupByFillPlan) {
                GroupByFillPlan groupByFillPlan = (GroupByFillPlan)queryPlan;
                return this.queryRouter.groupByFill(groupByFillPlan, context);
            }
            if (queryPlan instanceof GroupByPlan) {
                GroupByPlan groupByPlan = (GroupByPlan)queryPlan;
                return this.queryRouter.groupBy(groupByPlan, context);
            }
            if (queryPlan instanceof AggregationPlan) {
                AggregationPlan aggregationPlan = (AggregationPlan)queryPlan;
                queryDataSet = this.queryRouter.aggregate(aggregationPlan, context);
            } else if (queryPlan instanceof FillQueryPlan) {
                FillQueryPlan fillQueryPlan = (FillQueryPlan)queryPlan;
                queryDataSet = this.queryRouter.fill(fillQueryPlan, context);
            } else {
                queryDataSet = queryPlan instanceof LastQueryPlan ? this.queryRouter.lastQuery((LastQueryPlan)queryPlan, context) : this.queryRouter.rawDataQuery((RawDataQueryPlan)queryPlan, context);
            }
        }
        queryDataSet.setRowLimit(queryPlan.getRowLimit());
        queryDataSet.setRowOffset(queryPlan.getRowOffset());
        return queryDataSet;
    }

    private QueryDataSet processShowQuery(ShowPlan showPlan) throws QueryProcessException, MetadataException {
        switch (showPlan.getShowContentType()) {
            case TTL: {
                return this.processShowTTLQuery((ShowTTLPlan)showPlan);
            }
            case DYNAMIC_PARAMETER: {
                return this.processShowDynamicParameterQuery();
            }
            case FLUSH_TASK_INFO: {
                return this.processShowFlushTaskInfo();
            }
            case VERSION: {
                return this.processShowVersion();
            }
            case TIMESERIES: {
                ShowTimeSeriesPlan plan = (ShowTimeSeriesPlan)showPlan;
                if (plan.getKey() != null && plan.getValue() != null) {
                    return this.processShowTimeseriesWithIndex((ShowTimeSeriesPlan)showPlan);
                }
                return this.processShowTimeseries(plan);
            }
            case STORAGE_GROUP: {
                return this.processShowStorageGroup();
            }
            case DEVICES: {
                return this.processShowDevices((ShowDevicesPlan)showPlan);
            }
            case CHILD_PATH: {
                return this.processShowChildPaths((ShowChildPathsPlan)showPlan);
            }
            case COUNT_TIMESERIES: {
                return this.processCountTimeSeries((CountPlan)showPlan);
            }
            case COUNT_NODE_TIMESERIES: {
                return this.processCountNodeTimeSeries((CountPlan)showPlan);
            }
            case COUNT_NODES: {
                return this.processCountNodes((CountPlan)showPlan);
            }
        }
        throw new QueryProcessException(String.format("Unrecognized show plan %s", showPlan));
    }

    private QueryDataSet processCountNodes(CountPlan countPlan) throws MetadataException {
        int num = this.getNodesNumInGivenLevel(countPlan.getPath().toString(), countPlan.getLevel());
        SingleDataSet singleDataSet = new SingleDataSet(Collections.singletonList(new Path("count")), Collections.singletonList(TSDataType.INT32));
        Field field = new Field(TSDataType.INT32);
        field.setIntV(num);
        RowRecord record = new RowRecord(0L);
        record.addField(field);
        singleDataSet.setRecord(record);
        return singleDataSet;
    }

    private QueryDataSet processCountNodeTimeSeries(CountPlan countPlan) throws MetadataException {
        List<String> nodes = this.getNodesList(countPlan.getPath().toString(), countPlan.getLevel());
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new Path("column"), new Path("count")), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT));
        for (String columnPath : nodes) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(columnPath));
            Field field1 = new Field(TSDataType.TEXT);
            field1.setBinaryV(new Binary(Integer.toString(this.getPathsNum(columnPath))));
            record.addField(field);
            record.addField(field1);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    protected int getPathsNum(String path) throws MetadataException {
        return MManager.getInstance().getAllTimeseriesCount(path);
    }

    protected int getNodesNumInGivenLevel(String path, int level) throws MetadataException {
        return MManager.getInstance().getNodesCountInGivenLevel(path, level);
    }

    protected List<String> getPathsName(String path) throws MetadataException {
        return MManager.getInstance().getAllTimeseriesName(path);
    }

    protected List<String> getNodesList(String schemaPattern, int level) throws MetadataException {
        return MManager.getInstance().getNodesList(schemaPattern, level);
    }

    private QueryDataSet processCountTimeSeries(CountPlan countPlan) throws MetadataException {
        int num = this.getPathsNum(countPlan.getPath().toString());
        SingleDataSet singleDataSet = new SingleDataSet(Collections.singletonList(new Path("child paths")), Collections.singletonList(TSDataType.INT32));
        Field field = new Field(TSDataType.INT32);
        field.setIntV(num);
        RowRecord record = new RowRecord(0L);
        record.addField(field);
        singleDataSet.setRecord(record);
        return singleDataSet;
    }

    private QueryDataSet processShowDevices(ShowDevicesPlan showDevicesPlan) throws MetadataException {
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new Path("devices")), Collections.singletonList(TSDataType.TEXT));
        Set<String> devices = this.getDevices(showDevicesPlan.getPath().toString());
        for (String s : devices) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(s));
            record.addField(field);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    protected Set<String> getDevices(String path) throws MetadataException {
        return MManager.getInstance().getDevices(path);
    }

    private QueryDataSet processShowChildPaths(ShowChildPathsPlan showChildPathsPlan) throws MetadataException {
        Set<String> childPathsList = this.getPathNextChildren(showChildPathsPlan.getPath().toString());
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new Path("child paths")), Collections.singletonList(TSDataType.TEXT));
        for (String s : childPathsList) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(s));
            record.addField(field);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    protected Set<String> getPathNextChildren(String path) throws MetadataException {
        return MManager.getInstance().getChildNodePathInNextLevel(path);
    }

    private QueryDataSet processShowStorageGroup() {
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new Path("storage group")), Collections.singletonList(TSDataType.TEXT));
        List<String> storageGroupList = MManager.getInstance().getAllStorageGroupNames();
        for (String s : storageGroupList) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(s));
            record.addField(field);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    private QueryDataSet processShowTimeseriesWithIndex(ShowTimeSeriesPlan showTimeSeriesPlan) throws MetadataException {
        List<ShowTimeSeriesResult> timeseriesList = this.mManager.getAllTimeseriesSchema(showTimeSeriesPlan);
        return this.getQueryDataSet(timeseriesList);
    }

    private QueryDataSet processShowTimeseries(ShowTimeSeriesPlan showTimeSeriesPlan) throws MetadataException {
        List<ShowTimeSeriesResult> timeseriesList = this.mManager.showTimeseries(showTimeSeriesPlan);
        return this.getQueryDataSet(timeseriesList);
    }

    private QueryDataSet getQueryDataSet(List<ShowTimeSeriesResult> timeseriesList) {
        ArrayList<Path> paths = new ArrayList<Path>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        paths.add(new Path("timeseries"));
        dataTypes.add(TSDataType.TEXT);
        paths.add(new Path("alias"));
        dataTypes.add(TSDataType.TEXT);
        paths.add(new Path("storage group"));
        dataTypes.add(TSDataType.TEXT);
        paths.add(new Path("dataType"));
        dataTypes.add(TSDataType.TEXT);
        paths.add(new Path("encoding"));
        dataTypes.add(TSDataType.TEXT);
        paths.add(new Path("compression"));
        dataTypes.add(TSDataType.TEXT);
        TreeSet<String> tagAndAttributeName = new TreeSet<String>();
        for (ShowTimeSeriesResult result : timeseriesList) {
            tagAndAttributeName.addAll(result.getTagAndAttribute().keySet());
        }
        for (String key : tagAndAttributeName) {
            paths.add(new Path(key));
            dataTypes.add(TSDataType.TEXT);
        }
        ListDataSet listDataSet = new ListDataSet(paths, dataTypes);
        for (ShowTimeSeriesResult result : timeseriesList) {
            RowRecord record = new RowRecord(0L);
            this.updateRecord(record, result.getName());
            this.updateRecord(record, result.getAlias());
            this.updateRecord(record, result.getSgName());
            this.updateRecord(record, result.getDataType());
            this.updateRecord(record, result.getEncoding());
            this.updateRecord(record, result.getCompressor());
            this.updateRecord(record, result.getTagAndAttribute(), paths);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    private void updateRecord(RowRecord record, Map<String, String> tagAndAttribute, List<Path> paths) {
        for (int i = 6; i < paths.size(); ++i) {
            this.updateRecord(record, tagAndAttribute.get(paths.get(i).getFullPath()));
        }
    }

    private void updateRecord(RowRecord record, String s) {
        if (s == null) {
            record.addField(null);
            return;
        }
        Field field = new Field(TSDataType.TEXT);
        field.setBinaryV(new Binary(s));
        record.addField(field);
    }

    private QueryDataSet processShowTTLQuery(ShowTTLPlan showTTLPlan) {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new Path("storage group"), new Path("ttl")), Arrays.asList(TSDataType.TEXT, TSDataType.INT64));
        List<String> selectedSgs = showTTLPlan.getStorageGroups();
        List<StorageGroupMNode> storageGroups = MManager.getInstance().getAllStorageGroupNodes();
        int timestamp = 0;
        for (StorageGroupMNode mNode : storageGroups) {
            Field ttl;
            String sgName = mNode.getFullPath();
            if (!selectedSgs.isEmpty() && !selectedSgs.contains(sgName)) continue;
            RowRecord rowRecord = new RowRecord((long)timestamp++);
            Field sg = new Field(TSDataType.TEXT);
            sg.setBinaryV(new Binary(sgName));
            if (mNode.getDataTTL() != Long.MAX_VALUE) {
                ttl = new Field(TSDataType.INT64);
                ttl.setLongV(mNode.getDataTTL());
            } else {
                ttl = null;
            }
            rowRecord.addField(sg);
            rowRecord.addField(ttl);
            listDataSet.putRecord(rowRecord);
        }
        return listDataSet;
    }

    private QueryDataSet processShowVersion() {
        SingleDataSet singleDataSet = new SingleDataSet(Collections.singletonList(new Path("        version")), Collections.singletonList(TSDataType.TEXT));
        Field field = new Field(TSDataType.TEXT);
        field.setBinaryV(new Binary(IoTDBConstant.VERSION));
        RowRecord rowRecord = new RowRecord(0L);
        rowRecord.addField(field);
        singleDataSet.setRecord(rowRecord);
        return singleDataSet;
    }

    private QueryDataSet processShowDynamicParameterQuery() {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new Path("                                          parameter"), new Path("value")), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT));
        int timestamp = 0;
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "memtable size threshold", IoTDBDescriptor.getInstance().getConfig().getMemtableSizeThreshold() + "B");
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "memtable number", IoTDBDescriptor.getInstance().getConfig().getMaxMemtableNumber() + "B");
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "tsfile size threshold", IoTDBDescriptor.getInstance().getConfig().getTsFileSizeThreshold() + "B");
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "compression ratio", Double.toString(CompressionRatio.getInstance().getRatio()));
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "storage group number", Integer.toString(MManager.getInstance().getAllStorageGroupNames().size()));
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "timeseries number", Integer.toString(IoTDBConfigDynamicAdapter.getInstance().getTotalTimeseries()));
        this.addRowRecordForShowQuery(listDataSet, timestamp, "maximal timeseries number among storage groups", Long.toString(MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups()));
        return listDataSet;
    }

    private QueryDataSet processShowFlushTaskInfo() {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new Path("                             item"), new Path("value")), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT));
        int timestamp = 0;
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "total number of flush tasks", Integer.toString(FlushTaskPoolManager.getInstance().getTotalTasks()));
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "number of working flush tasks", Integer.toString(FlushTaskPoolManager.getInstance().getWorkingTasksNumber()));
        this.addRowRecordForShowQuery(listDataSet, timestamp, "number of waiting flush tasks", Integer.toString(FlushTaskPoolManager.getInstance().getWaitingTasksNumber()));
        return listDataSet;
    }

    private void addRowRecordForShowQuery(ListDataSet listDataSet, int timestamp, String item, String value) {
        RowRecord rowRecord = new RowRecord((long)timestamp);
        Field itemField = new Field(TSDataType.TEXT);
        itemField.setBinaryV(new Binary(item));
        Field valueField = new Field(TSDataType.TEXT);
        valueField.setBinaryV(new Binary(value));
        rowRecord.addField(itemField);
        rowRecord.addField(valueField);
        listDataSet.putRecord(rowRecord);
    }

    @Override
    public void delete(DeletePlan deletePlan) throws QueryProcessException {
        try {
            HashSet<String> existingPaths = new HashSet<String>();
            for (Path p : deletePlan.getPaths()) {
                existingPaths.addAll(this.getPathsName(p.getFullPath()));
            }
            if (existingPaths.isEmpty()) {
                throw new QueryProcessException("TimeSeries does not exist and its data cannot be deleted");
            }
            for (String path : existingPaths) {
                this.delete(new Path(path), deletePlan.getDeleteTime());
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
    }

    private void operateLoadFiles(OperateFilePlan plan) throws QueryProcessException {
        File file = plan.getFile();
        if (!file.exists()) {
            throw new QueryProcessException(String.format("File path %s doesn't exists.", file.getPath()));
        }
        if (file.isDirectory()) {
            this.recursionFileDir(file, plan);
        } else {
            this.loadFile(file, plan);
        }
    }

    private void recursionFileDir(File curFile, OperateFilePlan plan) throws QueryProcessException {
        File[] files;
        for (File file : files = curFile.listFiles()) {
            if (file.isDirectory()) {
                this.recursionFileDir(file, plan);
                continue;
            }
            this.loadFile(file, plan);
        }
    }

    private void loadFile(File file, OperateFilePlan plan) throws QueryProcessException {
        if (!file.getName().endsWith(".tsfile")) {
            return;
        }
        TsFileResource tsFileResource = new TsFileResource(file);
        tsFileResource.setClosed(true);
        try {
            RestorableTsFileIOWriter restorableTsFileIOWriter = new RestorableTsFileIOWriter(file);
            if (restorableTsFileIOWriter.hasCrashed()) {
                restorableTsFileIOWriter.close();
                throw new QueryProcessException(String.format("Cannot load file %s because the file has crashed.", file.getAbsolutePath()));
            }
            HashMap<Path, MeasurementSchema> schemaMap = new HashMap<Path, MeasurementSchema>();
            ArrayList versionInfo = new ArrayList();
            ArrayList<ChunkGroupMetadata> chunkGroupMetadataList = new ArrayList<ChunkGroupMetadata>();
            try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), false);){
                reader.selfCheck(schemaMap, chunkGroupMetadataList, versionInfo, false);
            }
            FileLoaderUtils.checkTsFileResource(tsFileResource);
            if (UpgradeUtils.isNeedUpgrade(tsFileResource)) {
                throw new QueryProcessException(String.format("Cannot load file %s because the file's version is old which needs to be upgraded.", file.getAbsolutePath()));
            }
            if (plan.isAutoCreateSchema()) {
                this.createSchemaAutomatically(chunkGroupMetadataList, schemaMap, plan.getSgLevel());
            }
            StorageEngine.getInstance().loadNewTsFile(tsFileResource);
        }
        catch (Exception e) {
            throw new QueryProcessException(String.format("Cannot load file %s because %s", file.getAbsolutePath(), e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSchemaAutomatically(List<ChunkGroupMetadata> chunkGroupMetadataList, Map<Path, MeasurementSchema> knownSchemas, int sgLevel) throws QueryProcessException, MetadataException {
        if (chunkGroupMetadataList.isEmpty()) {
            return;
        }
        HashSet<Path> registeredSeries = new HashSet<Path>();
        for (ChunkGroupMetadata chunkGroupMetadata : chunkGroupMetadataList) {
            String device = chunkGroupMetadata.getDevice();
            MNode node = null;
            try {
                node = this.mManager.getDeviceNodeWithAutoCreateAndReadLock(device, true, sgLevel);
                for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                    Path series = new Path(chunkGroupMetadata.getDevice(), chunkMetadata.getMeasurementUid());
                    if (registeredSeries.contains(series)) continue;
                    registeredSeries.add(series);
                    MeasurementSchema schema = knownSchemas.get(series);
                    if (schema == null) {
                        throw new MetadataException(String.format("Can not get the schema of measurement [%s]", chunkMetadata.getMeasurementUid()));
                    }
                    if (!node.hasChild(chunkMetadata.getMeasurementUid())) {
                        this.mManager.createTimeseries(series.getFullPath(), schema.getType(), schema.getEncodingType(), schema.getCompressor(), Collections.emptyMap());
                        continue;
                    }
                    if (!(node.getChild(chunkMetadata.getMeasurementUid()) instanceof InternalMNode)) continue;
                    throw new QueryProcessException(String.format("Current Path is not leaf node. %s", series));
                }
            }
            finally {
                if (node == null) continue;
                ((InternalMNode)node).readUnlock();
            }
        }
    }

    private void operateRemoveFile(OperateFilePlan plan) throws QueryProcessException {
        try {
            if (!StorageEngine.getInstance().deleteTsfile(plan.getFile())) {
                throw new QueryProcessException(String.format("File %s doesn't exist.", plan.getFile().getName()));
            }
        }
        catch (StorageEngineException e) {
            throw new QueryProcessException(String.format("Cannot remove file because %s", e.getMessage()));
        }
    }

    private void operateMoveFile(OperateFilePlan plan) throws QueryProcessException {
        if (!plan.getTargetDir().exists() || !plan.getTargetDir().isDirectory()) {
            throw new QueryProcessException(String.format("Target dir %s is invalid.", plan.getTargetDir().getPath()));
        }
        try {
            if (!StorageEngine.getInstance().moveTsfile(plan.getFile(), plan.getTargetDir())) {
                throw new QueryProcessException(String.format("File %s doesn't exist.", plan.getFile().getName()));
            }
        }
        catch (IOException | StorageEngineException e) {
            throw new QueryProcessException(String.format("Cannot move file %s to target directory %s because %s", plan.getFile().getPath(), plan.getTargetDir().getPath(), e.getMessage()));
        }
    }

    private void operateTTL(SetTTLPlan plan) throws QueryProcessException {
        try {
            MManager.getInstance().setTTL(plan.getStorageGroup(), plan.getDataTTL());
            StorageEngine.getInstance().setTTL(plan.getStorageGroup(), plan.getDataTTL());
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
        catch (IOException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    @Override
    public void update(Path path, long startTime, long endTime, String value) {
        throw new UnsupportedOperationException("update is not supported now");
    }

    @Override
    public void delete(Path path, long timestamp) throws QueryProcessException {
        String deviceId = path.getDevice();
        String measurementId = path.getMeasurement();
        try {
            if (!this.mManager.isPathExist(path.getFullPath())) {
                throw new QueryProcessException(String.format("Time series %s does not exist.", path.getFullPath()));
            }
            this.mManager.getStorageGroupName(path.getFullPath());
            StorageEngine.getInstance().delete(deviceId, measurementId, timestamp);
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
    }

    @Override
    public void insert(InsertPlan insertPlan) throws QueryProcessException {
        MNode node = null;
        try {
            String[] measurementList = insertPlan.getMeasurements();
            String deviceId = insertPlan.getDeviceId();
            node = this.mManager.getDeviceNodeWithAutoCreateAndReadLock(deviceId);
            MeasurementSchema[] schemas = new MeasurementSchema[measurementList.length];
            for (int i = 0; i < measurementList.length; ++i) {
                String measurement = measurementList[i];
                try {
                    if (!node.hasChild(measurement)) {
                        if (!IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled()) {
                            throw new PathNotExistException(deviceId + "." + measurement);
                        }
                        TSDataType dataType = TypeInferenceUtils.getPredictedDataType(insertPlan.getValues()[i], insertPlan.isInferType());
                        Path path = new Path(deviceId, measurement);
                        this.internalCreateTimeseries(path.toString(), dataType);
                    }
                    LeafMNode measurementNode = (LeafMNode)this.mManager.getChild(node, measurement);
                    schemas[i] = measurementNode.getSchema();
                    measurementList[i] = measurementNode.getName();
                    if (insertPlan.isInferType()) continue;
                    this.checkType(insertPlan, i, measurementNode.getSchema().getType());
                    continue;
                }
                catch (MetadataException e) {
                    logger.warn("meet error when check {}.{}, message: {}", new Object[]{deviceId, measurement, e.getMessage()});
                    if (this.enablePartialInsert) {
                        insertPlan.markMeasurementInsertionFailed(i);
                        continue;
                    }
                    throw e;
                }
            }
            insertPlan.setMeasurements(measurementList);
            insertPlan.setSchemasAndTransferType(schemas);
            StorageEngine.getInstance().insert(insertPlan);
            if (insertPlan.getFailedMeasurements() != null) {
                throw new StorageEngineException("failed to insert points " + insertPlan.getFailedMeasurements());
            }
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
        finally {
            if (node != null) {
                ((InternalMNode)node).readUnlock();
            }
        }
    }

    private void checkType(InsertPlan plan, int loc, TSDataType type) {
        plan.getTypes()[loc] = type;
        try {
            switch (type) {
                case INT32: {
                    if (plan.getValues()[loc] instanceof Integer) break;
                    plan.getValues()[loc] = Integer.parseInt(((Binary)plan.getValues()[loc]).getStringValue());
                    break;
                }
                case INT64: {
                    if (plan.getValues()[loc] instanceof Long) break;
                    plan.getValues()[loc] = Long.parseLong(((Binary)plan.getValues()[loc]).getStringValue());
                    break;
                }
                case DOUBLE: {
                    if (plan.getValues()[loc] instanceof Double) break;
                    plan.getValues()[loc] = Double.parseDouble(((Binary)plan.getValues()[loc]).getStringValue());
                    break;
                }
                case FLOAT: {
                    if (plan.getValues()[loc] instanceof Float) break;
                    plan.getValues()[loc] = Float.valueOf(Float.parseFloat(((Binary)plan.getValues()[loc]).getStringValue()));
                    break;
                }
                case BOOLEAN: {
                    if (plan.getValues()[loc] instanceof Boolean) break;
                    plan.getValues()[loc] = Boolean.parseBoolean(((Binary)plan.getValues()[loc]).getStringValue());
                    break;
                }
            }
        }
        catch (ClassCastException e) {
            logger.error("inconsistent type between client and server");
        }
    }

    private void internalCreateTimeseries(String path, TSDataType dataType) throws MetadataException {
        block2: {
            try {
                this.mManager.createTimeseries(path, dataType, this.getDefaultEncoding(dataType), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
            catch (PathAlreadyExistException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Ignore PathAlreadyExistException when Concurrent inserting a non-exist time series {}", (Object)path);
            }
        }
    }

    private TSEncoding getDefaultEncoding(TSDataType dataType) {
        IoTDBConfig conf = IoTDBDescriptor.getInstance().getConfig();
        switch (dataType) {
            case BOOLEAN: {
                return conf.getDefaultBooleanEncoding();
            }
            case INT32: {
                return conf.getDefaultInt32Encoding();
            }
            case INT64: {
                return conf.getDefaultInt64Encoding();
            }
            case FLOAT: {
                return conf.getDefaultFloatEncoding();
            }
            case DOUBLE: {
                return conf.getDefaultDoubleEncoding();
            }
            case TEXT: {
                return conf.getDefaultTextEncoding();
            }
        }
        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType.toString()));
    }

    @Override
    public TSStatus[] insertTablet(InsertTabletPlan insertTabletPlan) throws QueryProcessException {
        MNode node = null;
        try {
            String[] measurementList = insertTabletPlan.getMeasurements();
            String deviceId = insertTabletPlan.getDeviceId();
            node = this.mManager.getDeviceNodeWithAutoCreateAndReadLock(deviceId);
            TSDataType[] dataTypes = insertTabletPlan.getDataTypes();
            IoTDBConfig conf = IoTDBDescriptor.getInstance().getConfig();
            MeasurementSchema[] schemas = new MeasurementSchema[measurementList.length];
            for (int i = 0; i < measurementList.length; ++i) {
                LeafMNode measurementNode;
                String measurement = measurementList[i];
                if (!node.hasChild(measurement)) {
                    if (!conf.isAutoCreateSchemaEnabled()) {
                        throw new QueryProcessException(String.format("Current deviceId[%s] does not contain measurement:%s", deviceId, measurement));
                    }
                    Path path = new Path(deviceId, measurement);
                    TSDataType dataType = dataTypes[i];
                    this.internalCreateTimeseries(path.getFullPath(), dataType);
                }
                if ((measurementNode = (LeafMNode)this.mManager.getChild(node, measurement)).getSchema().getType() != insertTabletPlan.getDataTypes()[i]) {
                    throw new QueryProcessException(String.format("Datatype mismatch, Insert measurement %s type %s, metadata tree type %s", measurement, insertTabletPlan.getDataTypes()[i], measurementNode.getSchema().getType()));
                }
                schemas[i] = measurementNode.getSchema();
                measurementList[i] = measurementNode.getName();
            }
            insertTabletPlan.setSchemas(schemas);
            TSStatus[] tSStatusArray = StorageEngine.getInstance().insertTablet(insertTabletPlan);
            return tSStatusArray;
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
        finally {
            if (node != null) {
                ((InternalMNode)node).readUnlock();
            }
        }
    }

    private boolean operateAuthor(AuthorPlan author) throws QueryProcessException {
        AuthorOperator.AuthorType authorType = author.getAuthorType();
        String userName = author.getUserName();
        String roleName = author.getRoleName();
        String password = author.getPassword();
        String newPassword = author.getNewPassword();
        Set<Integer> permissions = author.getPermissions();
        Path nodeName = author.getNodeName();
        try {
            switch (authorType) {
                case UPDATE_USER: {
                    this.authorizer.updateUserPassword(userName, newPassword);
                    break;
                }
                case CREATE_USER: {
                    this.authorizer.createUser(userName, password);
                    break;
                }
                case CREATE_ROLE: {
                    this.authorizer.createRole(roleName);
                    break;
                }
                case DROP_USER: {
                    this.authorizer.deleteUser(userName);
                    break;
                }
                case DROP_ROLE: {
                    this.authorizer.deleteRole(roleName);
                    break;
                }
                case GRANT_ROLE: {
                    for (int i : permissions) {
                        this.authorizer.grantPrivilegeToRole(roleName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case GRANT_USER: {
                    for (int i : permissions) {
                        this.authorizer.grantPrivilegeToUser(userName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case GRANT_ROLE_TO_USER: {
                    this.authorizer.grantRoleToUser(roleName, userName);
                    break;
                }
                case REVOKE_USER: {
                    for (int i : permissions) {
                        this.authorizer.revokePrivilegeFromUser(userName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case REVOKE_ROLE: {
                    for (int i : permissions) {
                        this.authorizer.revokePrivilegeFromRole(roleName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case REVOKE_ROLE_FROM_USER: {
                    this.authorizer.revokeRoleFromUser(roleName, userName);
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported operation " + (Object)((Object)authorType));
                }
            }
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
        return true;
    }

    private boolean operateWatermarkEmbedding(List<String> users, boolean useWatermark) throws QueryProcessException {
        try {
            for (String user : users) {
                this.authorizer.setUserUseWaterMark(user, useWatermark);
            }
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
        return true;
    }

    private boolean createTimeSeries(CreateTimeSeriesPlan createTimeSeriesPlan) throws QueryProcessException {
        try {
            this.mManager.createTimeseries(createTimeSeriesPlan);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean deleteTimeSeries(DeleteTimeSeriesPlan deleteTimeSeriesPlan) throws QueryProcessException {
        List<Path> deletePathList = deleteTimeSeriesPlan.getPaths();
        try {
            this.deleteDataOfTimeSeries(deletePathList);
            LinkedList<String> failedNames = new LinkedList<String>();
            for (Path path : deletePathList) {
                String failedTimeseries = this.mManager.deleteTimeseries(path.toString());
                if (failedTimeseries.isEmpty()) continue;
                failedNames.add(failedTimeseries);
            }
            if (!failedNames.isEmpty()) {
                throw new DeleteFailedException(String.join((CharSequence)",", failedNames));
            }
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean alterTimeSeries(AlterTimeSeriesPlan alterTimeSeriesPlan) throws QueryProcessException {
        Path path = alterTimeSeriesPlan.getPath();
        Map<String, String> alterMap = alterTimeSeriesPlan.getAlterMap();
        try {
            switch (alterTimeSeriesPlan.getAlterType()) {
                case RENAME: {
                    String beforeName = alterMap.keySet().iterator().next();
                    String currentName = alterMap.get(beforeName);
                    this.mManager.renameTagOrAttributeKey(beforeName, currentName, path.getFullPath());
                    break;
                }
                case SET: {
                    this.mManager.setTagsOrAttributesValue(alterMap, path.getFullPath());
                    break;
                }
                case DROP: {
                    this.mManager.dropTagsOrAttributes(alterMap.keySet(), path.getFullPath());
                    break;
                }
                case ADD_TAGS: {
                    this.mManager.addTags(alterMap, path.getFullPath());
                    break;
                }
                case ADD_ATTRIBUTES: {
                    this.mManager.addAttributes(alterMap, path.getFullPath());
                    break;
                }
                case UPSERT: {
                    this.mManager.upsertTagsAndAttributes(alterTimeSeriesPlan.getAlias(), alterTimeSeriesPlan.getTagsMap(), alterTimeSeriesPlan.getAttributesMap(), path.getFullPath());
                }
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        catch (IOException e) {
            throw new QueryProcessException(String.format("Something went wrong while read/write the [%s]'s tag/attribute info.", path.getFullPath()));
        }
        return true;
    }

    public boolean setStorageGroup(SetStorageGroupPlan setStorageGroupPlan) throws QueryProcessException {
        Path path = setStorageGroupPlan.getPath();
        try {
            this.mManager.setStorageGroup(path.getFullPath());
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean deleteStorageGroups(DeleteStorageGroupPlan deleteStorageGroupPlan) throws QueryProcessException {
        ArrayList<String> deletePathList = new ArrayList<String>();
        try {
            for (Path storageGroupPath : deleteStorageGroupPlan.getPaths()) {
                StorageEngine.getInstance().deleteStorageGroup(storageGroupPath.getFullPath());
                deletePathList.add(storageGroupPath.getFullPath());
            }
            this.mManager.deleteStorageGroups(deletePathList);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private void deleteDataOfTimeSeries(List<Path> pathList) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        for (Path p : pathList) {
            DeletePlan deletePlan = new DeletePlan();
            deletePlan.addPath(p);
            deletePlan.setDeleteTime(Long.MAX_VALUE);
            this.processNonQuery(deletePlan);
        }
    }

    private QueryDataSet processAuthorQuery(AuthorPlan plan) throws QueryProcessException {
        ListDataSet dataSet;
        AuthorOperator.AuthorType authorType = plan.getAuthorType();
        String userName = plan.getUserName();
        String roleName = plan.getRoleName();
        Path path = plan.getNodeName();
        try {
            switch (authorType) {
                case LIST_ROLE: {
                    dataSet = this.executeListRole();
                    break;
                }
                case LIST_USER: {
                    dataSet = this.executeListUser();
                    break;
                }
                case LIST_ROLE_USERS: {
                    dataSet = this.executeListRoleUsers(roleName);
                    break;
                }
                case LIST_USER_ROLES: {
                    dataSet = this.executeListUserRoles(userName);
                    break;
                }
                case LIST_ROLE_PRIVILEGE: {
                    dataSet = this.executeListRolePrivileges(roleName, path);
                    break;
                }
                case LIST_USER_PRIVILEGE: {
                    dataSet = this.executeListUserPrivileges(userName, path);
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported operation " + (Object)((Object)authorType));
                }
            }
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
        return dataSet;
    }

    private ListDataSet executeListRole() {
        int index = 0;
        ArrayList<Path> headerList = new ArrayList<Path>();
        ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
        headerList.add(new Path("role"));
        typeList.add(TSDataType.TEXT);
        ListDataSet dataSet = new ListDataSet(headerList, typeList);
        List<String> roleList = this.authorizer.listAllRoles();
        for (String role : roleList) {
            RowRecord record = new RowRecord((long)index++);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(role));
            record.addField(field);
            dataSet.putRecord(record);
        }
        return dataSet;
    }

    private ListDataSet executeListUser() {
        List<String> userList = this.authorizer.listAllUsers();
        ArrayList<Path> headerList = new ArrayList<Path>();
        ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
        headerList.add(new Path("user"));
        typeList.add(TSDataType.TEXT);
        int index = 0;
        ListDataSet dataSet = new ListDataSet(headerList, typeList);
        for (String user : userList) {
            RowRecord record = new RowRecord((long)index++);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(user));
            record.addField(field);
            dataSet.putRecord(record);
        }
        return dataSet;
    }

    private ListDataSet executeListRoleUsers(String roleName) throws AuthException {
        Role role = this.authorizer.getRole(roleName);
        if (role == null) {
            throw new AuthException("No such role : " + roleName);
        }
        ArrayList<Path> headerList = new ArrayList<Path>();
        ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
        headerList.add(new Path("user"));
        typeList.add(TSDataType.TEXT);
        ListDataSet dataSet = new ListDataSet(headerList, typeList);
        List<String> userList = this.authorizer.listAllUsers();
        int index = 0;
        for (String userN : userList) {
            User userObj = this.authorizer.getUser(userN);
            if (userObj == null || !userObj.hasRole(roleName)) continue;
            RowRecord record = new RowRecord((long)index++);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(userN));
            record.addField(field);
            dataSet.putRecord(record);
        }
        return dataSet;
    }

    private ListDataSet executeListUserRoles(String userName) throws AuthException {
        User user = this.authorizer.getUser(userName);
        if (user != null) {
            ArrayList<Path> headerList = new ArrayList<Path>();
            ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
            headerList.add(new Path("role"));
            typeList.add(TSDataType.TEXT);
            ListDataSet dataSet = new ListDataSet(headerList, typeList);
            int index = 0;
            for (String roleN : user.getRoleList()) {
                RowRecord record = new RowRecord((long)index++);
                Field field = new Field(TSDataType.TEXT);
                field.setBinaryV(new Binary(roleN));
                record.addField(field);
                dataSet.putRecord(record);
            }
            return dataSet;
        }
        throw new AuthException("No such user : " + userName);
    }

    private ListDataSet executeListRolePrivileges(String roleName, Path path) throws AuthException {
        Role role = this.authorizer.getRole(roleName);
        if (role != null) {
            ArrayList<Path> headerList = new ArrayList<Path>();
            ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
            headerList.add(new Path("privilege"));
            typeList.add(TSDataType.TEXT);
            ListDataSet dataSet = new ListDataSet(headerList, typeList);
            int index = 0;
            for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
                if (path != null && !AuthUtils.pathBelongsTo(path.getFullPath(), pathPrivilege.getPath())) continue;
                RowRecord record = new RowRecord((long)index++);
                Field field = new Field(TSDataType.TEXT);
                field.setBinaryV(new Binary(pathPrivilege.toString()));
                record.addField(field);
                dataSet.putRecord(record);
            }
            return dataSet;
        }
        throw new AuthException("No such role : " + roleName);
    }

    private ListDataSet executeListUserPrivileges(String userName, Path path) throws AuthException {
        User user = this.authorizer.getUser(userName);
        if (user == null) {
            throw new AuthException("No such user : " + userName);
        }
        ArrayList<Path> headerList = new ArrayList<Path>();
        ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
        headerList.add(new Path("role"));
        headerList.add(new Path("privilege"));
        typeList.add(TSDataType.TEXT);
        typeList.add(TSDataType.TEXT);
        ListDataSet dataSet = new ListDataSet(headerList, typeList);
        int index = 0;
        for (PathPrivilege pathPrivilege : user.getPrivilegeList()) {
            if (path != null && !AuthUtils.pathBelongsTo(path.getFullPath(), pathPrivilege.getPath())) continue;
            RowRecord record = new RowRecord((long)index++);
            Field roleF = new Field(TSDataType.TEXT);
            roleF.setBinaryV(new Binary(""));
            record.addField(roleF);
            Field privilegeF = new Field(TSDataType.TEXT);
            privilegeF.setBinaryV(new Binary(pathPrivilege.toString()));
            record.addField(privilegeF);
            dataSet.putRecord(record);
        }
        for (String roleN : user.getRoleList()) {
            Role role = this.authorizer.getRole(roleN);
            if (role == null) continue;
            for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
                if (path != null && !AuthUtils.pathBelongsTo(path.getFullPath(), pathPrivilege.getPath())) continue;
                RowRecord record = new RowRecord((long)index++);
                Field roleF = new Field(TSDataType.TEXT);
                roleF.setBinaryV(new Binary(roleN));
                record.addField(roleF);
                Field privilegeF = new Field(TSDataType.TEXT);
                privilegeF.setBinaryV(new Binary(pathPrivilege.toString()));
                record.addField(privilegeF);
                dataSet.putRecord(record);
            }
        }
        return dataSet;
    }
}

