/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp;

import java.time.ZoneId;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.SFWOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.strategy.ParseDriver;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.qp.strategy.optimizer.ConcatPathOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.DnfFilterOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.MergeSingleFilterOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.RemoveNotOptimizer;
import org.apache.iotdb.tsfile.read.common.Path;

public class Planner {
    protected ParseDriver parseDriver = new ParseDriver();

    public PhysicalPlan parseSQLToPhysicalPlan(String sqlStr) throws QueryProcessException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        return this.parseSQLToPhysicalPlan(sqlStr, config.getZoneID());
    }

    public PhysicalPlan parseSQLToPhysicalPlan(String sqlStr, ZoneId zoneId) throws QueryProcessException {
        Operator operator = this.parseDriver.parse(sqlStr, zoneId);
        operator = this.logicalOptimize(operator);
        PhysicalGenerator physicalGenerator = new PhysicalGenerator();
        return physicalGenerator.transformToPhysicalPlan(operator);
    }

    protected Operator logicalOptimize(Operator operator) throws LogicalOperatorException {
        switch (operator.getType()) {
            case AUTHOR: 
            case METADATA: 
            case SET_STORAGE_GROUP: 
            case DELETE_STORAGE_GROUP: 
            case CREATE_TIMESERIES: 
            case DELETE_TIMESERIES: 
            case ALTER_TIMESERIES: 
            case LOADDATA: 
            case INSERT: 
            case INDEX: 
            case INDEXQUERY: 
            case GRANT_WATERMARK_EMBEDDING: 
            case REVOKE_WATERMARK_EMBEDDING: 
            case TTL: 
            case LOAD_CONFIGURATION: 
            case SHOW: 
            case LOAD_FILES: 
            case REMOVE_FILE: 
            case MOVE_FILE: 
            case FLUSH: 
            case MERGE: 
            case CLEAR_CACHE: {
                return operator;
            }
            case QUERY: 
            case UPDATE: 
            case DELETE: {
                SFWOperator root = (SFWOperator)operator;
                return this.optimizeSFWOperator(root);
            }
        }
        throw new LogicalOperatorException(operator.getType().toString(), "");
    }

    private SFWOperator optimizeSFWOperator(SFWOperator root) throws LogicalOperatorException {
        ConcatPathOptimizer concatPathOptimizer = this.getConcatPathOptimizer();
        root = (SFWOperator)concatPathOptimizer.transform(root);
        FilterOperator filter = root.getFilterOperator();
        if (filter == null) {
            return root;
        }
        Set<Path> pathSet = filter.getPathSet();
        RemoveNotOptimizer removeNot = new RemoveNotOptimizer();
        filter = removeNot.optimize(filter);
        DnfFilterOptimizer dnf = new DnfFilterOptimizer();
        filter = dnf.optimize(filter);
        MergeSingleFilterOptimizer merge = new MergeSingleFilterOptimizer();
        filter = merge.optimize(filter);
        root.setFilterOperator(filter);
        filter.setPathSet(pathSet);
        return root;
    }

    protected ConcatPathOptimizer getConcatPathOptimizer() {
        return new ConcatPathOptimizer();
    }
}

