/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.monitor.collector;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.monitor.IStatistic;
import org.apache.iotdb.db.monitor.MonitorConstants;
import org.apache.iotdb.db.monitor.StatMonitor;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSize
implements IStatistic {
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger logger = LoggerFactory.getLogger(FileSize.class);
    private static final long ABNORMAL_VALUE = -1L;
    private static final long INIT_VALUE_IF_FILE_NOT_EXIST = 0L;

    @Override
    public Map<String, TSRecord> getAllStatisticsValue() {
        long curTime = System.currentTimeMillis();
        TSRecord tsRecord = StatMonitor.convertToTSRecord(this.getStatParamsHashMap(), "root.stats.file_size", curTime);
        HashMap<String, TSRecord> ret = new HashMap<String, TSRecord>();
        ret.put("root.stats.file_size", tsRecord);
        return ret;
    }

    @Override
    public void registerStatMetadata() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (MonitorConstants.FileSizeConstants kind : MonitorConstants.FileSizeConstants.values()) {
            String seriesPath = "root.stats.file_size." + kind.name();
            hashMap.put(seriesPath, "INT64");
        }
        StatMonitor.getInstance().registerStatStorageGroup(hashMap);
    }

    @Override
    public List<String> getAllPathForStatistic() {
        ArrayList<String> list = new ArrayList<String>();
        for (MonitorConstants.FileSizeConstants kind : MonitorConstants.FileSizeConstants.values()) {
            list.add("root.stats.file_size." + kind.name());
        }
        return list;
    }

    @Override
    public Map<String, AtomicLong> getStatParamsHashMap() {
        Map<MonitorConstants.FileSizeConstants, Long> fileSizeMap = this.getFileSizesInByte();
        HashMap<String, AtomicLong> statParamsMap = new HashMap<String, AtomicLong>();
        for (MonitorConstants.FileSizeConstants kind : MonitorConstants.FileSizeConstants.values()) {
            statParamsMap.put(kind.name(), new AtomicLong(fileSizeMap.get((Object)kind)));
        }
        return statParamsMap;
    }

    private FileSize() {
        if (config.isEnableStatMonitor()) {
            StatMonitor statMonitor = StatMonitor.getInstance();
            this.registerStatMetadata();
            statMonitor.registerStatistics("root.stats.file_size", this);
        }
    }

    public static FileSize getInstance() {
        return FileSizeHolder.INSTANCE;
    }

    public Map<MonitorConstants.FileSizeConstants, Long> getFileSizesInByte() {
        EnumMap<MonitorConstants.FileSizeConstants, Long> fileSizes = new EnumMap<MonitorConstants.FileSizeConstants, Long>(MonitorConstants.FileSizeConstants.class);
        for (MonitorConstants.FileSizeConstants kinds : MonitorConstants.FileSizeConstants.values()) {
            if (kinds.equals((Object)MonitorConstants.FileSizeConstants.SYS)) {
                fileSizes.put(kinds, this.collectSeqFileSize(fileSizes, kinds));
                continue;
            }
            File file = SystemFileFactory.INSTANCE.getFile(kinds.getPath());
            if (file.exists()) {
                try {
                    fileSizes.put(kinds, FileUtils.sizeOfDirectory((File)file));
                }
                catch (Exception e) {
                    logger.error("Meet error while trying to get {} size with dir {} .", new Object[]{kinds, kinds.getPath(), e});
                    fileSizes.put(kinds, -1L);
                }
                continue;
            }
            fileSizes.put(kinds, 0L);
        }
        return fileSizes;
    }

    private long collectSeqFileSize(EnumMap<MonitorConstants.FileSizeConstants, Long> fileSizes, MonitorConstants.FileSizeConstants kinds) {
        long fileSize = 0L;
        for (String sequenceDir : config.getDataDirs()) {
            File settledFile;
            if (sequenceDir.contains("unsequence") || !(settledFile = SystemFileFactory.INSTANCE.getFile(sequenceDir)).exists()) continue;
            try {
                fileSize += FileUtils.sizeOfDirectory((File)settledFile);
            }
            catch (Exception e) {
                logger.error("Meet error while trying to get {} size with dir {} .", new Object[]{kinds, sequenceDir, e});
                fileSizes.put(kinds, -1L);
            }
        }
        return fileSize;
    }

    private static class FileSizeHolder {
        private static final FileSize INSTANCE = new FileSize();

        private FileSizeHolder() {
        }
    }
}

