/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import java.util.Collections;
import java.util.Map;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafMNode
extends MNode {
    private static final Logger logger = LoggerFactory.getLogger(LeafMNode.class);
    private static final long serialVersionUID = -1199657856921206435L;
    private MeasurementSchema schema;
    private String alias;
    private long offset = -1L;
    private TimeValuePair cachedLastValuePair = null;

    public LeafMNode(MNode parent, String measurementName, String alias, TSDataType dataType, TSEncoding encoding, CompressionType type, Map<String, String> props) {
        super(parent, measurementName);
        this.schema = new MeasurementSchema(measurementName, dataType, encoding, type, props);
        this.alias = alias;
    }

    @Override
    public boolean hasChild(String name) {
        return false;
    }

    @Override
    public void addChild(String name, MNode child) {
    }

    @Override
    public void deleteChild(String name) {
    }

    @Override
    public void deleteAliasChild(String alias) {
    }

    @Override
    public MNode getChild(String name) {
        logger.warn("current node {} is a LeafMNode, can not get child {}", (Object)this.name, (Object)name);
        throw new RuntimeException(String.format("current node %s is a LeafMNode, can not get child %s", this.name, name));
    }

    @Override
    public int getLeafCount() {
        return 1;
    }

    @Override
    public void addAlias(String alias, MNode child) {
    }

    @Override
    public Map<String, MNode> getChildren() {
        return Collections.emptyMap();
    }

    public MeasurementSchema getSchema() {
        return this.schema;
    }

    public TimeValuePair getCachedLast() {
        return this.cachedLastValuePair;
    }

    public synchronized void updateCachedLast(TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        if (timeValuePair == null || timeValuePair.getValue() == null) {
            return;
        }
        if (this.cachedLastValuePair == null) {
            if (!highPriorityUpdate || latestFlushedTime <= timeValuePair.getTimestamp()) {
                this.cachedLastValuePair = new TimeValuePair(timeValuePair.getTimestamp(), timeValuePair.getValue());
            }
        } else if (timeValuePair.getTimestamp() > this.cachedLastValuePair.getTimestamp() || timeValuePair.getTimestamp() == this.cachedLastValuePair.getTimestamp() && highPriorityUpdate) {
            this.cachedLastValuePair.setTimestamp(timeValuePair.getTimestamp());
            this.cachedLastValuePair.setValue(timeValuePair.getValue());
        }
    }

    @Override
    public String getFullPath() {
        return this.concatFullPath();
    }

    public void resetCache() {
        this.cachedLastValuePair = null;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

