/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.LeafMNode;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MTree
implements Serializable {
    private static final long serialVersionUID = -4200394435237291964L;
    private MNode root;
    private transient ThreadLocal<Integer> limit = new ThreadLocal();
    private transient ThreadLocal<Integer> offset = new ThreadLocal();
    private transient ThreadLocal<Integer> count = new ThreadLocal();
    private transient ThreadLocal<Integer> curOffset = new ThreadLocal();

    MTree() {
        this.root = new InternalMNode(null, "root");
    }

    LeafMNode createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias) throws MetadataException {
        String[] nodeNames = MetaUtils.getNodeNames(path);
        if (nodeNames.length <= 2 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(path);
        }
        MNode cur = this.root;
        boolean hasSetStorageGroup = false;
        for (int i = 1; i < nodeNames.length - 1; ++i) {
            String nodeName = nodeNames[i];
            if (cur instanceof StorageGroupMNode) {
                hasSetStorageGroup = true;
            }
            if (!cur.hasChild(nodeName)) {
                if (!hasSetStorageGroup) {
                    throw new StorageGroupNotSetException("Storage group should be created first");
                }
                cur.addChild(nodeName, new InternalMNode(cur, nodeName));
            }
            cur = cur.getChild(nodeName);
        }
        if (cur instanceof LeafMNode) {
            throw new PathAlreadyExistException(cur.getFullPath());
        }
        String leafName = nodeNames[nodeNames.length - 1];
        if (cur.hasChild(leafName)) {
            throw new PathAlreadyExistException(path);
        }
        if (alias != null && cur.hasChild(alias)) {
            throw new AliasAlreadyExistException(path, alias);
        }
        LeafMNode leaf = new LeafMNode(cur, leafName, alias, dataType, encoding, compressor, props);
        cur.addChild(leafName, leaf);
        if (alias != null) {
            cur.addAlias(alias, leaf);
        }
        return leaf;
    }

    MNode getDeviceNodeWithAutoCreating(String deviceId, int sgLevel) throws MetadataException {
        String[] nodeNames = MetaUtils.getNodeNames(deviceId);
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(deviceId);
        }
        MNode cur = this.root;
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!cur.hasChild(nodeNames[i])) {
                if (i == sgLevel) {
                    cur.addChild(nodeNames[i], new StorageGroupMNode(cur, nodeNames[i], IoTDBDescriptor.getInstance().getConfig().getDefaultTTL()));
                } else {
                    cur.addChild(nodeNames[i], new InternalMNode(cur, nodeNames[i]));
                }
            }
            cur = cur.getChild(nodeNames[i]);
        }
        return cur;
    }

    boolean isPathExist(String path) {
        String[] nodeNames = MetaUtils.getNodeNames(path);
        MNode cur = this.root;
        if (!nodeNames[0].equals(this.root.getName())) {
            return false;
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            String childName = nodeNames[i];
            if (!cur.hasChild(childName)) {
                return false;
            }
            cur = cur.getChild(childName);
        }
        return true;
    }

    void setStorageGroup(String path) throws MetadataException {
        int i;
        String[] nodeNames = MetaUtils.getNodeNames(path);
        MNode cur = this.root;
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(path);
        }
        for (i = 1; i < nodeNames.length - 1; ++i) {
            MNode temp = cur.getChild(nodeNames[i]);
            if (temp == null) {
                cur.addChild(nodeNames[i], new InternalMNode(cur, nodeNames[i]));
            } else if (temp instanceof StorageGroupMNode) {
                throw new StorageGroupAlreadySetException(temp.getFullPath());
            }
            cur = cur.getChild(nodeNames[i]);
        }
        if (cur.hasChild(nodeNames[i])) {
            throw new StorageGroupAlreadySetException(path);
        }
        StorageGroupMNode storageGroupMNode = new StorageGroupMNode(cur, nodeNames[i], IoTDBDescriptor.getInstance().getConfig().getDefaultTTL());
        cur.addChild(nodeNames[i], storageGroupMNode);
    }

    List<LeafMNode> deleteStorageGroup(String path) throws MetadataException {
        MNode cur = this.getNodeByPath(path);
        if (!(cur instanceof StorageGroupMNode)) {
            throw new StorageGroupNotSetException(path);
        }
        cur.getParent().deleteChild(cur.getName());
        LinkedList<LeafMNode> leafMNodes = new LinkedList<LeafMNode>();
        LinkedList<MNode> queue = new LinkedList<MNode>();
        queue.add(cur);
        while (!queue.isEmpty()) {
            MNode node = (MNode)queue.poll();
            for (MNode child : node.getChildren().values()) {
                if (child instanceof LeafMNode) {
                    leafMNodes.add((LeafMNode)child);
                    continue;
                }
                queue.add(child);
            }
        }
        cur = cur.getParent();
        while (!"root".equals(cur.getName()) && cur.getChildren().size() == 0) {
            cur.getParent().deleteChild(cur.getName());
            cur = cur.getParent();
        }
        return leafMNodes;
    }

    boolean isStorageGroup(String path) {
        int i;
        String[] nodeNames = MetaUtils.getNodeNames(path);
        if (nodeNames.length <= 1 || !nodeNames[0].equals("root")) {
            return false;
        }
        MNode cur = this.root;
        for (i = 1; i < nodeNames.length - 1; ++i) {
            if ((cur = cur.getChild(nodeNames[i])) != null && !(cur instanceof StorageGroupMNode)) continue;
            return false;
        }
        cur = cur.getChild(nodeNames[i]);
        return cur instanceof StorageGroupMNode;
    }

    Pair<String, LeafMNode> deleteTimeseriesAndReturnEmptyStorageGroup(String path) throws MetadataException {
        MNode curNode = this.getNodeByPath(path);
        if (!(curNode instanceof LeafMNode)) {
            throw new PathNotExistException(path);
        }
        String[] nodes = MetaUtils.getNodeNames(path);
        if (nodes.length == 0 || !"root".equals(nodes[0])) {
            throw new IllegalPathException(path);
        }
        curNode.getParent().deleteChild(curNode.getName());
        LeafMNode deletedNode = (LeafMNode)curNode;
        if (deletedNode.getAlias() != null) {
            curNode.getParent().deleteAliasChild(((LeafMNode)curNode).getAlias());
        }
        curNode = curNode.getParent();
        while (!"root".equals(curNode.getName()) && curNode.getChildren().size() == 0) {
            if (curNode instanceof StorageGroupMNode) {
                return new Pair((Object)curNode.getFullPath(), (Object)deletedNode);
            }
            curNode.getParent().deleteChild(curNode.getName());
            curNode = curNode.getParent();
        }
        return new Pair(null, (Object)deletedNode);
    }

    MeasurementSchema getSchema(String path) throws MetadataException {
        LeafMNode node = (LeafMNode)this.getNodeByPath(path);
        return node.getSchema();
    }

    MNode getNodeByPathWithStorageGroupCheck(String path) throws MetadataException {
        boolean storageGroupChecked = false;
        String[] nodes = MetaUtils.getNodeNames(path);
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path);
        }
        MNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                if (!storageGroupChecked) {
                    throw new StorageGroupNotSetException(path);
                }
                throw new PathNotExistException(path);
            }
            if (!((cur = cur.getChild(nodes[i])) instanceof StorageGroupMNode)) continue;
            storageGroupChecked = true;
        }
        if (!storageGroupChecked) {
            throw new StorageGroupNotSetException(path);
        }
        return cur;
    }

    StorageGroupMNode getStorageGroupNode(String path) throws MetadataException {
        MNode node = this.getNodeByPath(path);
        if (node instanceof StorageGroupMNode) {
            return (StorageGroupMNode)node;
        }
        throw new StorageGroupNotSetException(path);
    }

    MNode getDeviceNode(String path) throws MetadataException {
        return this.getNodeByPath(path);
    }

    MNode getNodeByPath(String path) throws MetadataException {
        String[] nodes = MetaUtils.getNodeNames(path);
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path);
        }
        MNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new PathNotExistException(path);
            }
            cur = cur.getChild(nodes[i]);
        }
        return cur;
    }

    List<String> getStorageGroupByPath(String path) throws MetadataException {
        ArrayList<String> storageGroups = new ArrayList<String>();
        String[] nodes = MetaUtils.getNodeNames(path);
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path);
        }
        this.findStorageGroup(this.root, nodes, 1, "", storageGroups);
        return storageGroups;
    }

    private void findStorageGroup(MNode node, String[] nodes, int idx, String parent, List<String> storageGroupNames) {
        if (node instanceof StorageGroupMNode) {
            storageGroupNames.add(node.getFullPath());
            return;
        }
        String nodeReg = MetaUtils.getNodeRegByIdx(idx, nodes);
        if (!"*".equals(nodeReg)) {
            if (node.hasChild(nodeReg)) {
                this.findStorageGroup(node.getChild(nodeReg), nodes, idx + 1, parent + node.getName() + '.', storageGroupNames);
            }
        } else {
            for (MNode child : node.getChildren().values()) {
                this.findStorageGroup(child, nodes, idx + 1, parent + node.getName() + '.', storageGroupNames);
            }
        }
    }

    List<String> getAllStorageGroupNames() {
        ArrayList<String> res = new ArrayList<String>();
        ArrayDeque<MNode> nodeStack = new ArrayDeque<MNode>();
        nodeStack.add(this.root);
        while (!nodeStack.isEmpty()) {
            MNode current = (MNode)nodeStack.pop();
            if (current instanceof StorageGroupMNode) {
                res.add(current.getFullPath());
                continue;
            }
            nodeStack.addAll(current.getChildren().values());
        }
        return res;
    }

    List<StorageGroupMNode> getAllStorageGroupNodes() {
        ArrayList<StorageGroupMNode> ret = new ArrayList<StorageGroupMNode>();
        ArrayDeque<MNode> nodeStack = new ArrayDeque<MNode>();
        nodeStack.add(this.root);
        while (!nodeStack.isEmpty()) {
            MNode current = (MNode)nodeStack.pop();
            if (current instanceof StorageGroupMNode) {
                ret.add((StorageGroupMNode)current);
                continue;
            }
            if (!(current instanceof InternalMNode)) continue;
            nodeStack.addAll(current.getChildren().values());
        }
        return ret;
    }

    String getStorageGroupName(String path) throws MetadataException {
        String[] nodes = MetaUtils.getNodeNames(path);
        MNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if ((cur = cur.getChild(nodes[i])) instanceof StorageGroupMNode) {
                return cur.getFullPath();
            }
            if (cur != null) continue;
            throw new StorageGroupNotSetException(path);
        }
        throw new StorageGroupNotSetException(path);
    }

    boolean checkStorageGroupByPath(String path) {
        String[] nodes = MetaUtils.getNodeNames(path);
        MNode cur = this.root;
        for (int i = 1; i <= nodes.length; ++i) {
            if ((cur = cur.getChild(nodes[i])) == null) {
                return false;
            }
            if (!(cur instanceof StorageGroupMNode)) continue;
            return true;
        }
        return false;
    }

    List<String> getAllTimeseriesName(String prefixPath) throws MetadataException {
        ShowTimeSeriesPlan plan = new ShowTimeSeriesPlan(new Path(prefixPath));
        List<String[]> res = this.getAllMeasurementSchema(plan);
        ArrayList<String> paths = new ArrayList<String>();
        for (String[] p : res) {
            paths.add(p[0]);
        }
        return paths;
    }

    List<Path> getAllTimeseriesPath(String prefixPath) throws MetadataException {
        Path prePath = new Path(prefixPath);
        ShowTimeSeriesPlan plan = new ShowTimeSeriesPlan(prePath);
        List<String[]> res = this.getAllMeasurementSchema(plan);
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String[] p : res) {
            Path path = new Path(p[0]);
            if (prePath.getMeasurement().equals(p[1])) {
                path.setAlias(p[1]);
            }
            paths.add(path);
        }
        return paths;
    }

    int getAllTimeseriesCount(String prefixPath) throws MetadataException {
        String[] nodes = MetaUtils.getNodeNames(prefixPath);
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(prefixPath);
        }
        return this.getCount(this.root, nodes, 1);
    }

    int getNodesCountInGivenLevel(String prefixPath, int level) throws MetadataException {
        String[] nodes = MetaUtils.getNodeNames(prefixPath);
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(prefixPath);
        }
        MNode node = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if (node.getChild(nodes[i]) == null) {
                throw new MetadataException(nodes[i - 1] + " does not have the child node " + nodes[i]);
            }
            node = node.getChild(nodes[i]);
        }
        return this.getCountInGivenLevel(node, level - (nodes.length - 1));
    }

    private int getCount(MNode node, String[] nodes, int idx) throws MetadataException {
        String nodeReg = MetaUtils.getNodeRegByIdx(idx, nodes);
        if (!"*".equals(nodeReg)) {
            if (node.hasChild(nodeReg)) {
                if (node.getChild(nodeReg) instanceof LeafMNode) {
                    return 1;
                }
                return this.getCount(node.getChild(nodeReg), nodes, idx + 1);
            }
            throw new MetadataException(node.getName() + " does not have the child node " + nodeReg);
        }
        int cnt = 0;
        for (MNode child : node.getChildren().values()) {
            if (child instanceof LeafMNode) {
                ++cnt;
                continue;
            }
            cnt += this.getCount(child, nodes, idx + 1);
        }
        return cnt;
    }

    private int getCountInGivenLevel(MNode node, int targetLevel) {
        if (targetLevel == 0) {
            return 1;
        }
        int cnt = 0;
        if (node instanceof InternalMNode) {
            for (MNode child : node.getChildren().values()) {
                cnt += this.getCountInGivenLevel(child, targetLevel - 1);
            }
        }
        return cnt;
    }

    List<String[]> getAllMeasurementSchema(ShowTimeSeriesPlan plan) throws MetadataException {
        ArrayList<String[]> res;
        String[] nodes = MetaUtils.getNodeNames(plan.getPath().getFullPath());
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(plan.getPath().getFullPath());
        }
        this.limit.set(plan.getLimit());
        this.offset.set(plan.getOffset());
        this.curOffset.set(-1);
        this.count.set(0);
        if (this.offset.get() != 0 || this.limit.get() != 0) {
            res = new ArrayList<String[]>(this.limit.get());
            this.findPath(this.root, nodes, 1, "", res, true);
        } else {
            res = new ArrayList();
            this.findPath(this.root, nodes, 1, "", res, false);
        }
        this.limit.remove();
        this.offset.remove();
        this.curOffset.remove();
        this.count.remove();
        return res;
    }

    private void findPath(MNode node, String[] nodes, int idx, String parent, List<String[]> timeseriesSchemaList, boolean hasLimit) throws MetadataException {
        if (node instanceof LeafMNode) {
            if (nodes.length <= idx) {
                if (hasLimit) {
                    this.curOffset.set(this.curOffset.get() + 1);
                    if (this.curOffset.get() < this.offset.get() || this.count.get().intValue() == this.limit.get().intValue()) {
                        return;
                    }
                }
                String nodeName = node.getName().contains(".") ? "\"" + node + "\"" : node.getName();
                String nodePath = parent + nodeName;
                String[] tsRow = new String[7];
                tsRow[0] = nodePath;
                tsRow[1] = ((LeafMNode)node).getAlias();
                MeasurementSchema measurementSchema = ((LeafMNode)node).getSchema();
                tsRow[2] = this.getStorageGroupName(nodePath);
                tsRow[3] = measurementSchema.getType().toString();
                tsRow[4] = measurementSchema.getEncodingType().toString();
                tsRow[5] = measurementSchema.getCompressor().toString();
                tsRow[6] = String.valueOf(((LeafMNode)node).getOffset());
                timeseriesSchemaList.add(tsRow);
                if (hasLimit) {
                    this.count.set(this.count.get() + 1);
                }
            }
            return;
        }
        String nodeReg = MetaUtils.getNodeRegByIdx(idx, nodes);
        if (!nodeReg.contains("*")) {
            if (node.hasChild(nodeReg)) {
                this.findPath(node.getChild(nodeReg), nodes, idx + 1, parent + node.getName() + '.', timeseriesSchemaList, hasLimit);
            }
        } else {
            for (MNode child : node.getChildren().values()) {
                if (!Pattern.matches(nodeReg.replace("*", ".*"), child.getName())) continue;
                this.findPath(child, nodes, idx + 1, parent + node.getName() + '.', timeseriesSchemaList, hasLimit);
            }
        }
    }

    Set<String> getChildNodePathInNextLevel(String path) throws MetadataException {
        String[] nodes = MetaUtils.getNodeNames(path);
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path);
        }
        TreeSet<String> childNodePaths = new TreeSet<String>();
        this.findChildNodePathInNextLevel(this.root, nodes, 1, "", childNodePaths, nodes.length + 1);
        return childNodePaths;
    }

    private void findChildNodePathInNextLevel(MNode node, String[] nodes, int idx, String parent, Set<String> res, int length) {
        String nodeReg = MetaUtils.getNodeRegByIdx(idx, nodes);
        if (!nodeReg.contains("*")) {
            if (idx == length) {
                res.add(parent + node.getName());
            } else {
                this.findChildNodePathInNextLevel(node.getChild(nodeReg), nodes, idx + 1, parent + node.getName() + '.', res, length);
            }
        } else if (node instanceof InternalMNode && node.getChildren().size() > 0) {
            for (MNode child : node.getChildren().values()) {
                if (!Pattern.matches(nodeReg.replace("*", ".*"), child.getName())) continue;
                if (idx == length) {
                    res.add(parent + node.getName());
                    continue;
                }
                this.findChildNodePathInNextLevel(child, nodes, idx + 1, parent + node.getName() + '.', res, length);
            }
        } else if (idx == length) {
            String nodeName = node.getName().contains(".") ? "\"" + node + "\"" : node.getName();
            res.add(parent + nodeName);
        }
    }

    Set<String> getDevices(String prefixPath) throws MetadataException {
        String[] nodes = MetaUtils.getNodeNames(prefixPath);
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(prefixPath);
        }
        TreeSet<String> devices = new TreeSet<String>();
        this.findDevices(this.root, nodes, 1, "", devices);
        return devices;
    }

    private void findDevices(MNode node, String[] nodes, int idx, String parent, Set<String> res) {
        String nodeReg = MetaUtils.getNodeRegByIdx(idx, nodes);
        if (!"*".equals(nodeReg)) {
            if (node.hasChild(nodeReg)) {
                if (node.getChild(nodeReg) instanceof LeafMNode) {
                    res.add(parent + node.getName());
                } else {
                    this.findDevices(node.getChild(nodeReg), nodes, idx + 1, parent + node.getName() + '.', res);
                }
            }
        } else {
            boolean deviceAdded = false;
            for (MNode child : node.getChildren().values()) {
                if (child instanceof LeafMNode && !deviceAdded) {
                    res.add(parent + node.getName());
                    deviceAdded = true;
                    continue;
                }
                if (child instanceof LeafMNode) continue;
                this.findDevices(child, nodes, idx + 1, parent + node.getName() + '.', res);
            }
        }
    }

    List<String> getNodesList(String path, int nodeLevel) throws MetadataException {
        String[] nodes = MetaUtils.getNodeNames(path);
        if (!nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path);
        }
        ArrayList<String> res = new ArrayList<String>();
        MNode node = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if (node.getChild(nodes[i]) == null) {
                throw new MetadataException(nodes[i - 1] + " does not have the child node " + nodes[i]);
            }
            node = node.getChild(nodes[i]);
        }
        this.findNodes(node, path, res, nodeLevel - (nodes.length - 1));
        return res;
    }

    private void findNodes(MNode node, String path, List<String> res, int targetLevel) {
        if (node == null) {
            return;
        }
        if (targetLevel == 0) {
            res.add(path);
            return;
        }
        if (node instanceof InternalMNode) {
            for (MNode child : node.getChildren().values()) {
                this.findNodes(child, path + '.' + child.toString(), res, targetLevel - 1);
            }
        }
    }

    public String toString() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(this.root.getName(), (Object)this.mNodeToJSON(this.root, null));
        return MTree.jsonToString(jsonObject);
    }

    private static String jsonToString(JSONObject jsonObject) {
        return JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    private JSONObject mNodeToJSON(MNode node, String storageGroupName) {
        JSONObject jsonObject = new JSONObject();
        if (node.getChildren().size() > 0) {
            if (node instanceof StorageGroupMNode) {
                storageGroupName = node.getFullPath();
            }
            for (MNode child : node.getChildren().values()) {
                jsonObject.put(child.getName(), (Object)this.mNodeToJSON(child, storageGroupName));
            }
        } else if (node instanceof LeafMNode) {
            LeafMNode leafMNode = (LeafMNode)node;
            jsonObject.put("DataType", (Object)leafMNode.getSchema().getType());
            jsonObject.put("Encoding", (Object)leafMNode.getSchema().getEncodingType());
            jsonObject.put("Compressor", (Object)leafMNode.getSchema().getCompressor());
            jsonObject.put("args", (Object)leafMNode.getSchema().getProps().toString());
            jsonObject.put("StorageGroup", (Object)storageGroupName);
        }
        return jsonObject;
    }

    static String combineMetadataInStrings(String[] metadataStrs) {
        JSONObject[] jsonObjects = new JSONObject[metadataStrs.length];
        for (int i = 0; i < jsonObjects.length; ++i) {
            jsonObjects[i] = JSONObject.parseObject((String)metadataStrs[i]);
        }
        JSONObject root = jsonObjects[0];
        for (int i = 1; i < jsonObjects.length; ++i) {
            root = MTree.combineJSONObjects(root, jsonObjects[i]);
        }
        return MTree.jsonToString(root);
    }

    private static JSONObject combineJSONObjects(JSONObject a, JSONObject b) {
        JSONObject res = new JSONObject();
        HashSet retainSet = new HashSet(a.keySet());
        retainSet.retainAll(b.keySet());
        HashSet aCha = new HashSet(a.keySet());
        HashSet bCha = new HashSet(b.keySet());
        aCha.removeAll(retainSet);
        bCha.removeAll(retainSet);
        for (String key : aCha) {
            res.put(key, (Object)a.getJSONObject(key));
        }
        for (String key : bCha) {
            res.put(key, b.get((Object)key));
        }
        for (String key : retainSet) {
            Object v1 = a.get((Object)key);
            Object v2 = b.get((Object)key);
            if (v1 instanceof JSONObject && v2 instanceof JSONObject) {
                res.put(key, (Object)MTree.combineJSONObjects((JSONObject)v1, (JSONObject)v2));
                continue;
            }
            res.put(key, v1);
        }
        return res;
    }

    Map<String, String> determineStorageGroup(String path) throws IllegalPathException {
        HashMap<String, String> paths = new HashMap<String, String>();
        String[] nodes = MetaUtils.getNodeNames(path);
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path);
        }
        ArrayDeque<MNode> nodeStack = new ArrayDeque<MNode>();
        ArrayDeque<Integer> depthStack = new ArrayDeque<Integer>();
        if (!this.root.getChildren().isEmpty()) {
            nodeStack.push(this.root);
            depthStack.push(0);
        }
        while (!nodeStack.isEmpty()) {
            MNode mNode = (MNode)nodeStack.removeFirst();
            int depth = (Integer)depthStack.removeFirst();
            this.determineStorageGroup(depth + 1, nodes, mNode, paths, nodeStack, depthStack);
        }
        return paths;
    }

    private void determineStorageGroup(int depth, String[] nodes, MNode mNode, Map<String, String> paths, Deque<MNode> nodeStack, Deque<Integer> depthStack) {
        String currNode = depth >= nodes.length ? "*" : nodes[depth];
        for (Map.Entry<String, MNode> entry : mNode.getChildren().entrySet()) {
            if (!currNode.equals("*") && !currNode.equals(entry.getKey())) continue;
            MNode child = entry.getValue();
            if (child instanceof StorageGroupMNode) {
                String sgName = child.getFullPath();
                StringBuilder pathWithKnownSG = new StringBuilder(sgName);
                for (int i = depth + 1; i < nodes.length; ++i) {
                    pathWithKnownSG.append('.').append(nodes[i]);
                }
                if (depth >= nodes.length - 1 && currNode.equals("*")) {
                    pathWithKnownSG.append('.').append("*");
                }
                paths.put(sgName, pathWithKnownSG.toString());
                continue;
            }
            if (child.getChildren().isEmpty()) continue;
            nodeStack.push(child);
            depthStack.push(depth);
        }
    }
}

