/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.upgrade.UpgradeTask;
import org.apache.iotdb.db.exception.PartitionViolationException;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileResource {
    private static final Logger logger = LoggerFactory.getLogger(TsFileResource.class);
    private File file;
    public static final String RESOURCE_SUFFIX = ".resource";
    static final String TEMP_SUFFIX = ".temp";
    private static final String CLOSING_SUFFIX = ".closing";
    private static final int INIT_ARRAY_SIZE = 64;
    private long[] startTimes;
    private long[] endTimes;
    private Map<String, Integer> deviceToIndex;
    private TsFileProcessor processor;
    private ModificationFile modFile;
    private volatile boolean closed = false;
    private volatile boolean deleted = false;
    private volatile boolean isMerging = false;
    private Set<Long> historicalVersions;
    private List<ChunkMetadata> chunkMetadataList;
    private List<ReadOnlyMemChunk> readOnlyMemChunk;
    private TimeseriesMetadata timeSeriesMetadata;
    private ReentrantReadWriteLock writeQueryLock = new ReentrantReadWriteLock();
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private List<TsFileResource> upgradedResources;
    private StorageGroupProcessor.UpgradeTsFileResourceCallBack upgradeTsFileResourceCallBack;
    private boolean isSeq;

    public TsFileProcessor getProcessor() {
        return this.processor;
    }

    public TsFileResource() {
    }

    public TsFileResource(TsFileResource other) throws IOException {
        this.file = other.file;
        this.deviceToIndex = other.deviceToIndex;
        this.startTimes = other.startTimes;
        this.endTimes = other.endTimes;
        this.processor = other.processor;
        this.modFile = other.modFile;
        this.closed = other.closed;
        this.deleted = other.deleted;
        this.isMerging = other.isMerging;
        this.chunkMetadataList = other.chunkMetadataList;
        this.readOnlyMemChunk = other.readOnlyMemChunk;
        this.generateTimeSeriesMetadata();
        this.writeQueryLock = other.writeQueryLock;
        this.fsFactory = other.fsFactory;
        this.historicalVersions = other.historicalVersions;
    }

    public TsFileResource(File file) {
        this.file = file;
        this.deviceToIndex = new ConcurrentHashMap<String, Integer>();
        this.startTimes = new long[64];
        this.endTimes = new long[64];
        this.initTimes(this.startTimes, Long.MAX_VALUE);
        this.initTimes(this.endTimes, Long.MIN_VALUE);
    }

    public TsFileResource(File file, TsFileProcessor processor) {
        this.file = file;
        this.deviceToIndex = new ConcurrentHashMap<String, Integer>();
        this.startTimes = new long[64];
        this.endTimes = new long[64];
        this.initTimes(this.startTimes, Long.MAX_VALUE);
        this.initTimes(this.endTimes, Long.MIN_VALUE);
        this.processor = processor;
    }

    public TsFileResource(File file, Map<String, Integer> deviceToIndex, long[] startTimes, long[] endTimes, List<ReadOnlyMemChunk> readOnlyMemChunk, List<ChunkMetadata> chunkMetadataList) throws IOException {
        this.file = file;
        this.deviceToIndex = deviceToIndex;
        this.startTimes = startTimes;
        this.endTimes = endTimes;
        this.chunkMetadataList = chunkMetadataList;
        this.readOnlyMemChunk = readOnlyMemChunk;
        this.generateTimeSeriesMetadata();
    }

    private void generateTimeSeriesMetadata() throws IOException {
        TSDataType dataType;
        if (this.chunkMetadataList.isEmpty() && this.readOnlyMemChunk.isEmpty()) {
            this.timeSeriesMetadata = null;
        }
        this.timeSeriesMetadata = new TimeseriesMetadata();
        this.timeSeriesMetadata.setOffsetOfChunkMetaDataList(-1L);
        this.timeSeriesMetadata.setDataSizeOfChunkMetaDataList(-1);
        if (!this.chunkMetadataList.isEmpty()) {
            this.timeSeriesMetadata.setMeasurementId(this.chunkMetadataList.get(0).getMeasurementUid());
            dataType = this.chunkMetadataList.get(0).getDataType();
            this.timeSeriesMetadata.setTSDataType(dataType);
        } else if (!this.readOnlyMemChunk.isEmpty()) {
            this.timeSeriesMetadata.setMeasurementId(this.readOnlyMemChunk.get(0).getMeasurementUid());
            dataType = this.readOnlyMemChunk.get(0).getDataType();
            this.timeSeriesMetadata.setTSDataType(dataType);
        }
        if (this.timeSeriesMetadata.getTSDataType() != null) {
            Statistics seriesStatistics = Statistics.getStatsByType((TSDataType)this.timeSeriesMetadata.getTSDataType());
            for (ChunkMetadata chunkMetadata : this.chunkMetadataList) {
                seriesStatistics.mergeStatistics(chunkMetadata.getStatistics());
            }
            for (ReadOnlyMemChunk memChunk : this.readOnlyMemChunk) {
                if (memChunk.isEmpty()) continue;
                seriesStatistics.mergeStatistics(memChunk.getChunkMetaData().getStatistics());
            }
            this.timeSeriesMetadata.setStatistics(seriesStatistics);
        } else {
            this.timeSeriesMetadata = null;
        }
    }

    private void initTimes(long[] times, long defaultTime) {
        Arrays.fill(times, defaultTime);
    }

    public void serialize() throws IOException {
        try (BufferedOutputStream outputStream = this.fsFactory.getBufferedOutputStream(this.file + RESOURCE_SUFFIX + TEMP_SUFFIX);){
            ReadWriteIOUtils.write((int)this.deviceToIndex.size(), (OutputStream)outputStream);
            for (Map.Entry<String, Integer> entry : this.deviceToIndex.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)this.startTimes[entry.getValue()], (OutputStream)outputStream);
            }
            ReadWriteIOUtils.write((int)this.deviceToIndex.size(), (OutputStream)outputStream);
            for (Map.Entry<String, Integer> entry : this.deviceToIndex.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)this.endTimes[entry.getValue()], (OutputStream)outputStream);
            }
            if (this.historicalVersions != null) {
                ReadWriteIOUtils.write((int)this.historicalVersions.size(), (OutputStream)outputStream);
                for (Long historicalVersion : this.historicalVersions) {
                    ReadWriteIOUtils.write((long)historicalVersion, (OutputStream)outputStream);
                }
            }
        }
        File src = this.fsFactory.getFile(this.file + RESOURCE_SUFFIX + TEMP_SUFFIX);
        File dest = this.fsFactory.getFile(this.file + RESOURCE_SUFFIX);
        dest.delete();
        this.fsFactory.moveFile(src, dest);
    }

    public void deserialize() throws IOException {
        try (BufferedInputStream inputStream = this.fsFactory.getBufferedInputStream(this.file + RESOURCE_SUFFIX);){
            int i;
            int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
            HashMap<String, Integer> deviceMap = new HashMap<String, Integer>();
            long[] startTimesArray = new long[size];
            long[] endTimesArray = new long[size];
            for (i = 0; i < size; ++i) {
                String path = ReadWriteIOUtils.readString((InputStream)inputStream);
                long time = ReadWriteIOUtils.readLong((InputStream)inputStream);
                deviceMap.put(path, i);
                startTimesArray[i] = time;
            }
            size = ReadWriteIOUtils.readInt((InputStream)inputStream);
            for (i = 0; i < size; ++i) {
                long time;
                ReadWriteIOUtils.readString((InputStream)inputStream);
                endTimesArray[i] = time = ReadWriteIOUtils.readLong((InputStream)inputStream);
            }
            this.startTimes = startTimesArray;
            this.endTimes = endTimesArray;
            this.deviceToIndex = deviceMap;
            if (((InputStream)inputStream).available() > 0) {
                int versionSize = ReadWriteIOUtils.readInt((InputStream)inputStream);
                this.historicalVersions = new HashSet<Long>();
                for (int i2 = 0; i2 < versionSize; ++i2) {
                    this.historicalVersions.add(ReadWriteIOUtils.readLong((InputStream)inputStream));
                }
            } else {
                long version = Long.parseLong(this.file.getName().split("-")[1]);
                this.historicalVersions = Collections.singleton(version);
            }
        }
    }

    public void updateStartTime(String device, long time) {
        long startTime = this.getStartTime(device);
        if (time < startTime) {
            this.putStartTime(device, time);
        }
    }

    public void updateEndTime(String device, long time) {
        long endTime = this.getEndTime(device);
        if (time > endTime) {
            this.putEndTime(device, time);
        }
    }

    public boolean fileExists() {
        return this.fsFactory.getFile(this.file + RESOURCE_SUFFIX).exists();
    }

    void forceUpdateEndTime(String device, long time) {
        this.putEndTime(device, time);
    }

    public List<ChunkMetadata> getChunkMetadataList() {
        return new ArrayList<ChunkMetadata>(this.chunkMetadataList);
    }

    public List<ReadOnlyMemChunk> getReadOnlyMemChunk() {
        return this.readOnlyMemChunk;
    }

    public synchronized ModificationFile getModFile() {
        if (this.modFile == null) {
            this.modFile = new ModificationFile(this.file.getAbsolutePath() + ".mods");
        }
        return this.modFile;
    }

    public void setFile(File file) {
        this.file = file;
    }

    boolean containsDevice(String deviceId) {
        return this.deviceToIndex.containsKey(deviceId);
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public long getFileSize() {
        return this.file.length();
    }

    public long getStartTime(String deviceId) {
        if (!this.deviceToIndex.containsKey(deviceId)) {
            return Long.MAX_VALUE;
        }
        return this.startTimes[this.deviceToIndex.get(deviceId)];
    }

    public long getStartTime(int index) {
        return this.startTimes[index];
    }

    public long getEndTime(String deviceId) {
        if (!this.deviceToIndex.containsKey(deviceId)) {
            return Long.MIN_VALUE;
        }
        return this.endTimes[this.deviceToIndex.get(deviceId)];
    }

    public long getEndTime(int index) {
        return this.endTimes[index];
    }

    public long getOrDefaultStartTime(String deviceId, long defaultTime) {
        long startTime = this.getStartTime(deviceId);
        return startTime != Long.MAX_VALUE ? startTime : defaultTime;
    }

    public long getOrDefaultEndTime(String deviceId, long defaultTime) {
        long endTime = this.getEndTime(deviceId);
        return endTime != Long.MIN_VALUE ? endTime : defaultTime;
    }

    public void putStartTime(String deviceId, long startTime) {
        int index;
        if (this.containsDevice(deviceId)) {
            index = this.deviceToIndex.get(deviceId);
        } else {
            index = this.deviceToIndex.size();
            this.deviceToIndex.put(deviceId, index);
            if (this.startTimes.length <= index) {
                this.startTimes = this.enLargeArray(this.startTimes, Long.MAX_VALUE);
                this.endTimes = this.enLargeArray(this.endTimes, Long.MIN_VALUE);
            }
        }
        this.startTimes[index] = startTime;
    }

    public void putEndTime(String deviceId, long endTime) {
        int index;
        if (this.containsDevice(deviceId)) {
            index = this.deviceToIndex.get(deviceId);
        } else {
            index = this.deviceToIndex.size();
            this.deviceToIndex.put(deviceId, index);
            if (this.endTimes.length <= index) {
                this.startTimes = this.enLargeArray(this.startTimes, Long.MAX_VALUE);
                this.endTimes = this.enLargeArray(this.endTimes, Long.MIN_VALUE);
            }
        }
        this.endTimes[index] = endTime;
    }

    private long[] enLargeArray(long[] array, long defaultValue) {
        long[] tmp = new long[(int)((double)array.length * 1.5)];
        this.initTimes(tmp, defaultValue);
        System.arraycopy(array, 0, tmp, 0, array.length);
        return tmp;
    }

    public Map<String, Integer> getDeviceToIndexMap() {
        return this.deviceToIndex;
    }

    public long[] getStartTimes() {
        return this.startTimes;
    }

    public long[] getEndTimes() {
        return this.endTimes;
    }

    public void clearEndTimes() {
        this.endTimes = new long[this.endTimes.length];
        this.initTimes(this.endTimes, Long.MIN_VALUE);
    }

    public boolean areEndTimesEmpty() {
        for (long endTime : this.endTimes) {
            if (endTime == -1L) continue;
            return false;
        }
        return true;
    }

    private void trimStartEndTimes() {
        this.startTimes = Arrays.copyOfRange(this.startTimes, 0, this.deviceToIndex.size());
        this.endTimes = Arrays.copyOfRange(this.endTimes, 0, this.deviceToIndex.size());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.modFile != null) {
            this.modFile.close();
            this.modFile = null;
        }
        this.processor = null;
        this.chunkMetadataList = null;
        this.trimStartEndTimes();
    }

    TsFileProcessor getUnsealedFileProcessor() {
        return this.processor;
    }

    public ReentrantReadWriteLock getWriteQueryLock() {
        return this.writeQueryLock;
    }

    void doUpgrade() {
        if (UpgradeUtils.isNeedUpgrade(this)) {
            UpgradeSevice.getINSTANCE().submitUpgradeTask(new UpgradeTask(this));
        }
    }

    public void removeModFile() throws IOException {
        this.getModFile().remove();
        this.modFile = null;
    }

    public void remove() {
        this.file.delete();
        this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX).delete();
        this.fsFactory.getFile(this.file.getPath() + ".mods").delete();
    }

    public void removeResourceFile() {
        this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX).delete();
    }

    void moveTo(File targetDir) {
        this.fsFactory.moveFile(this.file, this.fsFactory.getFile(targetDir, this.file.getName()));
        this.fsFactory.moveFile(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX), this.fsFactory.getFile(targetDir, this.file.getName() + RESOURCE_SUFFIX));
        this.fsFactory.getFile(this.file.getPath() + ".mods").delete();
    }

    public String toString() {
        return this.file.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFileResource that = (TsFileResource)o;
        return Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    boolean isMerging() {
        return this.isMerging;
    }

    public void setMerging(boolean merging) {
        this.isMerging = merging;
    }

    public boolean stillLives(long timeLowerBound) {
        if (timeLowerBound == Long.MAX_VALUE) {
            return true;
        }
        for (long endTime : this.endTimes) {
            if (endTime < timeLowerBound) continue;
            return true;
        }
        return false;
    }

    protected void setStartTimes(long[] startTimes) {
        this.startTimes = startTimes;
    }

    protected void setEndTimes(long[] endTimes) {
        this.endTimes = endTimes;
    }

    void setCloseFlag() {
        try {
            if (!this.fsFactory.getFile(this.file.getAbsoluteFile() + CLOSING_SUFFIX).createNewFile()) {
                logger.error("Cannot create close flag for {}", (Object)this.file);
            }
        }
        catch (IOException e) {
            logger.error("Cannot create close flag for {}", (Object)this.file, (Object)e);
        }
    }

    public void cleanCloseFlag() {
        if (!this.fsFactory.getFile(this.file.getAbsoluteFile() + CLOSING_SUFFIX).delete()) {
            logger.error("Cannot clean close flag for {}", (Object)this.file);
        }
    }

    public boolean isCloseFlagSet() {
        return this.fsFactory.getFile(this.file.getAbsoluteFile() + CLOSING_SUFFIX).exists();
    }

    public Set<Long> getHistoricalVersions() {
        return this.historicalVersions;
    }

    public void setHistoricalVersions(Set<Long> historicalVersions) {
        this.historicalVersions = historicalVersions;
    }

    public void setProcessor(TsFileProcessor processor) {
        this.processor = processor;
    }

    public TimeseriesMetadata getTimeSeriesMetadata() {
        return this.timeSeriesMetadata;
    }

    public void setUpgradedResources(List<TsFileResource> upgradedResources) {
        this.upgradedResources = upgradedResources;
    }

    public List<TsFileResource> getUpgradedResources() {
        return this.upgradedResources;
    }

    public void setSeq(boolean isSeq) {
        this.isSeq = isSeq;
    }

    public boolean isSeq() {
        return this.isSeq;
    }

    public void setUpgradeTsFileResourceCallBack(StorageGroupProcessor.UpgradeTsFileResourceCallBack upgradeTsFileResourceCallBack) {
        this.upgradeTsFileResourceCallBack = upgradeTsFileResourceCallBack;
    }

    public StorageGroupProcessor.UpgradeTsFileResourceCallBack getUpgradeTsFileResourceCallBack() {
        return this.upgradeTsFileResourceCallBack;
    }

    public long getTimePartition() {
        if (this.deviceToIndex != null && !this.deviceToIndex.isEmpty()) {
            return StorageEngine.getTimePartition(this.startTimes[this.deviceToIndex.values().iterator().next()]);
        }
        String[] splits = FilePathUtils.splitTsFilePath(this);
        return Long.parseLong(splits[splits.length - 2]);
    }

    public long getTimePartitionWithCheck() throws PartitionViolationException {
        long p;
        int n;
        long partitionId = -1L;
        long[] lArray = this.startTimes;
        int n2 = lArray.length;
        for (n = 0; n < n2; ++n) {
            Long startTime = lArray[n];
            p = StorageEngine.getTimePartition(startTime);
            if (partitionId == -1L) {
                partitionId = p;
                continue;
            }
            if (partitionId == p) continue;
            throw new PartitionViolationException(this);
        }
        lArray = this.endTimes;
        n2 = lArray.length;
        for (n = 0; n < n2; ++n) {
            Long endTime = lArray[n];
            p = StorageEngine.getTimePartition(endTime);
            if (partitionId == -1L) {
                partitionId = p;
                continue;
            }
            if (partitionId == p) continue;
            throw new PartitionViolationException(this);
        }
        if (partitionId == -1L) {
            throw new PartitionViolationException(this);
        }
        return partitionId;
    }
}

