/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.selector.IMergeFileSelector;
import org.apache.iotdb.db.engine.merge.selector.MaxFileMergeFileSelector;
import org.apache.iotdb.db.engine.merge.selector.MaxSeriesMergeFileSelector;
import org.apache.iotdb.db.engine.merge.selector.MergeFileStrategy;
import org.apache.iotdb.db.engine.merge.task.MergeTask;
import org.apache.iotdb.db.engine.merge.task.RecoverMergeTask;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.SimpleFileVersionController;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.OutOfTTLException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.LeafMNode;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryFileManager;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.db.utils.CopyOnReadLinkedList;
import org.apache.iotdb.db.utils.FileUtils;
import org.apache.iotdb.db.writelog.recover.TsFileRecoverPerformer;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageGroupProcessor {
    private static final String MERGING_MODIFICATION_FILE_NAME = "merge.mods";
    private static final Logger logger = LoggerFactory.getLogger(StorageGroupProcessor.class);
    private static final int POS_ALREADY_EXIST = -2;
    private static final int POS_OVERLAP = -3;
    private final ReadWriteLock insertLock = new ReentrantReadWriteLock();
    private final Object closeStorageGroupCondition = new Object();
    private final ReadWriteLock closeQueryLock = new ReentrantReadWriteLock();
    private final TreeMap<Long, TsFileProcessor> workSequenceTsFileProcessors = new TreeMap();
    private final TreeMap<Long, TsFileProcessor> workUnsequenceTsFileProcessors = new TreeMap();
    private TreeSet<TsFileResource> sequenceFileTreeSet = new TreeSet((o1, o2) -> {
        int rangeCompare = Long.compare(Long.parseLong(o1.getFile().getParentFile().getName()), Long.parseLong(o2.getFile().getParentFile().getName()));
        return rangeCompare == 0 ? this.compareFileName(o1.getFile(), o2.getFile()) : rangeCompare;
    });
    private List<TsFileResource> upgradeSeqFileList = new LinkedList<TsFileResource>();
    private CopyOnReadLinkedList<TsFileProcessor> closingSequenceTsFileProcessor = new CopyOnReadLinkedList();
    private List<TsFileResource> unSequenceFileList = new ArrayList<TsFileResource>();
    private List<TsFileResource> upgradeUnseqFileList = new LinkedList<TsFileResource>();
    private CopyOnReadLinkedList<TsFileProcessor> closingUnSequenceTsFileProcessor = new CopyOnReadLinkedList();
    private Map<Long, Map<String, Long>> latestTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<Long, Map<String, Long>> partitionLatestFlushedTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<Long, Map<String, Long>> newlyFlushedPartitionLatestFlushedTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<String, Long> globalLatestFlushedTimeForEachDevice = new HashMap<String, Long>();
    private String storageGroupName;
    private File storageGroupSysDir;
    private HashMap<Long, VersionController> timePartitionIdVersionControllerMap = new HashMap();
    private ReentrantReadWriteLock mergeLock = new ReentrantReadWriteLock();
    private ModificationFile mergingModification;
    private volatile boolean isMerging = false;
    private long mergeStartTime;
    private long dataTTL = Long.MAX_VALUE;
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private TsFileFlushPolicy fileFlushPolicy;
    private Map<Long, Set<Long>> partitionDirectFileVersions = new HashMap<Long, Set<Long>>();
    private Map<Long, Long> partitionMaxFileVersions = new HashMap<Long, Long>();

    public StorageGroupProcessor(String systemDir, String storageGroupName, TsFileFlushPolicy fileFlushPolicy) throws StorageGroupProcessorException {
        this.storageGroupName = storageGroupName;
        this.fileFlushPolicy = fileFlushPolicy;
        this.storageGroupSysDir = SystemFileFactory.INSTANCE.getFile(systemDir, storageGroupName);
        if (this.storageGroupSysDir.mkdirs()) {
            logger.info("Storage Group system Directory {} doesn't exist, create it", (Object)this.storageGroupSysDir.getPath());
        } else if (!this.storageGroupSysDir.exists()) {
            logger.error("create Storage Group system Directory {} failed", (Object)this.storageGroupSysDir.getPath());
        }
        this.recover();
    }

    private void recover() throws StorageGroupProcessorException {
        logger.info("recover Storage Group  {}", (Object)this.storageGroupName);
        try {
            long partitionNum;
            Pair<List<TsFileResource>, List<TsFileResource>> seqTsFilesPair = this.getAllFiles(DirectoryManager.getInstance().getAllSequenceFileFolders());
            List tmpSeqTsFiles = (List)seqTsFilesPair.left;
            List oldSeqTsFiles = (List)seqTsFilesPair.right;
            this.upgradeSeqFileList.addAll(oldSeqTsFiles);
            Pair<List<TsFileResource>, List<TsFileResource>> unseqTsFilesPair = this.getAllFiles(DirectoryManager.getInstance().getAllUnSequenceFileFolders());
            List tmpUnseqTsFiles = (List)unseqTsFilesPair.left;
            List oldUnseqTsFiles = (List)unseqTsFilesPair.right;
            this.upgradeUnseqFileList.addAll(oldUnseqTsFiles);
            this.recoverSeqFiles(tmpSeqTsFiles);
            this.recoverUnseqFiles(tmpUnseqTsFiles);
            for (TsFileResource resource : this.sequenceFileTreeSet) {
                partitionNum = resource.getTimePartition();
                this.partitionDirectFileVersions.computeIfAbsent(partitionNum, p -> new HashSet()).addAll(resource.getHistoricalVersions());
                this.updatePartitionFileVersion(partitionNum, Collections.max(resource.getHistoricalVersions()));
            }
            for (TsFileResource resource : this.unSequenceFileList) {
                partitionNum = resource.getTimePartition();
                this.partitionDirectFileVersions.computeIfAbsent(partitionNum, p -> new HashSet()).addAll(resource.getHistoricalVersions());
                this.updatePartitionFileVersion(partitionNum, Collections.max(resource.getHistoricalVersions()));
            }
            String taskName = this.storageGroupName + "-" + System.currentTimeMillis();
            File mergingMods = SystemFileFactory.INSTANCE.getFile(this.storageGroupSysDir, MERGING_MODIFICATION_FILE_NAME);
            if (mergingMods.exists()) {
                this.mergingModification = new ModificationFile(mergingMods.getPath());
            }
            RecoverMergeTask recoverMergeTask = new RecoverMergeTask(new ArrayList<TsFileResource>(this.sequenceFileTreeSet), this.unSequenceFileList, this.storageGroupSysDir.getPath(), this::mergeEndAction, taskName, IoTDBDescriptor.getInstance().getConfig().isForceFullMerge(), this.storageGroupName);
            logger.info("{} a RecoverMergeTask {} starts...", (Object)this.storageGroupName, (Object)taskName);
            recoverMergeTask.recoverMerge(IoTDBDescriptor.getInstance().getConfig().isContinueMergeAfterReboot());
            if (!IoTDBDescriptor.getInstance().getConfig().isContinueMergeAfterReboot()) {
                mergingMods.delete();
            }
            this.updateLastestFlushedTime();
        }
        catch (IOException | MetadataException e) {
            throw new StorageGroupProcessorException(e);
        }
        for (TsFileResource resource : this.sequenceFileTreeSet) {
            long timePartitionId = resource.getTimePartition();
            HashMap<String, Long> endTimeMap = new HashMap<String, Long>();
            for (Map.Entry<String, Integer> entry : resource.getDeviceToIndexMap().entrySet()) {
                String deviceId = entry.getKey();
                int index = entry.getValue();
                long endTime = resource.getEndTime(index);
                endTimeMap.put(deviceId, endTime);
            }
            this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, l -> new HashMap()).putAll(endTimeMap);
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).putAll(endTimeMap);
            this.globalLatestFlushedTimeForEachDevice.putAll(endTimeMap);
        }
    }

    private void updatePartitionFileVersion(long partitionNum, long fileVersion) {
        long oldVersion = this.partitionMaxFileVersions.getOrDefault(partitionNum, 0L);
        if (fileVersion > oldVersion) {
            this.partitionMaxFileVersions.put(partitionNum, fileVersion);
        }
    }

    private void updateLastestFlushedTime() throws IOException {
        SimpleFileVersionController versionController = new SimpleFileVersionController(this.storageGroupSysDir.getPath());
        long currentVersion = versionController.currVersion();
        for (TsFileResource resource : this.upgradeSeqFileList) {
            for (Map.Entry<String, Integer> entry : resource.getDeviceToIndexMap().entrySet()) {
                String deviceId = entry.getKey();
                int index = entry.getValue();
                long endTime = resource.getEndTime(index);
                long endTimePartitionId = StorageEngine.getTimePartition(endTime);
                this.latestTimeForEachDevice.computeIfAbsent(endTimePartitionId, l -> new HashMap()).put(deviceId, endTime);
                this.globalLatestFlushedTimeForEachDevice.put(deviceId, endTime);
                for (long partitionId = StorageEngine.getTimePartition(resource.getStartTime(index)); partitionId <= endTimePartitionId; ++partitionId) {
                    File versionFile;
                    this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, l -> new HashMap()).put(deviceId, Long.MAX_VALUE);
                    if (this.timePartitionIdVersionControllerMap.containsKey(partitionId)) continue;
                    File directory = SystemFileFactory.INSTANCE.getFile(this.storageGroupSysDir, String.valueOf(partitionId));
                    if (!directory.exists()) {
                        directory.mkdirs();
                    }
                    if (!(versionFile = SystemFileFactory.INSTANCE.getFile(directory, "Version-" + currentVersion)).createNewFile()) {
                        logger.warn("Version file {} has already been created ", (Object)versionFile);
                    }
                    this.timePartitionIdVersionControllerMap.put(partitionId, new SimpleFileVersionController(this.storageGroupSysDir.getPath(), partitionId));
                }
            }
        }
    }

    private VersionController getVersionControllerByTimePartitionId(long timePartitionId) {
        return this.timePartitionIdVersionControllerMap.computeIfAbsent(timePartitionId, id -> {
            try {
                return new SimpleFileVersionController(this.storageGroupSysDir.getPath(), timePartitionId);
            }
            catch (IOException e) {
                logger.error("can't build a version controller for time partition {}", (Object)timePartitionId);
                return null;
            }
        });
    }

    private Pair<List<TsFileResource>, List<TsFileResource>> getAllFiles(List<String> folders) throws IOException {
        ArrayList tsFiles = new ArrayList();
        ArrayList upgradeFiles = new ArrayList();
        for (String baseDir : folders) {
            File[] subFiles;
            File fileFolder = this.fsFactory.getFile(baseDir, this.storageGroupName);
            if (!fileFolder.exists()) continue;
            this.continueFailedRenames(fileFolder, ".temp");
            this.continueFailedRenames(fileFolder, ".merge");
            File[] oldTsfileArray = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), ".tsfile");
            File[] oldResourceFileArray = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), ".resource");
            File[] oldModificationFileArray = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), ".mods");
            File upgradeFolder = this.fsFactory.getFile(fileFolder, "upgrade");
            if (oldTsfileArray.length != 0 || oldResourceFileArray.length != 0) {
                if (upgradeFolder.mkdirs()) {
                    logger.info("Upgrade Directory {} doesn't exist, create it", (Object)upgradeFolder.getPath());
                } else if (!upgradeFolder.exists()) {
                    logger.error("Create upgrade Directory {} failed", (Object)upgradeFolder.getPath());
                }
                for (File file : oldTsfileArray) {
                    if (file.renameTo(this.fsFactory.getFile(upgradeFolder, file.getName()))) continue;
                    logger.error("Failed to move {} to upgrade folder", (Object)file);
                }
                for (File file : oldResourceFileArray) {
                    if (file.renameTo(this.fsFactory.getFile(upgradeFolder, file.getName()))) continue;
                    logger.error("Failed to move {} to upgrade folder", (Object)file);
                }
                for (File file : oldModificationFileArray) {
                    if (file.renameTo(this.fsFactory.getFile(upgradeFolder, file.getName()))) continue;
                    logger.error("Failed to move {} to upgrade folder", (Object)file);
                }
                Collections.addAll(upgradeFiles, this.fsFactory.listFilesBySuffix(upgradeFolder.getAbsolutePath(), ".tsfile"));
            } else if (upgradeFolder.exists()) {
                Collections.addAll(upgradeFiles, this.fsFactory.listFilesBySuffix(upgradeFolder.getAbsolutePath(), ".tsfile"));
            }
            if ((subFiles = fileFolder.listFiles()) == null) continue;
            for (File partitionFolder : subFiles) {
                if (!partitionFolder.isDirectory()) {
                    logger.warn("{} is not a directory.", (Object)partitionFolder.getAbsolutePath());
                    continue;
                }
                if (partitionFolder.getName().equals("upgrade")) continue;
                this.continueFailedRenames(partitionFolder, ".temp");
                this.continueFailedRenames(partitionFolder, ".merge");
                Collections.addAll(tsFiles, this.fsFactory.listFilesBySuffix(partitionFolder.getAbsolutePath(), ".tsfile"));
            }
        }
        tsFiles.sort(this::compareFileName);
        ArrayList ret = new ArrayList();
        tsFiles.forEach(f -> ret.add(new TsFileResource((File)f)));
        upgradeFiles.sort(this::compareFileName);
        ArrayList<TsFileResource> upgradeRet = new ArrayList<TsFileResource>();
        for (File f2 : upgradeFiles) {
            TsFileResource fileResource = new TsFileResource(f2);
            fileResource.setClosed(true);
            fileResource.deserialize();
            upgradeRet.add(fileResource);
        }
        return new Pair(ret, upgradeRet);
    }

    private void continueFailedRenames(File fileFolder, String suffix) {
        File[] files = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), suffix);
        if (files != null) {
            for (File tempResource : files) {
                File originResource = this.fsFactory.getFile(tempResource.getPath().replace(suffix, ""));
                if (originResource.exists()) {
                    tempResource.delete();
                    continue;
                }
                tempResource.renameTo(originResource);
            }
        }
    }

    private void recoverSeqFiles(List<TsFileResource> tsFiles) {
        for (int i = 0; i < tsFiles.size(); ++i) {
            RestorableTsFileIOWriter writer;
            TsFileResource tsFileResource = tsFiles.get(i);
            long timePartitionId = tsFileResource.getTimePartition();
            TsFileRecoverPerformer recoverPerformer = new TsFileRecoverPerformer(this.storageGroupName + "-", this.getVersionControllerByTimePartitionId(timePartitionId), tsFileResource, false, i == tsFiles.size() - 1);
            try {
                writer = recoverPerformer.recover();
            }
            catch (StorageGroupProcessorException e) {
                logger.warn("Skip TsFile: {} because of error in recover: ", (Object)tsFileResource.getPath(), (Object)e);
                continue;
            }
            if (i != tsFiles.size() - 1 || !writer.canWrite()) {
                tsFileResource.setClosed(true);
            } else if (writer.canWrite()) {
                TsFileProcessor tsFileProcessor = new TsFileProcessor(this.storageGroupName, tsFileResource, this.getVersionControllerByTimePartitionId(timePartitionId), this::closeUnsealedTsFileProcessorCallBack, this::updateLatestFlushTimeCallback, true, writer);
                this.workSequenceTsFileProcessors.put(timePartitionId, tsFileProcessor);
                tsFileResource.setProcessor(tsFileProcessor);
                tsFileResource.removeResourceFile();
                tsFileProcessor.setTimeRangeId(timePartitionId);
                writer.makeMetadataVisible();
            }
            this.sequenceFileTreeSet.add(tsFileResource);
        }
    }

    private void recoverUnseqFiles(List<TsFileResource> tsFiles) {
        for (int i = 0; i < tsFiles.size(); ++i) {
            RestorableTsFileIOWriter writer;
            TsFileResource tsFileResource = tsFiles.get(i);
            long timePartitionId = tsFileResource.getTimePartition();
            TsFileRecoverPerformer recoverPerformer = new TsFileRecoverPerformer(this.storageGroupName + "-", this.getVersionControllerByTimePartitionId(timePartitionId), tsFileResource, true, i == tsFiles.size() - 1);
            try {
                writer = recoverPerformer.recover();
            }
            catch (StorageGroupProcessorException e) {
                logger.warn("Skip TsFile: {} because of error in recover: ", (Object)tsFileResource.getPath(), (Object)e);
                continue;
            }
            if (i != tsFiles.size() - 1 || !writer.canWrite()) {
                tsFileResource.setClosed(true);
            } else if (writer.canWrite()) {
                TsFileProcessor tsFileProcessor = new TsFileProcessor(this.storageGroupName, tsFileResource, this.getVersionControllerByTimePartitionId(timePartitionId), this::closeUnsealedTsFileProcessorCallBack, this::unsequenceFlushCallback, false, writer);
                this.workUnsequenceTsFileProcessors.put(timePartitionId, tsFileProcessor);
                tsFileResource.setProcessor(tsFileProcessor);
                tsFileResource.removeResourceFile();
                tsFileProcessor.setTimeRangeId(timePartitionId);
                writer.makeMetadataVisible();
            }
            this.unSequenceFileList.add(tsFileResource);
        }
    }

    private int compareFileName(File o1, File o2) {
        long ver2;
        String[] items1 = o1.getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            return Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
        }
        return cmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertPlan insertPlan) throws WriteProcessException {
        if (!this.isAlive(insertPlan.getTime())) {
            throw new OutOfTTLException(insertPlan.getTime(), System.currentTimeMillis() - this.dataTTL);
        }
        this.writeLock();
        try {
            long timePartitionId = StorageEngine.getTimePartition(insertPlan.getTime());
            this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, l -> new HashMap());
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap());
            this.insertToTsFileProcessor(insertPlan, insertPlan.getTime() > this.partitionLatestFlushedTimeForEachDevice.get(timePartitionId).getOrDefault(insertPlan.getDeviceId(), Long.MIN_VALUE));
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus[] insertTablet(InsertTabletPlan insertTabletPlan) throws WriteProcessException {
        this.writeLock();
        try {
            long currTime2;
            int loc;
            TSStatus[] results = new TSStatus[insertTabletPlan.getRowCount()];
            for (loc = 0; loc < insertTabletPlan.getRowCount() && !this.isAlive(currTime2 = insertTabletPlan.getTimes()[loc]); ++loc) {
                results[loc] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OUT_OF_TTL_ERROR, (String)("time " + currTime2 + " in current line is out of TTL: " + this.dataTTL));
            }
            if (loc == insertTabletPlan.getRowCount()) {
                TSStatus[] currTime2 = results;
                return currTime2;
            }
            int before = loc;
            long beforeTimePartition = StorageEngine.getTimePartition(insertTabletPlan.getTimes()[before]);
            long lastFlushTime = this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(beforeTimePartition, id -> new HashMap()).computeIfAbsent(insertTabletPlan.getDeviceId(), id -> Long.MIN_VALUE);
            boolean isSequence = false;
            while (loc < insertTabletPlan.getRowCount()) {
                long time = insertTabletPlan.getTimes()[loc];
                long curTimePartition = StorageEngine.getTimePartition(time);
                results[loc] = RpcUtils.SUCCESS_STATUS;
                if (curTimePartition != beforeTimePartition) {
                    this.insertTabletToTsFileProcessor(insertTabletPlan, before, loc, isSequence, results, beforeTimePartition);
                    before = loc;
                    beforeTimePartition = curTimePartition;
                    lastFlushTime = this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(beforeTimePartition, id -> new HashMap()).computeIfAbsent(insertTabletPlan.getDeviceId(), id -> Long.MIN_VALUE);
                    isSequence = false;
                    continue;
                }
                if (!isSequence && time > lastFlushTime) {
                    this.insertTabletToTsFileProcessor(insertTabletPlan, before, loc, false, results, beforeTimePartition);
                    before = loc;
                    isSequence = true;
                }
                ++loc;
            }
            if (before < loc) {
                this.insertTabletToTsFileProcessor(insertTabletPlan, before, loc, isSequence, results, beforeTimePartition);
            }
            long globalLatestFlushedTime = this.globalLatestFlushedTimeForEachDevice.getOrDefault(insertTabletPlan.getDeviceId(), Long.MIN_VALUE);
            this.tryToUpdateBatchInsertLastCache(insertTabletPlan, globalLatestFlushedTime);
            TSStatus[] tSStatusArray = results;
            return tSStatusArray;
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean isAlive(long time) {
        return this.dataTTL == Long.MAX_VALUE || System.currentTimeMillis() - time <= this.dataTTL;
    }

    private void insertTabletToTsFileProcessor(InsertTabletPlan insertTabletPlan, int start, int end, boolean sequence, TSStatus[] results, long timePartitionId) throws WriteProcessException {
        if (start >= end) {
            return;
        }
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, sequence);
        if (tsFileProcessor == null) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("can not create TsFileProcessor, timePartitionId: " + timePartitionId));
            }
            return;
        }
        try {
            tsFileProcessor.insertTablet(insertTabletPlan, start, end, results);
        }
        catch (WriteProcessException e) {
            logger.error("insert to TsFileProcessor error ", (Throwable)e);
            return;
        }
        this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, t -> new HashMap());
        if (sequence && this.latestTimeForEachDevice.get(timePartitionId).getOrDefault(insertTabletPlan.getDeviceId(), Long.MIN_VALUE) < insertTabletPlan.getTimes()[end - 1]) {
            this.latestTimeForEachDevice.get(timePartitionId).put(insertTabletPlan.getDeviceId(), insertTabletPlan.getTimes()[end - 1]);
        }
        if (tsFileProcessor.shouldFlush()) {
            this.fileFlushPolicy.apply(this, tsFileProcessor, sequence);
        }
    }

    private void tryToUpdateBatchInsertLastCache(InsertTabletPlan plan, Long latestFlushedTime) throws WriteProcessException {
        MNode node = null;
        try {
            MManager manager = MManager.getInstance();
            node = manager.getDeviceNodeWithAutoCreateAndReadLock(plan.getDeviceId());
            String[] measurementList = plan.getMeasurements();
            for (int i = 0; i < measurementList.length; ++i) {
                ((LeafMNode)manager.getChild(node, measurementList[i])).updateCachedLast(plan.composeLastTimeValuePair(i), true, latestFlushedTime);
            }
        }
        catch (MetadataException e) {
            throw new WriteProcessException(e);
        }
        finally {
            if (node != null) {
                ((InternalMNode)node).readUnlock();
            }
        }
    }

    private void insertToTsFileProcessor(InsertPlan insertPlan, boolean sequence) throws WriteProcessException {
        long timePartitionId = StorageEngine.getTimePartition(insertPlan.getTime());
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, sequence);
        if (tsFileProcessor == null) {
            return;
        }
        tsFileProcessor.insert(insertPlan);
        if (this.latestTimeForEachDevice.get(timePartitionId).getOrDefault(insertPlan.getDeviceId(), Long.MIN_VALUE) < insertPlan.getTime()) {
            this.latestTimeForEachDevice.get(timePartitionId).put(insertPlan.getDeviceId(), insertPlan.getTime());
        }
        long globalLatestFlushTime = this.globalLatestFlushedTimeForEachDevice.getOrDefault(insertPlan.getDeviceId(), Long.MIN_VALUE);
        this.tryToUpdateInsertLastCache(insertPlan, globalLatestFlushTime);
        if (tsFileProcessor.shouldFlush()) {
            this.fileFlushPolicy.apply(this, tsFileProcessor, sequence);
        }
    }

    private void tryToUpdateInsertLastCache(InsertPlan plan, Long latestFlushedTime) throws WriteProcessException {
        MNode node = null;
        try {
            MManager manager = MManager.getInstance();
            node = manager.getDeviceNodeWithAutoCreateAndReadLock(plan.getDeviceId());
            String[] measurementList = plan.getMeasurements();
            for (int i = 0; i < measurementList.length; ++i) {
                if (plan.getValues()[i] == null) continue;
                ((LeafMNode)manager.getChild(node, measurementList[i])).updateCachedLast(plan.composeTimeValuePair(i), true, latestFlushedTime);
            }
        }
        catch (MetadataException e) {
            throw new WriteProcessException(e);
        }
        finally {
            if (node != null) {
                ((InternalMNode)node).readUnlock();
            }
        }
    }

    private TsFileProcessor getOrCreateTsFileProcessor(long timeRangeId, boolean sequence) {
        TsFileProcessor tsFileProcessor = null;
        try {
            tsFileProcessor = sequence ? this.getOrCreateTsFileProcessorIntern(timeRangeId, this.workSequenceTsFileProcessors, this.sequenceFileTreeSet, true) : this.getOrCreateTsFileProcessorIntern(timeRangeId, this.workUnsequenceTsFileProcessors, this.unSequenceFileList, false);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("disk space is insufficient when creating TsFile processor, change system mode to read-only", (Throwable)e);
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
        }
        catch (IOException e) {
            logger.error("meet IOException when creating TsFileProcessor, change system mode to read-only", (Throwable)e);
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
        }
        return tsFileProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TsFileProcessor getOrCreateTsFileProcessorIntern(long timeRangeId, TreeMap<Long, TsFileProcessor> tsFileProcessorTreeMap, Collection<TsFileResource> fileList, boolean sequence) throws IOException, DiskSpaceInsufficientException {
        TsFileProcessor res;
        this.writeLock();
        try {
            if (!tsFileProcessorTreeMap.containsKey(timeRangeId)) {
                if (tsFileProcessorTreeMap.size() >= IoTDBDescriptor.getInstance().getConfig().getConcurrentWritingTimePartition()) {
                    Map.Entry<Long, TsFileProcessor> processorEntry = tsFileProcessorTreeMap.firstEntry();
                    logger.info("will close a {} TsFile because too many active partitions ({} > {}) in the storage group {},", new Object[]{sequence, tsFileProcessorTreeMap.size(), IoTDBDescriptor.getInstance().getConfig().getConcurrentWritingTimePartition(), this.storageGroupName});
                    this.asyncCloseOneTsFileProcessor(sequence, processorEntry.getValue());
                }
                TsFileProcessor newProcessor = this.createTsFileProcessor(sequence, timeRangeId);
                tsFileProcessorTreeMap.put(timeRangeId, newProcessor);
                fileList.add(newProcessor.getTsFileResource());
                res = newProcessor;
            } else {
                res = tsFileProcessorTreeMap.get(timeRangeId);
            }
        }
        finally {
            this.writeUnlock();
        }
        return res;
    }

    private TsFileProcessor createTsFileProcessor(boolean sequence, long timePartitionId) throws IOException, DiskSpaceInsufficientException {
        String baseDir = sequence ? DirectoryManager.getInstance().getNextFolderForSequenceFile() : DirectoryManager.getInstance().getNextFolderForUnSequenceFile();
        this.fsFactory.getFile(baseDir, this.storageGroupName).mkdirs();
        String filePath = baseDir + File.separator + this.storageGroupName + File.separator + timePartitionId + File.separator + this.getNewTsFileName(timePartitionId);
        VersionController versionController = this.getVersionControllerByTimePartitionId(timePartitionId);
        TsFileProcessor tsFileProcessor = sequence ? new TsFileProcessor(this.storageGroupName, this.fsFactory.getFileWithParent(filePath), versionController, this::closeUnsealedTsFileProcessorCallBack, this::updateLatestFlushTimeCallback, true) : new TsFileProcessor(this.storageGroupName, this.fsFactory.getFileWithParent(filePath), versionController, this::closeUnsealedTsFileProcessorCallBack, this::unsequenceFlushCallback, false);
        tsFileProcessor.setTimeRangeId(timePartitionId);
        return tsFileProcessor;
    }

    private String getNewTsFileName(long timePartitionId) {
        long version = this.partitionMaxFileVersions.getOrDefault(timePartitionId, 0L) + 1L;
        this.partitionMaxFileVersions.put(timePartitionId, version);
        this.partitionDirectFileVersions.computeIfAbsent(timePartitionId, p -> new HashSet()).add(version);
        return this.getNewTsFileName(System.currentTimeMillis(), version, 0);
    }

    private String getNewTsFileName(long time, long version, int mergeCnt) {
        return time + "-" + version + "-" + mergeCnt + ".tsfile";
    }

    public void asyncCloseOneTsFileProcessor(boolean sequence, TsFileProcessor tsFileProcessor) {
        if (sequence) {
            this.closingSequenceTsFileProcessor.add(tsFileProcessor);
            this.updateEndTimeMap(tsFileProcessor);
            tsFileProcessor.asyncClose();
            this.workSequenceTsFileProcessors.remove(tsFileProcessor.getTimeRangeId());
            if (!this.workUnsequenceTsFileProcessors.containsKey(tsFileProcessor.getTimeRangeId())) {
                this.timePartitionIdVersionControllerMap.remove(tsFileProcessor.getTimeRangeId());
            }
            logger.info("close a sequence tsfile processor {}", (Object)this.storageGroupName);
        } else {
            this.closingUnSequenceTsFileProcessor.add(tsFileProcessor);
            tsFileProcessor.asyncClose();
            this.workUnsequenceTsFileProcessors.remove(tsFileProcessor.getTimeRangeId());
            if (!this.workSequenceTsFileProcessors.containsKey(tsFileProcessor.getTimeRangeId())) {
                this.timePartitionIdVersionControllerMap.remove(tsFileProcessor.getTimeRangeId());
            }
        }
    }

    public void deleteFolder(String systemDir) {
        logger.info("{} will close all files for deleting data folder {}", (Object)this.storageGroupName, (Object)systemDir);
        this.writeLock();
        this.syncCloseAllWorkingTsFileProcessors();
        try {
            File storageGroupFolder = SystemFileFactory.INSTANCE.getFile(systemDir, this.storageGroupName);
            if (storageGroupFolder.exists()) {
                FileUtils.deleteDirectory(storageGroupFolder);
            }
        }
        catch (IOException e) {
            logger.error("Cannot delete the folder in storage group {}, because", (Object)this.storageGroupName, (Object)e);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void closeAllResources() {
        for (TsFileResource tsFileResource : this.unSequenceFileList) {
            try {
                tsFileResource.close();
            }
            catch (IOException e) {
                logger.error("Cannot close a TsFileResource {}", (Object)tsFileResource, (Object)e);
            }
        }
        for (TsFileResource tsFileResource : this.sequenceFileTreeSet) {
            try {
                tsFileResource.close();
            }
            catch (IOException e) {
                logger.error("Cannot close a TsFileResource {}", (Object)tsFileResource, (Object)e);
            }
        }
    }

    public void syncDeleteDataFiles() {
        logger.info("{} will close all files for deleting data files", (Object)this.storageGroupName);
        this.writeLock();
        this.syncCloseAllWorkingTsFileProcessors();
        if (this.mergingModification != null) {
            try {
                this.mergingModification.close();
            }
            catch (IOException e) {
                logger.error("Cannot close the mergingMod file {}", (Object)this.mergingModification.getFilePath(), (Object)e);
            }
        }
        try {
            this.closeAllResources();
            List<String> folder = DirectoryManager.getInstance().getAllSequenceFileFolders();
            folder.addAll(DirectoryManager.getInstance().getAllUnSequenceFileFolders());
            this.deleteAllSGFolders(folder);
            this.workSequenceTsFileProcessors.clear();
            this.workUnsequenceTsFileProcessors.clear();
            this.sequenceFileTreeSet.clear();
            this.unSequenceFileList.clear();
            this.partitionLatestFlushedTimeForEachDevice.clear();
            this.globalLatestFlushedTimeForEachDevice.clear();
            this.latestTimeForEachDevice.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    private void deleteAllSGFolders(List<String> folder) {
        for (String tsfilePath : folder) {
            File storageGroupFolder = this.fsFactory.getFile(tsfilePath, this.storageGroupName);
            if (!storageGroupFolder.exists()) continue;
            try {
                FileUtils.deleteDirectory(storageGroupFolder);
            }
            catch (IOException e) {
                logger.error("Delete TsFiles failed", (Throwable)e);
            }
        }
    }

    public synchronized void checkFilesTTL() {
        if (this.dataTTL == Long.MAX_VALUE) {
            logger.debug("{}: TTL not set, ignore the check", (Object)this.storageGroupName);
            return;
        }
        long timeLowerBound = System.currentTimeMillis() - this.dataTTL;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: TTL removing files before {}", (Object)this.storageGroupName, (Object)new Date(timeLowerBound));
        }
        ArrayList<TsFileResource> seqFiles = new ArrayList<TsFileResource>(this.sequenceFileTreeSet);
        ArrayList<TsFileResource> unseqFiles = new ArrayList<TsFileResource>(this.unSequenceFileList);
        for (TsFileResource tsFileResource : seqFiles) {
            this.checkFileTTL(tsFileResource, timeLowerBound, true);
        }
        for (TsFileResource tsFileResource : unseqFiles) {
            this.checkFileTTL(tsFileResource, timeLowerBound, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileTTL(TsFileResource resource, long timeLowerBound, boolean isSeq) {
        block12: {
            if (resource.isMerging() || !resource.isClosed() || !resource.isDeleted() && resource.stillLives(timeLowerBound)) {
                return;
            }
            this.writeLock();
            try {
                resource.setDeleted(true);
                if (resource.isMerging()) {
                    return;
                }
                if (!resource.getWriteQueryLock().writeLock().tryLock()) break block12;
                try {
                    resource.remove();
                    if (logger.isInfoEnabled()) {
                        logger.info("Removed a file {} before {} by ttl ({}ms)", new Object[]{resource.getPath(), new Date(timeLowerBound), this.dataTTL});
                    }
                    if (isSeq) {
                        this.sequenceFileTreeSet.remove(resource);
                    } else {
                        this.unSequenceFileList.remove(resource);
                    }
                }
                finally {
                    resource.getWriteQueryLock().writeLock().unlock();
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCloseAllWorkingTsFileProcessors() {
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            try {
                this.asyncCloseAllWorkingTsFileProcessors();
                long startTime = System.currentTimeMillis();
                while (!this.closingSequenceTsFileProcessor.isEmpty() || !this.closingUnSequenceTsFileProcessor.isEmpty()) {
                    this.closeStorageGroupCondition.wait(60000L);
                    if (System.currentTimeMillis() - startTime <= 60000L) continue;
                    logger.warn("{} has spent {}s to wait for closing all TsFiles.", (Object)this.storageGroupName, (Object)((System.currentTimeMillis() - startTime) / 1000L));
                }
            }
            catch (InterruptedException e) {
                logger.error("CloseFileNodeCondition error occurs while waiting for closing the storage group {}", (Object)this.storageGroupName, (Object)e);
            }
        }
    }

    public void asyncCloseAllWorkingTsFileProcessors() {
        this.writeLock();
        try {
            logger.info("async force close all files in storage group: {}", (Object)this.storageGroupName);
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values())) {
                this.asyncCloseOneTsFileProcessor(true, tsFileProcessor);
            }
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values())) {
                this.asyncCloseOneTsFileProcessor(false, tsFileProcessor);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public QueryDataSource query(String deviceId, String measurementId, QueryContext context, QueryFileManager filePathsManager, Filter timeFilter) throws QueryProcessException {
        this.insertLock.readLock().lock();
        this.mergeLock.readLock().lock();
        try {
            List<TsFileResource> seqResources = this.getFileResourceListForQuery(this.sequenceFileTreeSet, this.upgradeSeqFileList, deviceId, measurementId, context, timeFilter, true);
            List<TsFileResource> unseqResources = this.getFileResourceListForQuery(this.unSequenceFileList, this.upgradeUnseqFileList, deviceId, measurementId, context, timeFilter, false);
            QueryDataSource dataSource = new QueryDataSource(new Path(deviceId, measurementId), seqResources, unseqResources);
            if (filePathsManager != null) {
                filePathsManager.addUsedFilesForQuery(context.getQueryId(), dataSource);
            }
            dataSource.setDataTTL(this.dataTTL);
            QueryDataSource queryDataSource = dataSource;
            return queryDataSource;
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        finally {
            this.insertLock.readLock().unlock();
            this.mergeLock.readLock().unlock();
        }
    }

    public void writeLock() {
        this.insertLock.writeLock().lock();
    }

    public void writeUnlock() {
        this.insertLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TsFileResource> getFileResourceListForQuery(Collection<TsFileResource> tsFileResources, List<TsFileResource> upgradeTsFileResources, String deviceId, String measurementId, QueryContext context, Filter timeFilter, boolean isSeq) throws MetadataException {
        MeasurementSchema schema = MManager.getInstance().getSeriesSchema(deviceId, measurementId);
        ArrayList<TsFileResource> tsfileResourcesForQuery = new ArrayList<TsFileResource>();
        long timeLowerBound = this.dataTTL != Long.MAX_VALUE ? System.currentTimeMillis() - this.dataTTL : Long.MIN_VALUE;
        context.setQueryTimeLowerBound(timeLowerBound);
        for (TsFileResource tsFileResource : tsFileResources) {
            if (!this.isTsFileResourceSatisfied(tsFileResource, deviceId, timeFilter, isSeq)) continue;
            this.closeQueryLock.readLock().lock();
            try {
                if (tsFileResource.isClosed()) {
                    tsfileResourcesForQuery.add(tsFileResource);
                    continue;
                }
                Pair<List<ReadOnlyMemChunk>, List<ChunkMetadata>> pair = tsFileResource.getUnsealedFileProcessor().query(deviceId, measurementId, schema.getType(), schema.getEncodingType(), schema.getProps(), context);
                tsfileResourcesForQuery.add(new TsFileResource(tsFileResource.getFile(), tsFileResource.getDeviceToIndexMap(), tsFileResource.getStartTimes(), tsFileResource.getEndTimes(), (List)pair.left, (List)pair.right));
            }
            catch (IOException e) {
                throw new MetadataException(e);
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        for (TsFileResource tsFileResource : upgradeTsFileResources) {
            if (!this.isTsFileResourceSatisfied(tsFileResource, deviceId, timeFilter, isSeq)) continue;
            this.closeQueryLock.readLock().lock();
            try {
                tsfileResourcesForQuery.add(tsFileResource);
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        return tsfileResourcesForQuery;
    }

    private boolean isTsFileResourceSatisfied(TsFileResource tsFileResource, String deviceId, Filter timeFilter, boolean isSeq) {
        long endTime;
        if (!tsFileResource.containsDevice(deviceId)) {
            return false;
        }
        int deviceIndex = tsFileResource.getDeviceToIndexMap().get(deviceId);
        long startTime = tsFileResource.getStartTime(deviceIndex);
        long l = endTime = tsFileResource.isClosed() || !isSeq ? tsFileResource.getEndTime(deviceIndex) : Long.MAX_VALUE;
        if (!this.isAlive(endTime)) {
            return false;
        }
        if (timeFilter != null) {
            return timeFilter.satisfyStartEndTime(startTime, endTime);
        }
        return true;
    }

    public void delete(String deviceId, String measurementId, long timestamp) throws IOException {
        this.writeLock();
        this.mergeLock.writeLock().lock();
        ArrayList<ModificationFile> updatedModFiles = new ArrayList<ModificationFile>();
        try {
            Long lastUpdateTime = null;
            for (Map map : this.latestTimeForEachDevice.values()) {
                Long curTime = (Long)map.get(deviceId);
                if (curTime == null || lastUpdateTime != null && lastUpdateTime >= curTime) continue;
                lastUpdateTime = curTime;
            }
            if (lastUpdateTime == null) {
                logger.debug("No device {} in SG {}, deletion invalid", (Object)deviceId, (Object)this.storageGroupName);
                return;
            }
            long timePartitionId = StorageEngine.getTimePartition(timestamp);
            this.logDeletion(timestamp, deviceId, measurementId, timePartitionId);
            Path fullPath = new Path(deviceId, measurementId);
            Deletion deletion = new Deletion(fullPath, this.getVersionControllerByTimePartitionId(timePartitionId).nextVersion(), timestamp);
            if (this.mergingModification != null) {
                this.mergingModification.write(deletion);
                updatedModFiles.add(this.mergingModification);
            }
            this.deleteDataInFiles(this.sequenceFileTreeSet, deletion, updatedModFiles);
            this.deleteDataInFiles(this.unSequenceFileList, deletion, updatedModFiles);
        }
        catch (Exception e) {
            for (ModificationFile modificationFile : updatedModFiles) {
                modificationFile.abort();
            }
            throw new IOException(e);
        }
        finally {
            this.writeUnlock();
            this.mergeLock.writeLock().unlock();
        }
    }

    private void logDeletion(long timestamp, String deviceId, String measurementId, long timePartitionId) throws IOException {
        if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
            DeletePlan deletionPlan = new DeletePlan(timestamp, new Path(deviceId, measurementId));
            for (Map.Entry<Long, TsFileProcessor> entry : this.workSequenceTsFileProcessors.entrySet()) {
                if (entry.getKey() > timePartitionId) continue;
                entry.getValue().getLogNode().write(deletionPlan);
            }
            for (Map.Entry<Long, TsFileProcessor> entry : this.workUnsequenceTsFileProcessors.entrySet()) {
                if (entry.getKey() > timePartitionId) continue;
                entry.getValue().getLogNode().write(deletionPlan);
            }
        }
    }

    private void deleteDataInFiles(Collection<TsFileResource> tsFileResourceList, Deletion deletion, List<ModificationFile> updatedModFiles) throws IOException {
        String deviceId = deletion.getDevice();
        for (TsFileResource tsFileResource : tsFileResourceList) {
            if (!tsFileResource.containsDevice(deviceId) || deletion.getTimestamp() < tsFileResource.getStartTime(deviceId)) continue;
            long partitionId = tsFileResource.getTimePartition();
            deletion.setVersionNum(this.getVersionControllerByTimePartitionId(partitionId).nextVersion());
            tsFileResource.getModFile().write(deletion);
            tsFileResource.getModFile().close();
            if (!tsFileResource.isClosed()) {
                TsFileProcessor tsfileProcessor = tsFileResource.getUnsealedFileProcessor();
                tsfileProcessor.deleteDataInMemory(deletion);
            }
            updatedModFiles.add(tsFileResource.getModFile());
        }
    }

    private void updateEndTimeMap(TsFileProcessor tsFileProcessor) {
        TsFileResource resource = tsFileProcessor.getTsFileResource();
        for (Map.Entry<String, Integer> startTime : resource.getDeviceToIndexMap().entrySet()) {
            String deviceId = startTime.getKey();
            resource.forceUpdateEndTime(deviceId, this.latestTimeForEachDevice.get(tsFileProcessor.getTimeRangeId()).get(deviceId));
        }
    }

    private boolean unsequenceFlushCallback(TsFileProcessor processor) {
        return true;
    }

    private boolean updateLatestFlushTimeCallback(TsFileProcessor processor) {
        Map<String, Long> curPartitionDeviceLatestTime = this.latestTimeForEachDevice.get(processor.getTimeRangeId());
        if (curPartitionDeviceLatestTime == null) {
            logger.warn("Partition: {} does't have latest time for each device. No valid record is written into memtable. Flushing tsfile is: {}", (Object)processor.getTimeRangeId(), (Object)processor.getTsFileResource().getFile());
            return false;
        }
        for (Map.Entry<String, Long> entry : curPartitionDeviceLatestTime.entrySet()) {
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(processor.getTimeRangeId(), id -> new HashMap()).put(entry.getKey(), entry.getValue());
            this.updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(processor.getTimeRangeId(), entry.getKey(), entry.getValue());
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(entry.getKey(), Long.MIN_VALUE) >= entry.getValue()) continue;
            this.globalLatestFlushedTimeForEachDevice.put(entry.getKey(), entry.getValue());
        }
        return true;
    }

    public void updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(long partitionId, String deviceId, long time) {
        this.newlyFlushedPartitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, id -> new HashMap()).compute(deviceId, (k, v) -> v == null ? time : Math.max(v, time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnsealedTsFileProcessorCallBack(TsFileProcessor tsFileProcessor) throws TsFileProcessorException {
        this.closeQueryLock.writeLock().lock();
        try {
            tsFileProcessor.close();
        }
        finally {
            this.closeQueryLock.writeLock().unlock();
        }
        if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor)) {
            this.closingSequenceTsFileProcessor.remove(tsFileProcessor);
        } else {
            this.closingUnSequenceTsFileProcessor.remove(tsFileProcessor);
        }
        logger.info("signal closing storage group condition in {}", (Object)this.storageGroupName);
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            this.closeStorageGroupCondition.notifyAll();
        }
    }

    public int countUpgradeFiles() {
        return this.upgradeSeqFileList.size() + this.upgradeUnseqFileList.size();
    }

    public void upgrade() {
        for (TsFileResource seqTsFileResource : this.upgradeSeqFileList) {
            seqTsFileResource.setSeq(true);
            seqTsFileResource.setUpgradeTsFileResourceCallBack(this::upgradeTsFileResourceCallBack);
            seqTsFileResource.doUpgrade();
        }
        for (TsFileResource unseqTsFileResource : this.upgradeUnseqFileList) {
            unseqTsFileResource.setSeq(false);
            unseqTsFileResource.setUpgradeTsFileResourceCallBack(this::upgradeTsFileResourceCallBack);
            unseqTsFileResource.doUpgrade();
        }
    }

    private void upgradeTsFileResourceCallBack(TsFileResource tsFileResource) {
        List<TsFileResource> upgradedResources = tsFileResource.getUpgradedResources();
        for (TsFileResource tsFileResource2 : upgradedResources) {
            long partitionId = tsFileResource2.getTimePartition();
            tsFileResource2.getDeviceToIndexMap().forEach((device, index) -> this.updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(partitionId, (String)device, resource.getEndTime((int)index)));
        }
        this.insertLock.writeLock().lock();
        this.mergeLock.writeLock().lock();
        if (tsFileResource.isSeq()) {
            this.sequenceFileTreeSet.addAll(upgradedResources);
            this.upgradeSeqFileList.remove(tsFileResource);
        } else {
            this.unSequenceFileList.addAll(upgradedResources);
            this.upgradeUnseqFileList.remove(tsFileResource);
        }
        this.mergeLock.writeLock().unlock();
        this.insertLock.writeLock().unlock();
        if (this.countUpgradeFiles() == 0) {
            for (Map.Entry entry : this.newlyFlushedPartitionLatestFlushedTimeForEachDevice.entrySet()) {
                long timePartitionId = (Long)entry.getKey();
                Map latestFlushTimeForPartition = this.partitionLatestFlushedTimeForEachDevice.getOrDefault(timePartitionId, new HashMap());
                for (Map.Entry endTimeMap : ((Map)entry.getValue()).entrySet()) {
                    String device2 = (String)endTimeMap.getKey();
                    long endTime = (Long)endTimeMap.getValue();
                    if (latestFlushTimeForPartition.getOrDefault(device2, Long.MIN_VALUE) >= endTime) continue;
                    this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).put(device2, endTime);
                }
            }
            UpgradeSevice.getINSTANCE().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(boolean fullMerge) {
        this.writeLock();
        try {
            List[] mergeFiles;
            IMergeFileSelector fileSelector;
            MergeResource mergeResource;
            block15: {
                if (this.isMerging) {
                    if (logger.isInfoEnabled()) {
                        logger.info("{} Last merge is ongoing, currently consumed time: {}ms", (Object)this.storageGroupName, (Object)(System.currentTimeMillis() - this.mergeStartTime));
                    }
                    return;
                }
                logger.info("{} will close all files for starting a merge (fullmerge = {})", (Object)this.storageGroupName, (Object)fullMerge);
                if (this.unSequenceFileList.isEmpty() || this.sequenceFileTreeSet.isEmpty()) {
                    logger.info("{} no files to be merged", (Object)this.storageGroupName);
                    return;
                }
                long budget = IoTDBDescriptor.getInstance().getConfig().getMergeMemoryBudget();
                long timeLowerBound = System.currentTimeMillis() - this.dataTTL;
                mergeResource = new MergeResource(this.sequenceFileTreeSet, this.unSequenceFileList, timeLowerBound);
                fileSelector = this.getMergeFileSelector(budget, mergeResource);
                mergeFiles = fileSelector.select();
                if (mergeFiles.length != 0) break block15;
                logger.info("{} cannot select merge candidates under the budget {}", (Object)this.storageGroupName, (Object)budget);
                return;
            }
            try {
                mergeResource.clear();
                String taskName = this.storageGroupName + "-" + System.currentTimeMillis();
                mergeResource.setCacheDeviceMeta(true);
                for (TsFileResource tsFileResource : mergeResource.getSeqFiles()) {
                    tsFileResource.setMerging(true);
                }
                for (TsFileResource tsFileResource : mergeResource.getUnseqFiles()) {
                    tsFileResource.setMerging(true);
                }
                MergeTask mergeTask = new MergeTask(mergeResource, this.storageGroupSysDir.getPath(), this::mergeEndAction, taskName, fullMerge, fileSelector.getConcurrentMergeNum(), this.storageGroupName);
                this.mergingModification = new ModificationFile(this.storageGroupSysDir + File.separator + MERGING_MODIFICATION_FILE_NAME);
                MergeManager.getINSTANCE().submitMainTask(mergeTask);
                if (logger.isInfoEnabled()) {
                    logger.info("{} submits a merge task {}, merging {} seqFiles, {} unseqFiles", new Object[]{this.storageGroupName, taskName, mergeFiles[0].size(), mergeFiles[1].size()});
                }
                this.isMerging = true;
                this.mergeStartTime = System.currentTimeMillis();
            }
            catch (IOException | MergeException e) {
                logger.error("{} cannot select file for merge", (Object)this.storageGroupName, (Object)e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private IMergeFileSelector getMergeFileSelector(long budget, MergeResource resource) {
        MergeFileStrategy strategy = IoTDBDescriptor.getInstance().getConfig().getMergeFileStrategy();
        switch (strategy) {
            case MAX_FILE_NUM: {
                return new MaxFileMergeFileSelector(resource, budget);
            }
            case MAX_SERIES_NUM: {
                return new MaxSeriesMergeFileSelector(resource, budget);
            }
        }
        throw new UnsupportedOperationException("Unknown MergeFileStrategy " + (Object)((Object)strategy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnseqFiles(List<TsFileResource> unseqFiles) {
        this.mergeLock.writeLock().lock();
        try {
            this.unSequenceFileList.removeAll(unseqFiles);
        }
        finally {
            this.mergeLock.writeLock().unlock();
        }
        for (TsFileResource unseqFile : unseqFiles) {
            unseqFile.getWriteQueryLock().writeLock().lock();
            try {
                unseqFile.remove();
            }
            finally {
                unseqFile.getWriteQueryLock().writeLock().unlock();
            }
        }
    }

    private void updateMergeModification(TsFileResource seqFile) {
        try {
            seqFile.removeModFile();
            if (this.mergingModification != null) {
                for (Modification modification : this.mergingModification.getModifications()) {
                    seqFile.getModFile().write(modification);
                }
                try {
                    seqFile.getModFile().close();
                }
                catch (IOException e) {
                    logger.error("Cannot close the ModificationFile {}", (Object)seqFile.getModFile().getFilePath(), (Object)e);
                }
            }
        }
        catch (IOException e) {
            logger.error("{} cannot clean the ModificationFile of {} after merge", new Object[]{this.storageGroupName, seqFile.getFile(), e});
        }
    }

    private void removeMergingModification() {
        try {
            if (this.mergingModification != null) {
                this.mergingModification.remove();
                this.mergingModification = null;
            }
        }
        catch (IOException e) {
            logger.error("{} cannot remove merging modification ", (Object)this.storageGroupName, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeEndAction(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, File mergeLog) {
        logger.info("{} a merge task is ending...", (Object)this.storageGroupName);
        if (unseqFiles.isEmpty()) {
            this.isMerging = false;
            logger.info("{} a merge task abnormally ends", (Object)this.storageGroupName);
            return;
        }
        this.removeUnseqFiles(unseqFiles);
        for (int i = 0; i < seqFiles.size(); ++i) {
            TsFileResource seqFile = seqFiles.get(i);
            while (!seqFile.getWriteQueryLock().writeLock().tryLock() || !this.mergeLock.writeLock().tryLock()) {
                if (seqFile.getWriteQueryLock().writeLock().isHeldByCurrentThread()) {
                    seqFile.getWriteQueryLock().writeLock().unlock();
                }
                if (!this.mergeLock.writeLock().isHeldByCurrentThread()) continue;
                this.mergeLock.writeLock().unlock();
            }
            try {
                this.updateMergeModification(seqFile);
                if (i != seqFiles.size() - 1) continue;
                this.removeMergingModification();
                this.isMerging = false;
                mergeLog.delete();
                continue;
            }
            finally {
                this.mergeLock.writeLock().unlock();
                seqFile.getWriteQueryLock().writeLock().unlock();
            }
        }
        logger.info("{} a merge task ends", (Object)this.storageGroupName);
    }

    public void loadNewTsFileForSync(TsFileResource newTsFileResource) throws LoadFileException {
        File tsfileToBeInserted = newTsFileResource.getFile();
        long newFilePartitionId = newTsFileResource.getTimePartitionWithCheck();
        this.writeLock();
        this.mergeLock.writeLock().lock();
        try {
            if (this.loadTsFileByType(LoadTsFileType.LOAD_SEQUENCE, tsfileToBeInserted, newTsFileResource, newFilePartitionId)) {
                this.updateLatestTimeMap(newTsFileResource);
            }
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Failed to append the tsfile {} to storage group processor {} because the disk space is insufficient.", (Object)tsfileToBeInserted.getAbsolutePath(), (Object)tsfileToBeInserted.getParentFile().getName());
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
            throw new LoadFileException(e);
        }
        finally {
            this.mergeLock.writeLock().unlock();
            this.writeUnlock();
        }
    }

    public void loadNewTsFile(TsFileResource newTsFileResource) throws LoadFileException {
        File tsfileToBeInserted = newTsFileResource.getFile();
        long newFilePartitionId = newTsFileResource.getTimePartitionWithCheck();
        this.writeLock();
        this.mergeLock.writeLock().lock();
        try {
            ArrayList<TsFileResource> sequenceList = new ArrayList<TsFileResource>(this.sequenceFileTreeSet);
            int insertPos = this.findInsertionPosition(newTsFileResource, newFilePartitionId, sequenceList);
            if (insertPos == -2) {
                return;
            }
            if (insertPos == -3) {
                this.loadTsFileByType(LoadTsFileType.LOAD_UNSEQUENCE, tsfileToBeInserted, newTsFileResource, newFilePartitionId);
            } else {
                String newFileName;
                if (!this.sequenceFileTreeSet.isEmpty() && !(newFileName = this.getFileNameForLoadingFile(tsfileToBeInserted.getName(), insertPos, newTsFileResource.getTimePartition(), sequenceList)).equals(tsfileToBeInserted.getName())) {
                    logger.info("Tsfile {} must be renamed to {} for loading into the sequence list.", (Object)tsfileToBeInserted.getName(), (Object)newFileName);
                    newTsFileResource.setFile(new File(tsfileToBeInserted.getParentFile(), newFileName));
                }
                this.loadTsFileByType(LoadTsFileType.LOAD_SEQUENCE, tsfileToBeInserted, newTsFileResource, newFilePartitionId);
            }
            this.updateLatestTimeMap(newTsFileResource);
            long partitionNum = newTsFileResource.getTimePartition();
            this.partitionDirectFileVersions.computeIfAbsent(partitionNum, p -> new HashSet()).addAll(newTsFileResource.getHistoricalVersions());
            this.updatePartitionFileVersion(partitionNum, Collections.max(newTsFileResource.getHistoricalVersions()));
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Failed to append the tsfile {} to storage group processor {} because the disk space is insufficient.", (Object)tsfileToBeInserted.getAbsolutePath(), (Object)tsfileToBeInserted.getParentFile().getName());
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
            throw new LoadFileException(e);
        }
        finally {
            this.mergeLock.writeLock().unlock();
            this.writeUnlock();
        }
    }

    private int findInsertionPosition(TsFileResource newTsFileResource, long newFilePartitionId, List<TsFileResource> sequenceList) {
        File tsfileToBeInserted = newTsFileResource.getFile();
        int insertPos = -1;
        for (int i = 0; i < sequenceList.size(); ++i) {
            TsFileResource localFile = sequenceList.get(i);
            if (localFile.getFile().getName().equals(tsfileToBeInserted.getName())) {
                return -2;
            }
            long localPartitionId = Long.parseLong(localFile.getFile().getParentFile().getName());
            if (i == sequenceList.size() - 1 && localFile.areEndTimesEmpty() || newFilePartitionId > localPartitionId) continue;
            int fileComparison = this.compareTsFileDevices(newTsFileResource, localFile);
            switch (fileComparison) {
                case 0: {
                    return -3;
                }
                case -1: {
                    return i - 1;
                }
            }
            insertPos = i;
        }
        return insertPos;
    }

    private int compareTsFileDevices(TsFileResource fileA, TsFileResource fileB) {
        boolean hasPre = false;
        boolean hasSubsequence = false;
        for (String device : fileA.getDeviceToIndexMap().keySet()) {
            if (!fileB.getDeviceToIndexMap().containsKey(device)) continue;
            long startTimeA = fileA.getStartTime(device);
            long endTimeA = fileA.getEndTime(device);
            long startTimeB = fileB.getStartTime(device);
            long endTimeB = fileB.getEndTime(device);
            if (startTimeA > endTimeB) {
                hasPre = true;
                continue;
            }
            if (startTimeB > endTimeA) {
                hasSubsequence = true;
                continue;
            }
            return 0;
        }
        if (hasPre && hasSubsequence) {
            return 0;
        }
        if (!hasPre && hasSubsequence) {
            return -1;
        }
        return 1;
    }

    public void removeFullyOverlapFiles(TsFileResource resource) {
        this.writeLock();
        this.closeQueryLock.writeLock().lock();
        try {
            Iterator<TsFileResource> iterator = this.sequenceFileTreeSet.iterator();
            this.removeFullyOverlapFiles(resource, iterator);
            iterator = this.unSequenceFileList.iterator();
            this.removeFullyOverlapFiles(resource, iterator);
        }
        finally {
            this.closeQueryLock.writeLock().unlock();
            this.writeUnlock();
        }
    }

    private void removeFullyOverlapFiles(TsFileResource resource, Iterator<TsFileResource> iterator) {
        while (iterator.hasNext()) {
            TsFileResource seqFile = iterator.next();
            if (!resource.getHistoricalVersions().containsAll(seqFile.getHistoricalVersions()) || resource.getHistoricalVersions().equals(seqFile.getHistoricalVersions()) || !seqFile.getWriteQueryLock().writeLock().tryLock()) continue;
            try {
                iterator.remove();
                seqFile.remove();
            }
            catch (Exception e) {
                logger.error("Something gets wrong while removing FullyOverlapFiles ", (Throwable)e);
                throw e;
            }
            finally {
                seqFile.getWriteQueryLock().writeLock().unlock();
            }
        }
    }

    private String getFileNameForLoadingFile(String tsfileName, int insertIndex, long timePartitionId, List<TsFileResource> sequenceList) {
        long preTime;
        long currentTsFileTime = Long.parseLong(tsfileName.split("-")[0]);
        if (insertIndex == -1) {
            preTime = 0L;
        } else {
            String preName = sequenceList.get(insertIndex).getFile().getName();
            preTime = Long.parseLong(preName.split("-")[0]);
        }
        if (insertIndex == this.sequenceFileTreeSet.size() - 1) {
            return preTime < currentTsFileTime ? tsfileName : this.getNewTsFileName(timePartitionId);
        }
        String subsequenceName = sequenceList.get(insertIndex + 1).getFile().getName();
        long subsequenceTime = Long.parseLong(subsequenceName.split("-")[0]);
        long subsequenceVersion = Long.parseLong(subsequenceName.split("-")[1]);
        if (preTime < currentTsFileTime && currentTsFileTime < subsequenceTime) {
            return tsfileName;
        }
        return this.getNewTsFileName(preTime + (subsequenceTime - preTime >> 1), subsequenceVersion, 0);
    }

    private void updateLatestTimeMap(TsFileResource newTsFileResource) {
        for (Map.Entry<String, Integer> entry : newTsFileResource.getDeviceToIndexMap().entrySet()) {
            Map latestFlushTimeForPartition;
            String device = entry.getKey();
            int index = entry.getValue();
            long endTime = newTsFileResource.getEndTime(index);
            long timePartitionId = StorageEngine.getTimePartition(endTime);
            if (!this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).containsKey(device) || this.latestTimeForEachDevice.get(timePartitionId).get(device) < endTime) {
                this.latestTimeForEachDevice.get(timePartitionId).put(device, endTime);
            }
            if ((latestFlushTimeForPartition = (Map)this.partitionLatestFlushedTimeForEachDevice.getOrDefault(timePartitionId, new HashMap())).getOrDefault(device, Long.MIN_VALUE) < endTime) {
                this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).put(device, endTime);
            }
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(device, Long.MIN_VALUE) >= endTime) continue;
            this.globalLatestFlushedTimeForEachDevice.put(device, endTime);
        }
    }

    private boolean loadTsFileByType(LoadTsFileType type, File syncedTsFile, TsFileResource tsFileResource, long filePartitionId) throws LoadFileException, DiskSpaceInsufficientException {
        File targetFile;
        switch (type) {
            case LOAD_UNSEQUENCE: {
                targetFile = new File(DirectoryManager.getInstance().getNextFolderForUnSequenceFile(), this.storageGroupName + File.separatorChar + filePartitionId + File.separator + tsFileResource.getFile().getName());
                tsFileResource.setFile(targetFile);
                if (this.unSequenceFileList.contains(tsFileResource)) {
                    logger.error("The file {} has already been loaded in unsequence list", (Object)tsFileResource);
                    return false;
                }
                this.unSequenceFileList.add(tsFileResource);
                logger.info("Load tsfile in unsequence list, move file from {} to {}", (Object)syncedTsFile.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
                break;
            }
            case LOAD_SEQUENCE: {
                targetFile = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile(), this.storageGroupName + File.separatorChar + filePartitionId + File.separator + tsFileResource.getFile().getName());
                tsFileResource.setFile(targetFile);
                if (this.sequenceFileTreeSet.contains(tsFileResource)) {
                    logger.error("The file {} has already been loaded in sequence list", (Object)tsFileResource);
                    return false;
                }
                this.sequenceFileTreeSet.add(tsFileResource);
                logger.info("Load tsfile in sequence list, move file from {} to {}", (Object)syncedTsFile.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
                break;
            }
            default: {
                throw new LoadFileException(String.format("Unsupported type of loading tsfile : %s", new Object[]{type}));
            }
        }
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        try {
            org.apache.commons.io.FileUtils.moveFile((File)syncedTsFile, (File)targetFile);
        }
        catch (IOException e) {
            logger.error("File renaming failed when loading tsfile. Origin: {}, Target: {}", new Object[]{syncedTsFile.getAbsolutePath(), targetFile.getAbsolutePath(), e});
            throw new LoadFileException(String.format("File renaming failed when loading tsfile. Origin: %s, Target: %s, because %s", syncedTsFile.getAbsolutePath(), targetFile.getAbsolutePath(), e.getMessage()));
        }
        File syncedResourceFile = new File(syncedTsFile.getAbsolutePath() + ".resource");
        File targetResourceFile = new File(targetFile.getAbsolutePath() + ".resource");
        try {
            org.apache.commons.io.FileUtils.moveFile((File)syncedResourceFile, (File)targetResourceFile);
        }
        catch (IOException e) {
            logger.error("File renaming failed when loading .resource file. Origin: {}, Target: {}", new Object[]{syncedResourceFile.getAbsolutePath(), targetResourceFile.getAbsolutePath(), e});
            throw new LoadFileException(String.format("File renaming failed when loading .resource file. Origin: %s, Target: %s, because %s", syncedResourceFile.getAbsolutePath(), targetResourceFile.getAbsolutePath(), e.getMessage()));
        }
        this.partitionDirectFileVersions.computeIfAbsent(filePartitionId, p -> new HashSet()).addAll(tsFileResource.getHistoricalVersions());
        this.updatePartitionFileVersion(filePartitionId, Collections.max(tsFileResource.getHistoricalVersions()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTsfile(File tsfieToBeDeleted) {
        TsFileResource tsFileResourceToBeDeleted;
        block9: {
            this.writeLock();
            this.mergeLock.writeLock().lock();
            tsFileResourceToBeDeleted = null;
            try {
                Iterator<TsFileResource> sequenceIterator = this.sequenceFileTreeSet.iterator();
                while (sequenceIterator.hasNext()) {
                    TsFileResource sequenceResource = sequenceIterator.next();
                    if (!sequenceResource.getFile().getName().equals(tsfieToBeDeleted.getName())) continue;
                    tsFileResourceToBeDeleted = sequenceResource;
                    sequenceIterator.remove();
                    break;
                }
                if (tsFileResourceToBeDeleted != null) break block9;
                Iterator<TsFileResource> unsequenceIterator = this.unSequenceFileList.iterator();
                while (unsequenceIterator.hasNext()) {
                    TsFileResource unsequenceResource = unsequenceIterator.next();
                    if (!unsequenceResource.getFile().getName().equals(tsfieToBeDeleted.getName())) continue;
                    tsFileResourceToBeDeleted = unsequenceResource;
                    unsequenceIterator.remove();
                    break;
                }
            }
            finally {
                this.mergeLock.writeLock().unlock();
                this.writeUnlock();
            }
        }
        if (tsFileResourceToBeDeleted == null) {
            return false;
        }
        tsFileResourceToBeDeleted.getWriteQueryLock().writeLock().lock();
        try {
            tsFileResourceToBeDeleted.remove();
            logger.info("Delete tsfile {} successfully.", (Object)tsFileResourceToBeDeleted.getFile());
        }
        finally {
            tsFileResourceToBeDeleted.getWriteQueryLock().writeLock().unlock();
        }
        return true;
    }

    public Collection<TsFileProcessor> getWorkSequenceTsFileProcessors() {
        return this.workSequenceTsFileProcessors.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveTsfile(File fileToBeMoved, File targetDir) throws IOException {
        TsFileResource tsFileResourceToBeMoved;
        block9: {
            this.writeLock();
            this.mergeLock.writeLock().lock();
            tsFileResourceToBeMoved = null;
            try {
                Iterator<TsFileResource> sequenceIterator = this.sequenceFileTreeSet.iterator();
                while (sequenceIterator.hasNext()) {
                    TsFileResource sequenceResource = sequenceIterator.next();
                    if (!sequenceResource.getFile().getName().equals(fileToBeMoved.getName())) continue;
                    tsFileResourceToBeMoved = sequenceResource;
                    sequenceIterator.remove();
                    break;
                }
                if (tsFileResourceToBeMoved != null) break block9;
                Iterator<TsFileResource> unsequenceIterator = this.unSequenceFileList.iterator();
                while (unsequenceIterator.hasNext()) {
                    TsFileResource unsequenceResource = unsequenceIterator.next();
                    if (!unsequenceResource.getFile().getName().equals(fileToBeMoved.getName())) continue;
                    tsFileResourceToBeMoved = unsequenceResource;
                    unsequenceIterator.remove();
                    break;
                }
            }
            finally {
                this.mergeLock.writeLock().unlock();
                this.writeUnlock();
            }
        }
        if (tsFileResourceToBeMoved == null) {
            return false;
        }
        tsFileResourceToBeMoved.getWriteQueryLock().writeLock().lock();
        try {
            tsFileResourceToBeMoved.moveTo(targetDir);
            logger.info("Move tsfile {} to target dir {} successfully.", (Object)tsFileResourceToBeMoved.getFile(), (Object)targetDir.getPath());
        }
        finally {
            tsFileResourceToBeMoved.getWriteQueryLock().writeLock().unlock();
        }
        return true;
    }

    public Collection<TsFileProcessor> getWorkUnsequenceTsFileProcessor() {
        return this.workUnsequenceTsFileProcessors.values();
    }

    public void setDataTTL(long dataTTL) {
        this.dataTTL = dataTTL;
        this.checkFilesTTL();
    }

    public List<TsFileResource> getSequenceFileTreeSet() {
        return new ArrayList<TsFileResource>(this.sequenceFileTreeSet);
    }

    public List<TsFileResource> getUnSequenceFileList() {
        return this.unSequenceFileList;
    }

    public String getStorageGroupName() {
        return this.storageGroupName;
    }

    public boolean isFileAlreadyExist(TsFileResource tsFileResource, long partitionNum) {
        return this.partitionDirectFileVersions.getOrDefault(partitionNum, Collections.emptySet()).containsAll(tsFileResource.getHistoricalVersions());
    }

    @FunctionalInterface
    public static interface UpgradeTsFileResourceCallBack {
        public void call(TsFileResource var1);
    }

    @FunctionalInterface
    public static interface UpdateEndTimeCallBack {
        public boolean call(TsFileProcessor var1);
    }

    @FunctionalInterface
    public static interface CloseTsFileCallBack {
        public void call(TsFileProcessor var1) throws TsFileProcessorException, IOException;
    }

    private static enum LoadTsFileType {
        LOAD_SEQUENCE,
        LOAD_UNSEQUENCE;

    }
}

