/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.selector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.selector.IFileQueryMemMeasurement;
import org.apache.iotdb.db.engine.merge.selector.IMergeFileSelector;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.db.utils.MergeUtils;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxFileMergeFileSelector
implements IMergeFileSelector {
    private static final Logger logger = LoggerFactory.getLogger(MaxFileMergeFileSelector.class);
    private static final String LOG_FILE_COST = "Memory cost of file {} is {}";
    MergeResource resource;
    long totalCost;
    private long memoryBudget;
    private long maxSeqFileCost;
    int concurrentMergeNum = 1;
    private Map<TsFileResource, Long> fileMetaSizeMap = new HashMap<TsFileResource, Long>();
    private Map<TsFileResource, Long> maxSeriesQueryCostMap = new HashMap<TsFileResource, Long>();
    List<TsFileResource> selectedUnseqFiles;
    List<TsFileResource> selectedSeqFiles;
    private Collection<Integer> tmpSelectedSeqFiles;
    private long tempMaxSeqFileCost;
    private boolean[] seqSelected;
    private int seqSelectedNum;

    public MaxFileMergeFileSelector(MergeResource resource, long memoryBudget) {
        this.resource = resource;
        this.memoryBudget = memoryBudget;
    }

    @Override
    public List[] select() throws MergeException {
        long startTime = System.currentTimeMillis();
        try {
            logger.info("Selecting merge candidates from {} seqFile, {} unseqFiles", (Object)this.resource.getSeqFiles().size(), (Object)this.resource.getUnseqFiles().size());
            this.select(false);
            if (this.selectedUnseqFiles.isEmpty()) {
                this.select(true);
            }
            this.resource.setSeqFiles(this.selectedSeqFiles);
            this.resource.setUnseqFiles(this.selectedUnseqFiles);
            this.resource.removeOutdatedSeqReaders();
            if (this.selectedUnseqFiles.isEmpty()) {
                logger.info("No merge candidates are found");
                return new List[0];
            }
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Selected merge candidates, {} seqFiles, {} unseqFiles, total memory cost {}, time consumption {}ms", new Object[]{this.selectedSeqFiles.size(), this.selectedUnseqFiles.size(), this.totalCost, System.currentTimeMillis() - startTime});
        }
        return new List[]{this.selectedSeqFiles, this.selectedUnseqFiles};
    }

    void select(boolean useTightBound) throws IOException {
        this.tmpSelectedSeqFiles = new HashSet<Integer>();
        this.seqSelected = new boolean[this.resource.getSeqFiles().size()];
        this.seqSelectedNum = 0;
        this.selectedSeqFiles = new ArrayList<TsFileResource>();
        this.selectedUnseqFiles = new ArrayList<TsFileResource>();
        this.maxSeqFileCost = 0L;
        this.tempMaxSeqFileCost = 0L;
        this.totalCost = 0L;
        int unseqIndex = 0;
        long startTime = System.currentTimeMillis();
        long timeConsumption = 0L;
        long timeLimit = IoTDBDescriptor.getInstance().getConfig().getMergeFileSelectionTimeBudget();
        if (timeLimit < 0L) {
            timeLimit = Long.MAX_VALUE;
        }
        while (unseqIndex < this.resource.getUnseqFiles().size() && timeConsumption < timeLimit) {
            boolean isClosed;
            TsFileResource unseqFile = this.resource.getUnseqFiles().get(unseqIndex);
            if (this.seqSelectedNum != this.resource.getSeqFiles().size() && !UpgradeUtils.isNeedUpgrade(unseqFile)) {
                this.selectOverlappedSeqFiles(unseqFile);
            }
            if (!(isClosed = this.checkClosed(unseqFile))) {
                this.tmpSelectedSeqFiles.clear();
                ++unseqIndex;
                timeConsumption = System.currentTimeMillis() - startTime;
                continue;
            }
            this.tempMaxSeqFileCost = this.maxSeqFileCost;
            long newCost = useTightBound ? this.calculateTightMemoryCost(unseqFile, this.tmpSelectedSeqFiles, startTime, timeLimit) : this.calculateLooseMemoryCost(unseqFile, this.tmpSelectedSeqFiles, startTime, timeLimit);
            this.updateSelectedFiles(newCost, unseqFile);
            this.tmpSelectedSeqFiles.clear();
            ++unseqIndex;
            timeConsumption = System.currentTimeMillis() - startTime;
        }
        for (int i = 0; i < this.seqSelected.length; ++i) {
            if (!this.seqSelected[i]) continue;
            this.selectedSeqFiles.add(this.resource.getSeqFiles().get(i));
        }
    }

    private void updateSelectedFiles(long newCost, TsFileResource unseqFile) {
        if (this.totalCost + newCost < this.memoryBudget) {
            this.selectedUnseqFiles.add(unseqFile);
            this.maxSeqFileCost = this.tempMaxSeqFileCost;
            for (Integer seqIdx : this.tmpSelectedSeqFiles) {
                this.seqSelected[seqIdx.intValue()] = true;
                ++this.seqSelectedNum;
            }
            this.totalCost += newCost;
            logger.debug("Adding a new unseqFile {} and seqFiles {} as candidates, new cost {}, total cost {}", new Object[]{unseqFile, this.tmpSelectedSeqFiles, newCost, this.totalCost});
        }
    }

    private boolean checkClosed(TsFileResource unseqFile) {
        boolean isClosed = unseqFile.isClosed();
        if (!isClosed) {
            return false;
        }
        for (Integer seqIdx : this.tmpSelectedSeqFiles) {
            if (this.resource.getSeqFiles().get(seqIdx).isClosed()) continue;
            isClosed = false;
            break;
        }
        return isClosed;
    }

    private void selectOverlappedSeqFiles(TsFileResource unseqFile) {
        int tmpSelectedNum = 0;
        for (Map.Entry<String, Integer> deviceStartTimeEntry : unseqFile.getDeviceToIndexMap().entrySet()) {
            String deviceId = deviceStartTimeEntry.getKey();
            int deviceIndex = deviceStartTimeEntry.getValue();
            long unseqStartTime = unseqFile.getStartTime(deviceIndex);
            long unseqEndTime = unseqFile.getEndTime(deviceIndex);
            boolean noMoreOverlap = false;
            for (int i = 0; i < this.resource.getSeqFiles().size() && !noMoreOverlap; ++i) {
                TsFileResource seqFile = this.resource.getSeqFiles().get(i);
                if (this.seqSelected[i] || !seqFile.getDeviceToIndexMap().containsKey(deviceId)) continue;
                long seqEndTime = seqFile.getEndTime(deviceId);
                if (unseqEndTime <= seqEndTime) {
                    this.tmpSelectedSeqFiles.add(i);
                    ++tmpSelectedNum;
                    noMoreOverlap = true;
                    continue;
                }
                if (unseqStartTime > seqEndTime) continue;
                this.tmpSelectedSeqFiles.add(i);
                ++tmpSelectedNum;
            }
            if (tmpSelectedNum + this.seqSelectedNum != this.resource.getSeqFiles().size()) continue;
            break;
        }
    }

    private long calculateMemoryCost(TsFileResource tmpSelectedUnseqFile, Collection<Integer> tmpSelectedSeqFiles, IFileQueryMemMeasurement unseqMeasurement, IFileQueryMemMeasurement seqMeasurement, long startTime, long timeLimit) throws IOException {
        long cost = 0L;
        Long fileCost = unseqMeasurement.measure(tmpSelectedUnseqFile);
        cost += fileCost.longValue();
        for (Integer seqFileIdx : tmpSelectedSeqFiles) {
            TsFileResource seqFile = this.resource.getSeqFiles().get(seqFileIdx);
            fileCost = seqMeasurement.measure(seqFile);
            if (fileCost > this.tempMaxSeqFileCost) {
                cost -= this.tempMaxSeqFileCost;
                cost += fileCost.longValue();
                this.tempMaxSeqFileCost = fileCost;
            }
            cost += this.calculateMetadataSize(seqFile);
            long timeConsumption = System.currentTimeMillis() - startTime;
            if (timeConsumption <= timeLimit) continue;
            return Long.MAX_VALUE;
        }
        return cost;
    }

    private long calculateLooseMemoryCost(TsFileResource tmpSelectedUnseqFile, Collection<Integer> tmpSelectedSeqFiles, long startTime, long timeLimit) throws IOException {
        return this.calculateMemoryCost(tmpSelectedUnseqFile, tmpSelectedSeqFiles, TsFileResource::getFileSize, this::calculateMetadataSize, startTime, timeLimit);
    }

    private long calculateTightMemoryCost(TsFileResource tmpSelectedUnseqFile, Collection<Integer> tmpSelectedSeqFiles, long startTime, long timeLimit) throws IOException {
        return this.calculateMemoryCost(tmpSelectedUnseqFile, tmpSelectedSeqFiles, this::calculateTightUnseqMemoryCost, this::calculateTightSeqMemoryCost, startTime, timeLimit);
    }

    private long calculateMetadataSize(TsFileResource seqFile) throws IOException {
        Long cost = this.fileMetaSizeMap.get(seqFile);
        if (cost == null) {
            cost = MergeUtils.getFileMetaSize(seqFile, this.resource.getFileReader(seqFile));
            this.fileMetaSizeMap.put(seqFile, cost);
            logger.debug(LOG_FILE_COST, (Object)seqFile, (Object)cost);
        }
        return cost;
    }

    private long calculateTightFileMemoryCost(TsFileResource seqFile, IFileQueryMemMeasurement measurement) throws IOException {
        Long cost = this.maxSeriesQueryCostMap.get(seqFile);
        if (cost == null) {
            long[] chunkNums = MergeUtils.findTotalAndLargestSeriesChunkNum(seqFile, this.resource.getFileReader(seqFile));
            long totalChunkNum = chunkNums[0];
            long maxChunkNum = chunkNums[1];
            cost = measurement.measure(seqFile) * maxChunkNum / totalChunkNum;
            this.maxSeriesQueryCostMap.put(seqFile, cost);
            logger.debug(LOG_FILE_COST, (Object)seqFile, (Object)cost);
        }
        return cost;
    }

    private long calculateTightSeqMemoryCost(TsFileResource seqFile) throws IOException {
        long maxCost;
        long singleSeriesCost = this.calculateTightFileMemoryCost(seqFile, this::calculateMetadataSize);
        long multiSeriesCost = (long)this.concurrentMergeNum * singleSeriesCost;
        return multiSeriesCost > (maxCost = this.calculateMetadataSize(seqFile)) ? maxCost : multiSeriesCost;
    }

    private long calculateTightUnseqMemoryCost(TsFileResource unseqFile) throws IOException {
        long maxCost;
        long singleSeriesCost = this.calculateTightFileMemoryCost(unseqFile, TsFileResource::getFileSize);
        long multiSeriesCost = (long)this.concurrentMergeNum * singleSeriesCost;
        return multiSeriesCost > (maxCost = unseqFile.getFileSize()) ? maxCost : multiSeriesCost;
    }

    @Override
    public int getConcurrentMergeNum() {
        return this.concurrentMergeNum;
    }
}

