/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.rescon.TVListAllocator;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public abstract class AbstractMemTable
implements IMemTable {
    private final Map<String, Map<String, IWritableMemChunk>> memTableMap;
    private long version = Long.MAX_VALUE;
    private List<Modification> modifications = new ArrayList<Modification>();
    private int avgSeriesPointNumThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
    private long memSize = 0L;
    private int seriesNumber = 0;
    private long totalPointsNum = 0L;
    private long totalPointsNumThreshold = 0L;

    public AbstractMemTable() {
        this.memTableMap = new HashMap<String, Map<String, IWritableMemChunk>>();
    }

    public AbstractMemTable(Map<String, Map<String, IWritableMemChunk>> memTableMap) {
        this.memTableMap = memTableMap;
    }

    @Override
    public Map<String, Map<String, IWritableMemChunk>> getMemTableMap() {
        return this.memTableMap;
    }

    private boolean checkPath(String deviceId, String measurement) {
        return this.memTableMap.containsKey(deviceId) && this.memTableMap.get(deviceId).containsKey(measurement);
    }

    private IWritableMemChunk createIfNotExistAndGet(String deviceId, String measurement, MeasurementSchema schema) {
        Map<String, IWritableMemChunk> memSeries;
        if (!this.memTableMap.containsKey(deviceId)) {
            this.memTableMap.put(deviceId, new HashMap());
        }
        if (!(memSeries = this.memTableMap.get(deviceId)).containsKey(measurement)) {
            memSeries.put(measurement, this.genMemSeries(schema));
            ++this.seriesNumber;
            this.totalPointsNumThreshold += (long)this.avgSeriesPointNumThreshold;
        }
        return memSeries.get(measurement);
    }

    protected abstract IWritableMemChunk genMemSeries(MeasurementSchema var1);

    @Override
    public void insert(InsertPlan insertPlan) {
        for (int i = 0; i < insertPlan.getValues().length; ++i) {
            if (insertPlan.getValues()[i] == null) continue;
            Object value = insertPlan.getValues()[i];
            this.memSize += MemUtils.getRecordSize(insertPlan.getSchemas()[i].getType(), value);
            this.write(insertPlan.getDeviceId(), insertPlan.getMeasurements()[i], insertPlan.getSchemas()[i], insertPlan.getTime(), value);
        }
        this.totalPointsNum += (long)(insertPlan.getMeasurements().length - insertPlan.getFailedMeasurementNumber());
    }

    @Override
    public void insertTablet(InsertTabletPlan insertTabletPlan, int start, int end) throws WriteProcessException {
        try {
            this.write(insertTabletPlan, start, end);
            this.memSize += MemUtils.getRecordSize(insertTabletPlan, start, end);
            this.totalPointsNum += (long)(insertTabletPlan.getMeasurements().length * (end - start));
        }
        catch (RuntimeException e) {
            throw new WriteProcessException(e.getMessage());
        }
    }

    @Override
    public void write(String deviceId, String measurement, MeasurementSchema schema, long insertTime, Object objectValue) {
        IWritableMemChunk memSeries = this.createIfNotExistAndGet(deviceId, measurement, schema);
        memSeries.write(insertTime, objectValue);
    }

    @Override
    public void write(InsertTabletPlan insertTabletPlan, int start, int end) {
        for (int i = 0; i < insertTabletPlan.getMeasurements().length; ++i) {
            IWritableMemChunk memSeries = this.createIfNotExistAndGet(insertTabletPlan.getDeviceId(), insertTabletPlan.getMeasurements()[i], insertTabletPlan.getSchemas()[i]);
            memSeries.write(insertTabletPlan.getTimes(), insertTabletPlan.getColumns()[i], insertTabletPlan.getDataTypes()[i], start, end);
        }
    }

    @Override
    public int getSeriesNumber() {
        return this.seriesNumber;
    }

    @Override
    public long getTotalPointsNum() {
        return this.totalPointsNum;
    }

    @Override
    public long size() {
        long sum = 0L;
        for (Map<String, IWritableMemChunk> seriesMap : this.memTableMap.values()) {
            for (IWritableMemChunk writableMemChunk : seriesMap.values()) {
                sum += writableMemChunk.count();
            }
        }
        return sum;
    }

    @Override
    public long memSize() {
        return this.memSize;
    }

    @Override
    public boolean reachTotalPointNumThreshold() {
        if (this.totalPointsNum == 0L) {
            return false;
        }
        return this.totalPointsNum >= this.totalPointsNumThreshold;
    }

    @Override
    public void clear() {
        this.memTableMap.clear();
        this.modifications.clear();
        this.memSize = 0L;
        this.seriesNumber = 0;
        this.totalPointsNum = 0L;
        this.totalPointsNumThreshold = 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.memTableMap.isEmpty();
    }

    @Override
    public ReadOnlyMemChunk query(String deviceId, String measurement, TSDataType dataType, TSEncoding encoding, Map<String, String> props, long timeLowerBound) throws IOException, QueryProcessException {
        if (!this.checkPath(deviceId, measurement)) {
            return null;
        }
        long undeletedTime = this.findUndeletedTime(deviceId, measurement, timeLowerBound);
        IWritableMemChunk memChunk = this.memTableMap.get(deviceId).get(measurement);
        TVList chunkCopy = memChunk.getTVList().clone();
        chunkCopy.setTimeOffset(undeletedTime);
        return new ReadOnlyMemChunk(measurement, dataType, encoding, chunkCopy, props, this.getVersion());
    }

    private long findUndeletedTime(String deviceId, String measurement, long timeLowerBound) {
        long undeletedTime = Long.MIN_VALUE;
        for (Modification modification : this.modifications) {
            Deletion deletion;
            if (!(modification instanceof Deletion) || !(deletion = (Deletion)modification).getDevice().equals(deviceId) || !deletion.getMeasurement().equals(measurement) || deletion.getTimestamp() <= undeletedTime) continue;
            undeletedTime = deletion.getTimestamp();
        }
        return Math.max(undeletedTime + 1L, timeLowerBound);
    }

    @Override
    public void delete(String deviceId, String measurementId, long timestamp) {
        Map<String, IWritableMemChunk> deviceMap = this.memTableMap.get(deviceId);
        if (deviceMap != null) {
            IWritableMemChunk chunk = deviceMap.get(measurementId);
            if (chunk == null) {
                return;
            }
            int deletedPointsNumber = chunk.delete(timestamp);
            this.totalPointsNum -= (long)deletedPointsNumber;
        }
    }

    @Override
    public void delete(Deletion deletion) {
        this.modifications.add(deletion);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public void release() {
        for (Map.Entry<String, Map<String, IWritableMemChunk>> entry : this.memTableMap.entrySet()) {
            for (Map.Entry<String, IWritableMemChunk> subEntry : entry.getValue().entrySet()) {
                TVListAllocator.getInstance().release(subEntry.getValue().getTVList());
            }
        }
    }
}

