/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.flush.pool;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class AbstractPoolManager {
    private static final int WAIT_TIMEOUT = 2000;
    protected ExecutorService pool;

    public void close() {
        Logger logger = this.getLogger();
        this.pool.shutdownNow();
        long totalWaitTime = 2000L;
        logger.info("Waiting for {} thread pool to shut down.", (Object)this.getName());
        while (!this.pool.isTerminated()) {
            try {
                if (!this.pool.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                    logger.info("{} thread pool doesn't exit after {}ms.", (Object)this.getName(), (Object)totalWaitTime);
                }
                totalWaitTime += 2000L;
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting {} thread pool to exit. ", (Object)this.getName(), (Object)e);
            }
        }
    }

    public synchronized Future<?> submit(Runnable task) {
        return this.pool.submit(task);
    }

    public synchronized <T> Future<T> submit(Callable<T> task) {
        return this.pool.submit(task);
    }

    public int getWorkingTasksNumber() {
        return ((ThreadPoolExecutor)this.pool).getActiveCount();
    }

    public int getWaitingTasksNumber() {
        return ((ThreadPoolExecutor)this.pool).getQueue().size();
    }

    public int getTotalTasks() {
        return this.getWorkingTasksNumber() + this.getWaitingTasksNumber();
    }

    public int getCorePoolSize() {
        return ((ThreadPoolExecutor)this.pool).getCorePoolSize();
    }

    public abstract Logger getLogger();

    public abstract void start();

    public abstract void stop();

    public abstract String getName();
}

