/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cache.LRULinkedHashMap;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.common.cache.Accountable;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesMetadataCache {
    private static final Logger logger = LoggerFactory.getLogger(TimeSeriesMetadataCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE = config.getAllocateMemoryForTimeSeriesMetaDataCache();
    private static final boolean CACHE_ENABLE = config.isMetaDataCacheEnable();
    private final LRULinkedHashMap<TimeSeriesMetadataCacheKey, TimeseriesMetadata> lruCache;
    private final AtomicLong cacheHitNum = new AtomicLong();
    private final AtomicLong cacheRequestNum = new AtomicLong();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    private TimeSeriesMetadataCache() {
        if (CACHE_ENABLE) {
            logger.info("TimeseriesMetadataCache size = " + MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE);
        }
        this.lruCache = new LRULinkedHashMap<TimeSeriesMetadataCacheKey, TimeseriesMetadata>(MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE){

            @Override
            protected long calEntrySize(TimeSeriesMetadataCacheKey key, TimeseriesMetadata value) {
                long currentSize;
                if (this.count < 10) {
                    currentSize = RamUsageEstimator.shallowSizeOf((Object)key) + RamUsageEstimator.sizeOf((Object)key.device) + RamUsageEstimator.sizeOf((Object)key.measurement) + RamUsageEstimator.shallowSizeOf((Object)value) + RamUsageEstimator.sizeOf((Object)value.getMeasurementId()) + RamUsageEstimator.shallowSizeOf((Object)value.getStatistics());
                    this.averageSize = (this.averageSize * (long)this.count + currentSize) / (long)(++this.count);
                } else if (this.count < 100000) {
                    ++this.count;
                    currentSize = this.averageSize;
                } else {
                    this.averageSize = RamUsageEstimator.shallowSizeOf((Object)key) + RamUsageEstimator.sizeOf((Object)key.device) + RamUsageEstimator.sizeOf((Object)key.measurement) + RamUsageEstimator.shallowSizeOf((Object)value) + RamUsageEstimator.sizeOf((Object)value.getMeasurementId()) + RamUsageEstimator.shallowSizeOf((Object)value.getStatistics());
                    this.count = 1;
                    currentSize = this.averageSize;
                }
                return currentSize;
            }
        };
    }

    public static TimeSeriesMetadataCache getInstance() {
        return TimeSeriesMetadataCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeseriesMetadata get(TimeSeriesMetadataCacheKey key, Set<String> allSensors) throws IOException {
        if (!CACHE_ENABLE) {
            TsFileSequenceReader reader = FileReaderManager.getInstance().get(key.filePath, true);
            BloomFilter bloomFilter = reader.readBloomFilter();
            if (bloomFilter != null && !bloomFilter.contains(key.device + '.' + key.measurement)) {
                return null;
            }
            return reader.readTimeseriesMetadata(new Path(key.device, key.measurement));
        }
        this.cacheRequestNum.incrementAndGet();
        try {
            this.lock.readLock().lock();
            if (this.lruCache.containsKey(key)) {
                this.cacheHitNum.incrementAndGet();
                this.printCacheLog(true);
                TimeseriesMetadata reader = new TimeseriesMetadata(this.lruCache.get(key));
                return reader;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            this.lock.writeLock().lock();
            if (this.lruCache.containsKey(key)) {
                this.cacheHitNum.incrementAndGet();
                this.printCacheLog(true);
                TimeseriesMetadata reader = new TimeseriesMetadata(this.lruCache.get(key));
                return reader;
            }
            this.printCacheLog(false);
            TsFileSequenceReader reader = FileReaderManager.getInstance().get(key.filePath, true);
            BloomFilter bloomFilter = reader.readBloomFilter();
            if (bloomFilter != null && !bloomFilter.contains(key.device + '.' + key.measurement)) {
                TimeseriesMetadata timeseriesMetadata2 = null;
                return timeseriesMetadata2;
            }
            List timeSeriesMetadataList = reader.readTimeseriesMetadata(key.device, allSensors);
            timeSeriesMetadataList.forEach(timeseriesMetadata -> this.lruCache.put(new TimeSeriesMetadataCacheKey(key.filePath, key.device, timeseriesMetadata.getMeasurementId()), (TimeseriesMetadata)timeseriesMetadata));
            TimeseriesMetadata metadata = this.lruCache.get(key);
            if (metadata == null) {
                TimeseriesMetadata timeseriesMetadata3 = null;
                return timeseriesMetadata3;
            }
            TimeseriesMetadata timeseriesMetadata4 = new TimeseriesMetadata(metadata);
            return timeseriesMetadata4;
        }
        catch (IOException e) {
            logger.error("something wrong happened while reading {}", (Object)key.filePath);
            throw e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void printCacheLog(boolean isHit) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug("[TimeSeriesMetadata cache {}hit] The number of requests for cache is {}, hit rate is {}.", new Object[]{isHit ? "" : "didn't ", this.cacheRequestNum.get(), (double)this.cacheHitNum.get() * 1.0 / (double)this.cacheRequestNum.get()});
    }

    public double calculateTimeSeriesMetadataHitRatio() {
        if (this.cacheRequestNum.get() != 0L) {
            return (double)this.cacheHitNum.get() * 1.0 / (double)this.cacheRequestNum.get();
        }
        return 0.0;
    }

    public long getUsedMemory() {
        return this.lruCache.getUsedMemory();
    }

    public long getMaxMemory() {
        return this.lruCache.getMaxMemory();
    }

    public double getUsedMemoryProportion() {
        return this.lruCache.getUsedMemoryProportion();
    }

    public long getAverageSize() {
        return this.lruCache.getAverageSize();
    }

    public void clear() {
        this.lock.writeLock().lock();
        if (this.lruCache != null) {
            this.lruCache.clear();
        }
        this.lock.writeLock().unlock();
    }

    public void remove(TimeSeriesMetadataCacheKey key) {
        this.lock.writeLock().lock();
        if (key != null) {
            this.lruCache.remove(key);
        }
        this.lock.writeLock().unlock();
    }

    public boolean isEmpty() {
        return this.lruCache.isEmpty();
    }

    private static class TimeSeriesMetadataCacheHolder {
        private static final TimeSeriesMetadataCache INSTANCE = new TimeSeriesMetadataCache();

        private TimeSeriesMetadataCacheHolder() {
        }
    }

    public static class TimeSeriesMetadataCacheKey
    implements Accountable {
        private final String filePath;
        private final String device;
        private final String measurement;
        private long ramSize;

        public TimeSeriesMetadataCacheKey(String filePath, String device, String measurement) {
            this.filePath = filePath;
            this.device = device;
            this.measurement = measurement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeSeriesMetadataCacheKey that = (TimeSeriesMetadataCacheKey)o;
            return Objects.equals(this.filePath, that.filePath) && Objects.equals(this.device, that.device) && Objects.equals(this.measurement, that.measurement);
        }

        public int hashCode() {
            return Objects.hash(this.filePath, this.device, this.measurement);
        }

        public void setRamSize(long size) {
            this.ramSize = size;
        }

        public long getRamSize() {
            return this.ramSize;
        }
    }
}

