/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.IoTDBConfigDynamicAdapter;
import org.apache.iotdb.db.engine.cache.AccountableString;
import org.apache.iotdb.db.engine.cache.LRULinkedHashMap;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkMetadataCache {
    private static final Logger logger = LoggerFactory.getLogger(ChunkMetadataCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long MEMORY_THRESHOLD_IN_B = config.getAllocateMemoryForChunkMetaDataCache();
    private static final boolean CACHE_ENABLE = config.isMetaDataCacheEnable();
    private final LRULinkedHashMap<AccountableString, List<ChunkMetadata>> lruCache;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicLong cacheHitNum = new AtomicLong();
    private final AtomicLong cacheRequestNum = new AtomicLong();

    private ChunkMetadataCache(long memoryThreshold) {
        if (CACHE_ENABLE) {
            logger.info("ChunkMetadataCache size = " + memoryThreshold);
        }
        this.lruCache = new LRULinkedHashMap<AccountableString, List<ChunkMetadata>>(memoryThreshold){

            @Override
            protected long calEntrySize(AccountableString key, List<ChunkMetadata> value) {
                long entrySize;
                if (value.isEmpty()) {
                    return RamUsageEstimator.sizeOf((Object)key) + RamUsageEstimator.shallowSizeOf(value);
                }
                if (this.count < 10) {
                    long currentSize = value.get(0).calculateRamSize();
                    this.averageSize = (this.averageSize * (long)this.count + currentSize) / (long)(++this.count);
                    IoTDBConfigDynamicAdapter.setChunkMetadataSizeInByte(this.averageSize);
                    entrySize = RamUsageEstimator.sizeOf((Object)key) + (currentSize + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF) * (long)value.size() + RamUsageEstimator.shallowSizeOf(value);
                } else if (this.count < 100000) {
                    ++this.count;
                    entrySize = RamUsageEstimator.sizeOf((Object)key) + (this.averageSize + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF) * (long)value.size() + RamUsageEstimator.shallowSizeOf(value);
                } else {
                    this.averageSize = value.get(0).calculateRamSize();
                    this.count = 1;
                    entrySize = RamUsageEstimator.sizeOf((Object)key) + (this.averageSize + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF) * (long)value.size() + RamUsageEstimator.shallowSizeOf(value);
                }
                return entrySize;
            }
        };
    }

    public static ChunkMetadataCache getInstance() {
        return ChunkMetadataCacheSingleton.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChunkMetadata> get(String filePath, Path seriesPath) throws IOException {
        if (!CACHE_ENABLE) {
            TsFileSequenceReader tsFileReader = FileReaderManager.getInstance().get(filePath, true);
            BloomFilter bloomFilter = tsFileReader.readBloomFilter();
            if (bloomFilter != null && !bloomFilter.contains(seriesPath.getFullPath())) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("path not found by bloom filter, file is: %s, path is: %s", filePath, seriesPath));
                }
                return new ArrayList<ChunkMetadata>();
            }
            return tsFileReader.getChunkMetadataList(seriesPath);
        }
        AccountableString key = new AccountableString(filePath + '.' + seriesPath.getDevice() + seriesPath.getMeasurement());
        this.cacheRequestNum.incrementAndGet();
        this.lock.readLock().lock();
        try {
            if (this.lruCache.containsKey(key)) {
                this.cacheHitNum.incrementAndGet();
                this.printCacheLog(true);
                ArrayList<ChunkMetadata> bloomFilter = new ArrayList<ChunkMetadata>((Collection)this.lruCache.get(key));
                return bloomFilter;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.lruCache.containsKey(key)) {
                this.printCacheLog(true);
                this.cacheHitNum.incrementAndGet();
                ArrayList<ChunkMetadata> bloomFilter = new ArrayList<ChunkMetadata>((Collection)this.lruCache.get(key));
                return bloomFilter;
            }
            this.printCacheLog(false);
            TsFileSequenceReader tsFileReader = FileReaderManager.getInstance().get(filePath, true);
            BloomFilter bloomFilter = tsFileReader.readBloomFilter();
            if (bloomFilter != null && !bloomFilter.contains(seriesPath.getFullPath())) {
                ArrayList<ChunkMetadata> arrayList = new ArrayList<ChunkMetadata>();
                return arrayList;
            }
            List<ChunkMetadata> chunkMetaDataList = FileLoaderUtils.getChunkMetadataList(seriesPath, filePath);
            this.lruCache.put(key, chunkMetaDataList);
            ArrayList<ChunkMetadata> arrayList = new ArrayList<ChunkMetadata>(chunkMetaDataList);
            return arrayList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void printCacheLog(boolean isHit) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug("[ChunkMetaData cache {}hit] The number of requests for cache is {}, hit rate is {}.", new Object[]{isHit ? "" : "didn't ", this.cacheRequestNum.get(), (double)this.cacheHitNum.get() * 1.0 / (double)this.cacheRequestNum.get()});
    }

    double calculateChunkMetaDataHitRatio() {
        if (this.cacheRequestNum.get() != 0L) {
            return (double)this.cacheHitNum.get() * 1.0 / (double)this.cacheRequestNum.get();
        }
        return 0.0;
    }

    public long getUsedMemory() {
        return this.lruCache.getUsedMemory();
    }

    public long getMaxMemory() {
        return this.lruCache.getMaxMemory();
    }

    public double getUsedMemoryProportion() {
        return this.lruCache.getUsedMemoryProportion();
    }

    public long getAverageSize() {
        return this.lruCache.getAverageSize();
    }

    public void clear() {
        this.lock.writeLock().lock();
        if (this.lruCache != null) {
            this.lruCache.clear();
        }
        this.lock.writeLock().unlock();
    }

    public void remove(TsFileResource resource) {
        this.lock.writeLock().lock();
        if (resource != null) {
            this.lruCache.entrySet().removeIf(e -> ((AccountableString)e.getKey()).getString().startsWith(resource.getPath()));
        }
        this.lock.writeLock().unlock();
    }

    public boolean isEmpty() {
        return this.lruCache.isEmpty();
    }

    static /* synthetic */ long access$100() {
        return MEMORY_THRESHOLD_IN_B;
    }

    private static class ChunkMetadataCacheSingleton {
        private static final ChunkMetadataCache INSTANCE = new ChunkMetadataCache(ChunkMetadataCache.access$100());

        private ChunkMetadataCacheSingleton() {
        }
    }
}

