/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.auth.entity.PathPrivilege;
import org.apache.iotdb.db.utils.AuthUtils;

public class User {
    private String name;
    private String password;
    private List<PathPrivilege> privilegeList;
    private List<String> roleList;
    private boolean useWaterMark = false;
    private long lastActiveTime;

    public User() {
    }

    public User(String name, String password) {
        this.name = name;
        this.password = password;
        this.privilegeList = new ArrayList<PathPrivilege>();
        this.roleList = new ArrayList<String>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<PathPrivilege> getPrivilegeList() {
        return this.privilegeList;
    }

    public void setPrivilegeList(List<PathPrivilege> privilegeList) {
        this.privilegeList = privilegeList;
    }

    public List<String> getRoleList() {
        return this.roleList;
    }

    public void setRoleList(List<String> roleList) {
        this.roleList = roleList;
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public void setLastActiveTime(long lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    public boolean hasPrivilege(String path, int privilegeId) {
        return AuthUtils.hasPrivilege(path, privilegeId, this.privilegeList);
    }

    public void addPrivilege(String path, int privilegeId) {
        AuthUtils.addPrivilege(path, privilegeId, this.privilegeList);
    }

    public void removePrivilege(String path, int privilegeId) {
        AuthUtils.removePrivilege(path, privilegeId, this.privilegeList);
    }

    public void setPrivileges(String path, Set<Integer> privileges) {
        for (PathPrivilege pathPrivilege : this.privilegeList) {
            if (!pathPrivilege.getPath().equals(path)) continue;
            pathPrivilege.setPrivileges(privileges);
        }
    }

    public boolean hasRole(String roleName) {
        return this.roleList.contains(roleName);
    }

    public Set<Integer> getPrivileges(String path) {
        return AuthUtils.getPrivileges(path, this.privilegeList);
    }

    public boolean checkPrivilege(String path, int privilegeId) {
        return AuthUtils.checkPrivilege(path, privilegeId, this.privilegeList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.lastActiveTime == user.lastActiveTime && this.contentEquals(user);
    }

    private boolean contentEquals(User user) {
        return Objects.equals(this.name, user.name) && Objects.equals(this.password, user.password) && Objects.equals(this.privilegeList, user.privilegeList) && Objects.equals(this.roleList, user.roleList);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.password, this.privilegeList, this.roleList, this.lastActiveTime);
    }

    public boolean isUseWaterMark() {
        return this.useWaterMark;
    }

    public void setUseWaterMark(boolean useWaterMark) {
        this.useWaterMark = useWaterMark;
    }
}

