/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.servicecomb.codec.protobuf.jackson;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;

public class CseObjectReader extends ObjectReader {
  private static final long serialVersionUID = -4154834940923475928L;

  public CseObjectReader(ObjectReader base, FormatSchema schema, JsonDeserializer<Object> rootDeser) {
    super(base, base.getConfig(), null, rootDeser, null, schema, null, null);
  }

  public JsonDeserializer<Object> findDeserializer(JavaType valueType) {
    return _prefetchRootDeserializer(valueType);
  }
}
