<?xml version="1.0" encoding="UTF-8" ?>
<!--

  DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER

  Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.

  Use is subject to license terms.

  Licensed under the Apache License, Version 2.0 (the "License"); you may not
  use this file except in compliance with the License. You may obtain a copy
  of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
  obtain a copy of the License at http://odftoolkit.org/docs/license.txt

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

  See the License for the specific language governing permissions and
  limitations under the License.

-->

<!-- This stylesheet checks whether all element and attributes defined -->
<!-- in the ODF 1.2 schema do also have references and headings in the -->
<!-- ODF 1.2 specification. The element and attribute information is calculated -->
<!-- from a flat ODF schema file whose location must be provided -->
<!-- by the "xref-schema-file" parameter -->


<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"                 
                xmlns:rng="http://relaxng.org/ns/structure/1.0"                
                xmlns:a="http://relaxng.org/ns/compatibility/annotations/1.0"                
                xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0"
                xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0"
                xmlns:config="urn:oasis:names:tc:opendocument:xmlns:config:1.0"
                xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0"
                xmlns:table="urn:oasis:names:tc:opendocument:xmlns:table:1.0"
                xmlns:draw="urn:oasis:names:tc:opendocument:xmlns:drawing:1.0"
                xmlns:presentation="urn:oasis:names:tc:opendocument:xmlns:presentation:1.0"
                xmlns:dr3d="urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0"
                xmlns:chart="urn:oasis:names:tc:opendocument:xmlns:chart:1.0"
                xmlns:form="urn:oasis:names:tc:opendocument:xmlns:form:1.0"
                xmlns:script="urn:oasis:names:tc:opendocument:xmlns:script:1.0"
                xmlns:style="urn:oasis:names:tc:opendocument:xmlns:style:1.0"
                xmlns:number="urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"
                xmlns:anim="urn:oasis:names:tc:opendocument:xmlns:animation:1.0"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:math="http://www.w3.org/1998/Math/MathML"
                xmlns:xforms="http://www.w3.org/2002/xforms"
                xmlns:fo="urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0"
                xmlns:svg="urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0"
                xmlns:smil="urn:oasis:names:tc:opendocument:xmlns:smil-compatible:1.0"
                xmlns="http://relaxng.org/ns/structure/1.0" version="1.0">    
    <xsl:output method="text"/>    
    
    <xsl:param name="xref-schema-file"/>
    <xsl:param name="attributes-heading" select="'General Attributes'"/>

    <xsl:variable name="attribute-prefix" select="'attribute-'"/>
    <xsl:variable name="element-prefix" select="'element-'"/>
    <xsl:variable name="property-prefix" select="'property-'"/>
 
    <xsl:variable name="check-default-values" select="false()"/>

    <xsl:variable name="properties-heading" select="'Formatting Attributes'"/>
    <xsl:variable name="datatypes-heading" select="'Other Datatypes'"/>
    <xsl:variable name="attributes-heading-level" select="'1'"/>

    <!-- ********** -->
    <!-- ** root ** -->
    <!-- ********** -->
    <xsl:template match="office:document-content">  
        <!-- check whether all element and attribute definitions in the schema -->
        <!-- have a section in the specicification -->
        <xsl:message><xsl:value-of select="$attributes-heading"/>:<xsl:value-of select="$attributes-heading-level"/></xsl:message>
        <xsl:apply-templates select="document($xref-schema-file)/rng:grammar/rng:element" mode="check-schema"/>
    </xsl:template>    

    <!-- ***************************************************************** -->
    <!-- check whether all element and attribute definitions in the schema -->
    <!-- have a section in the specicification                             -->
    <!-- ***************************************************************** -->

    <xsl:template match="rng:element" mode="check-schema">
        <xsl:variable name="name" select="@name"/>
        <xsl:variable name="anchor" select="concat($element-prefix,$name)"/>
        <xsl:variable name="refs" select="/office:document-content/office:body/office:text/text:p[starts-with(.,$anchor) and normalize-space(.) = $anchor]"/>
        <xsl:choose>
            <xsl:when test="count($refs) > 1">
                <xsl:text>Multiple anchors found for element &quot;</xsl:text>
                <xsl:value-of select="$name"/>
                <xsl:text>&quot;
</xsl:text>                    
            </xsl:when>
            <xsl:when test="not($refs)">
                <xsl:text>No anchor found for element &quot;</xsl:text>
                <xsl:value-of select="$name"/>
                <xsl:text>&quot;
</xsl:text>        
            </xsl:when>
        </xsl:choose>
        <xsl:variable name="headings" select="/office:document-content/office:body/office:text/text:h[starts-with(.,'&lt;') and contains(.,concat('&lt;',$name, '&gt;')) and not(preceding::text:h[@text:outline-level=$attributes-heading-level]=$attributes-heading)]"/>
        <xsl:choose>
            <xsl:when test="count($headings) > 1">
                <xsl:text>Multiple headings found for element &quot;</xsl:text>
                <xsl:value-of select="$name"/>
                <xsl:text>&quot;
</xsl:text>                    
            </xsl:when>
            <xsl:when test="not($headings)">
                <xsl:if test="$refs">
                    <xsl:text>Warning: Anchor but </xsl:text>
                </xsl:if>
                <xsl:text>No heading found for element &quot;</xsl:text>
                <xsl:value-of select="$name"/>
                <xsl:text>&quot;
</xsl:text>        
            </xsl:when>
        </xsl:choose>
        <xsl:apply-templates select=".//rng:attribute" mode="check-schema">
            <xsl:with-param name="element-name" select="$name"/>
        </xsl:apply-templates>
    </xsl:template>   
    
    
    <xsl:template match="rng:attribute" mode="check-schema">
        <xsl:param name="element-name"/>
        <xsl:variable name="name" select="@name"/>
        <xsl:variable name="fp" select="starts-with($element-name,'style:') and contains($element-name,'-properties')"/>
        <xsl:variable name="anchor">
            <xsl:choose>
                <xsl:when test="$fp"><xsl:value-of select="concat($property-prefix,$name)"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="concat($attribute-prefix,$name)"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
            
        <!-- TODO: for element names within attribute anchors only a start-with comparison takes place -->
        <xsl:variable name="refs" select="/office:document-content/office:body/office:text/text:p[starts-with(.,$anchor) and ((normalize-space(.) = $anchor) or (starts-with(.,concat($anchor,'_')) and contains(concat(normalize-space(.),'_'),concat('_',$element-prefix,$element-name,'_'))))]"/>
        <xsl:choose>
            <xsl:when test="count($refs) > 1">
                <xsl:text>Multiple anchors found for attribute &quot;</xsl:text>
                <xsl:value-of select="$name"/>
                <xsl:text>&quot;, element &lt;</xsl:text>
                <xsl:value-of select="$element-name"/>
                <xsl:text>&gt;: </xsl:text>
                <xsl:value-of select="$refs"/><xsl:text>
</xsl:text>                    
            </xsl:when>
            <xsl:when test="not($refs)">
                <xsl:text>No anchor found for attribute &quot;</xsl:text>
                <xsl:value-of select="$name"/>
                <xsl:text>&quot;, element &lt;</xsl:text>
                <xsl:value-of select="$element-name"/>
                <xsl:text>&gt;
</xsl:text>        
            </xsl:when>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="$fp">
                <xsl:variable name="headings" select="/office:document-content/office:body/office:text/text:h[(.=$name or starts-with(.,concat($name,' '))) and (preceding::text:h[@text:outline-level=$attributes-heading-level][last()]=$properties-heading)]"/>
                <xsl:choose>
                    <xsl:when test="count($headings) > 1">
                        <xsl:text>Multiple headings found for formatting property attribute &quot;</xsl:text>
                        <xsl:value-of select="$name"/>
                        <xsl:text>&quot;
</xsl:text>                    
                    </xsl:when>
                    <xsl:when test="$headings">
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="$refs">
                            <xsl:text>Warning: Anchor but </xsl:text>
                        </xsl:if>
                        <xsl:text>No heading found for formatting property attribute &quot;</xsl:text>
                        <xsl:value-of select="$name"/>
                        <xsl:text>&quot;
</xsl:text>                    
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="headings" select="/office:document-content/office:body/office:text/text:h[(.=$name or starts-with(.,concat($name,' '))) and (preceding::text:h[@text:outline-level=$attributes-heading-level][last()]=$attributes-heading)]"/>
                <xsl:choose>
                    <xsl:when test="count($headings) > 1">
                        <xsl:text>Multiple headings found for attribute &quot;</xsl:text>
                        <xsl:value-of select="$name"/>
                        <xsl:text>&quot;
</xsl:text>                    
                    </xsl:when>
                    <xsl:when test="$headings">
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="$refs">
                            <xsl:text>Warning: Anchor but </xsl:text>
                        </xsl:if>
                        <xsl:text>No heading found for attribute &quot;</xsl:text>
                        <xsl:value-of select="$name"/>
                        <xsl:text>&quot;
</xsl:text>                    
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:if test="$check-default-values and @a:defaultValue">
                    <xsl:apply-templates select="$headings" mode="check-default">
                        <xsl:with-param name="element-name" select="$element-name"/>
                        <xsl:with-param name="attribute-name" select="$name"/>
                        <xsl:with-param name="defaultValue" select="@a:defaultValue"/>
                    </xsl:apply-templates>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>   
    
    <xsl:template match="text:h" mode="check-default">
        <xsl:param name="attribute-name"/>
        <xsl:param name="element-name"/>
        <xsl:param name="defaultValue"/>
        <xsl:variable name="id" select="generate-id(.)"/>
        <xsl:variable name="defs" select="following-sibling::text:p[@text:style-name='Default_20_Value' and generate-id(preceding-sibling::text:h[position()=1]) = $id]"/>
        <xsl:choose>
            <xsl:when test="$defs">
                <xsl:variable name="defs2" select="$defs[text:span[@text:style-name='Attribute_20_Value' and . = $defaultValue]]"/>
                <xsl:choose>
                    <xsl:when test="$defs2">
                        <xsl:apply-templates select="$defs2" mode="check-default">
                            <xsl:with-param name="heading" select="."/>
                            <xsl:with-param name="element-name" select="$element-name"/>
                            <xsl:with-param name="attribute-name" select="$attribute-name"/>
                            <xsl:with-param name="defaultValue" select="$defaultValue"/>
                        </xsl:apply-templates>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>Default definitions for heading &quot;</xsl:text>
                        <xsl:value-of select="."/>
                        <xsl:text>&quot; do not contain a default value &quot;</xsl:text>
                        <xsl:value-of select="$defaultValue"/>
                        <xsl:text>&quot; (</xsl:text>
                        <xsl:value-of select="$element-name"/>
                        <xsl:text>/</xsl:text>
                        <xsl:value-of select="$attribute-name"/>
                        <xsl:text>=&quot;</xsl:text>
                        <xsl:value-of select="$defaultValue"/>
                        <xsl:text>&quot;)
</xsl:text>                    
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Heading &quot;</xsl:text>
                <xsl:value-of select="."/>
                <xsl:text>&quot; does not have default definitions (</xsl:text>
                <xsl:value-of select="$element-name"/>
                <xsl:text>/</xsl:text>
                <xsl:value-of select="$attribute-name"/>
                <xsl:text>=&quot;</xsl:text>
                <xsl:value-of select="$defaultValue"/>
                <xsl:text>&quot;)
</xsl:text>                    
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="text:p[text:span[@text:style-name='Element']]" mode="check-default">
        <xsl:param name="heading"/>
        <xsl:param name="attribute-name"/>
        <xsl:param name="element-name"/>
        <xsl:param name="defaultValue"/>
        <xsl:variable name="element" select="concat('&lt;',$element-name,'&gt;')"/>
        <xsl:if test="not(text:span[@text:style-name='Element' and .=$element])">
            <xsl:text>Default definitions for heading &quot;</xsl:text>
            <xsl:value-of select="$heading"/>
            <xsl:text>&quot; and default value &quot;</xsl:text>
            <xsl:value-of select="$defaultValue"/>
            <xsl:text>&quot; do not include element &quot;</xsl:text>
            <xsl:value-of select="$element-name"/>
            <xsl:text>&quot; (</xsl:text>
            <xsl:value-of select="$element-name"/>
            <xsl:text>/</xsl:text>
            <xsl:value-of select="$attribute-name"/>
            <xsl:text>=&quot;</xsl:text>
            <xsl:value-of select="$defaultValue"/>
            <xsl:text>&quot;)
</xsl:text>                    
        </xsl:if>
    </xsl:template>

    <xsl:template match="text:p" mode="check-default"/>
    
</xsl:stylesheet>
