/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfxsltrunnertask;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.odftoolkit.odfxsltrunner.Logger;
import org.odftoolkit.odfxsltrunner.ODFXSLTRunner;
import org.odftoolkit.odfxsltrunner.XSLTParameter;
import org.odftoolkit.odfxsltrunnertask.AntLogger;

public class ODFXSLTRunnerTask
extends Task {
    private File m_aStyleSheet = null;
    private File m_aInput = null;
    private File m_aInputFile = null;
    private File m_aOutput = null;
    private File m_aOutputFile = null;
    private String m_aPath = "content.xml";
    private Vector<XSLTParameter> m_aParams = null;
    private Factory m_aFactory = null;
    boolean m_bForce = false;
    boolean m_bTemplate = false;

    public void setIn(File aIn) {
        this.m_aInput = aIn;
    }

    public void setInFile(File aInFile) {
        this.m_aInputFile = aInFile;
    }

    public void setOut(File aOut) {
        this.m_aOutput = aOut;
    }

    public void setOutFile(File aOutFile) {
        this.m_aOutputFile = aOutFile;
    }

    public void setStyle(File aStyle) {
        this.m_aStyleSheet = aStyle;
    }

    public void setTemplate(boolean bTemplate) {
        this.m_bTemplate = bTemplate;
    }

    public void setForce(boolean bForce) {
        this.m_bForce = bForce;
    }

    public Param createParam() {
        Param aParam = new Param();
        if (this.m_aParams == null) {
            this.m_aParams = new Vector();
        }
        this.m_aParams.add(aParam);
        return aParam;
    }

    public Factory createFactory() {
        this.m_aFactory = new Factory();
        return this.m_aFactory;
    }

    public void execute() throws BuildException {
        File aParentFile;
        if (this.m_aStyleSheet == null) {
            throw new BuildException("style attribute must be set", this.getLocation());
        }
        if (!this.m_aStyleSheet.exists()) {
            throw new BuildException("style sheet " + this.m_aStyleSheet.getAbsolutePath() + " does not exist", this.getLocation());
        }
        int m_aInputMode = 1;
        if (this.m_aInput == null && this.m_aInputFile == null) {
            throw new BuildException("in or infile attribute must be set", this.getLocation());
        }
        if (this.m_aInput != null && this.m_aInputFile != null) {
            throw new BuildException("in and infile attributes must not be set simultaneously", this.getLocation());
        }
        if (this.m_aInputFile != null) {
            this.m_aInput = this.m_aInputFile;
            m_aInputMode = 0;
        }
        if (!this.m_aInput.exists()) {
            throw new BuildException("input file " + this.m_aInput.getAbsolutePath() + " does not exist", this.getLocation());
        }
        int m_aOutputMode = 3;
        if (this.m_aOutput == null && this.m_aOutputFile == null) {
            throw new BuildException("out or outfile attribute must be set", this.getLocation());
        }
        if (this.m_aOutput != null && this.m_aOutputFile != null) {
            throw new BuildException("out and outfile attribute must not be set simultaneously", this.getLocation());
        }
        if (this.m_bTemplate && this.m_aOutput == null) {
            throw new BuildException("out attribute must be set if template attribute is set", this.getLocation());
        }
        if (this.m_aOutputFile != null) {
            this.m_aOutput = this.m_aOutputFile;
            m_aOutputMode = 0;
        } else if (this.m_bTemplate) {
            m_aOutputMode = 4;
            if (!this.m_aOutput.exists()) {
                throw new BuildException("output file " + this.m_aStyleSheet.getAbsolutePath() + " does not exist", this.getLocation());
            }
        }
        if (this.m_aParams != null) {
            for (XSLTParameter aParam : this.m_aParams) {
                if (aParam.getName() == null) {
                    throw new BuildException("parameter name attribute must be set", this.getLocation());
                }
                if (aParam.getValue() != null) continue;
                throw new BuildException("parameter expression attribute must be set", this.getLocation());
            }
        }
        String aFactory = null;
        if (this.m_aFactory != null && (aFactory = this.m_aFactory.getName()) == null) {
            throw new BuildException("factory name attribute must be set", this.getLocation());
        }
        if (!this.m_bForce && this.m_aOutput.exists() && this.m_aOutput.lastModified() > this.m_aInput.lastModified() && this.m_aOutput.lastModified() > this.m_aStyleSheet.lastModified()) {
            return;
        }
        if (!this.m_aOutput.exists() && (aParentFile = this.m_aOutput.getParentFile()) != null) {
            Mkdir aMKDir = (Mkdir)this.getProject().createTask("mkdir");
            aMKDir.setDir(aParentFile);
            aMKDir.init();
            aMKDir.setLocation(this.getLocation());
            aMKDir.execute();
        }
        boolean bError = false;
        try {
            ODFXSLTRunner aRunner = new ODFXSLTRunner();
            AntLogger aLogger = new AntLogger(this.getProject());
            bError = aRunner.runXSLT(this.m_aStyleSheet, this.m_aParams, this.m_aInput, m_aInputMode, this.m_aOutput, m_aOutputMode, this.m_aPath, aFactory, null, (Logger)aLogger);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        if (bError) {
            throw new BuildException("transformation failed", this.getLocation());
        }
    }

    public static class Factory {
        private String m_aName = null;

        Factory() {
        }

        public void setName(String aName) {
            this.m_aName = aName;
        }

        public String getName() {
            return this.m_aName;
        }
    }

    public static class Param
    implements XSLTParameter {
        private String m_aName = null;
        private String m_aValue = null;

        Param() {
        }

        public void setName(String aName) {
            this.m_aName = aName;
        }

        public void setExpression(String aValue) {
            this.m_aValue = aValue;
        }

        public String getName() {
            return this.m_aName;
        }

        public String getValue() {
            return this.m_aValue;
        }
    }
}

