/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.license;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.netbeans.license.LicensePanel;
import org.netbeans.util.Util;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;

public final class AcceptLicense {
    private static String command;

    public static void showLicensePanel() throws Exception {
        Util.setDefaultLookAndFeel();
        URL url = AcceptLicense.class.getResource("LICENSE.txt");
        if (url == null) {
            return;
        }
        LicensePanel licensePanel = new LicensePanel(url);
        ResourceBundle bundle = NbBundle.getBundle(AcceptLicense.class);
        String yesLabel = bundle.getString("MSG_LicenseYesButton");
        String noLabel = bundle.getString("MSG_LicenseNoButton");
        JButton yesButton = new JButton();
        JButton noButton = new JButton();
        AcceptLicense.setLocalizedText(yesButton, yesLabel);
        AcceptLicense.setLocalizedText(noButton, noLabel);
        yesButton.setActionCommand("yes");
        noButton.setActionCommand("no");
        yesButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_AcceptButton"));
        yesButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSD_AcceptButton"));
        noButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_RejectButton"));
        noButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSD_RejectButton"));
        Dimension yesPF = yesButton.getPreferredSize();
        Dimension noPF = noButton.getPreferredSize();
        int maxWidth = Math.max(yesButton.getPreferredSize().width, noButton.getPreferredSize().width);
        int maxHeight = Math.max(yesButton.getPreferredSize().height, noButton.getPreferredSize().height);
        yesButton.setPreferredSize(new Dimension(maxWidth, maxHeight));
        noButton.setPreferredSize(new Dimension(maxWidth, maxHeight));
        final JDialog d = new JDialog(null, bundle.getString("MSG_LicenseDlgTitle"), Dialog.ModalityType.APPLICATION_MODAL);
        Util.initIcons(d);
        d.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_LicenseDlg"));
        d.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_LicenseDlg"));
        d.getContentPane().add((Component)licensePanel, "Center");
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command = e.getActionCommand();
                d.setVisible(false);
            }
        };
        yesButton.addActionListener(listener);
        noButton.addActionListener(listener);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(17, 12, 11, 11));
        buttonPanel.add(yesButton);
        buttonPanel.add(noButton);
        d.getContentPane().add((Component)buttonPanel, "South");
        d.setSize(new Dimension(600, 600));
        d.setDefaultCloseOperation(2);
        d.setResizable(true);
        d.getRootPane().setDefaultButton(yesButton);
        d.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "exit");
        d.getRootPane().getActionMap().put("exit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command = "no";
                d.setVisible(false);
            }
        });
        licensePanel.jEditorPane1.getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "accept");
        licensePanel.jEditorPane1.getActionMap().put("accept", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command = "yes";
                d.setVisible(false);
            }
        });
        d.setLocationRelativeTo(null);
        d.setVisible(true);
        if ("yes".equals(command)) {
            return;
        }
        throw new UserCancelException();
    }

    private static void setLocalizedText(AbstractButton button, String text) {
        if (text == null) {
            button.setText(null);
            return;
        }
        int i = AcceptLicense.findMnemonicAmpersand(text);
        if (i < 0) {
            button.setText(text);
            button.setMnemonic(0);
        } else {
            button.setText(text.substring(0, i) + text.substring(i + 1));
            if (Utilities.isMac()) {
                return;
            }
            char ch = text.charAt(i + 1);
            button.setMnemonic(ch);
            button.setDisplayedMnemonicIndex(i);
        }
    }

    public static int findMnemonicAmpersand(String text) {
        int i = -1;
        do {
            if ((i = text.indexOf(38, i + 1)) < 0 || i + 1 >= text.length() || text.charAt(i + 1) == ' ' || text.charAt(i + 1) == '\'' && i > 0 && text.charAt(i - 1) == '\'') continue;
            return i;
        } while (i >= 0);
        return -1;
    }
}

